<?php

$admin_valid = new admin_valid;



$mod->registerEvent("parseConfig", "eventReadConfig", $admin_valid);
$mod->registerEvent("playerJoined", "eventJoin", $admin_valid);
$mod->registerEvent("playerQuit", "eventQuit", $admin_valid);
$mod->registerEvent("everyTime", "everyTime", $admin_valid);

class admin_valid {

    public $class;
    public $groups = array();
    private $logging = false;
    private $players = false;
    private $mod = false;

    public function __construct() {
        $this->logging = & $GLOBALS["logging"];
        $this->players = & $GLOBALS['players'];
        $this->mod = & $GLOBALS['mod'];
        //+++++++++++++++++++++++++++++++server ip ändern++++++++++++++++++++++++++++
        $ip = "127.0.0.1";
        $port = "8009";
        $this->class = new admin_socket($ip, $port);
        if (!file_exists("./" . $this->mod->getConfigDir() . "/plugins/admin_groups.txt")) {
            fclose(fopen("./" . $this->mod->getConfigDir() . "/plugins/admin_groups.txt", "w+"));
        }
        $file = file("./" . $this->mod->getConfigDir() . "/plugins/admin_groups.txt");
        foreach ($file as $lines) {
            $datas = explode(":", $lines);
            $this->groups[$datas["0"]]["group"] = $datas["1"];
            $this->groups[$datas["0"]]["protected"] = $datas["2"];
            $this->groups[$datas["0"]]["hash"] = str_replace("\n", "", $datas["3"]);
            $this->groups[$datas["0"]]["ip"] = FALSE;
        }


        foreach ($this->groups as $guid => $value) {
            $this->mod->deleteAdmin($guid);
        }
    }

    function everyTime() {
        $newsock = $this->class->connections();

        if ($newsock) {
            $ip = $this->class->ip($newsock);

            $hash = str_replace("\n", "", $this->class->receive($newsock));
            $guid = substr($hash, "32", "32");
            $md5hash = substr($hash, "0", "32");
            $ghash = substr($hash, "-32");

            echo $guid . "\n";
            echo $md5hash . "\n";
            echo $this->groups[$guid]["hash"] . "\n";
            echo $ghash . "\n";
            echo md5($md5hash . $guid) . "\n";

            if ($md5hash != $this->groups[$guid]["hash"] || $ghash != md5($md5hash . $guid)) {
                $this->class->send("Fehler übertragung\n", $newsock);
            } else {

                $this->class->send("Guid empfangen\n", $newsock);

                if (array_key_exists($guid, $this->groups)) {
                    $this->groups[$guid]["ip"] = $ip;
                    $this->class->send("Admin IP eingetragen\n", $newsock);
                    $this->logging->write(MOD_NOTICE, "Guid($guid) von $ip als Admin registriert");


                    if (array_key_exists($guid, $this->players)) {
                        $status = $this->mod->rconPlayerList();
                        foreach ($status as $line) {
                            if ($line["pid"] == $this->players[$guid]->getPid() || $line["guid"] == $guid) {
                                $ip = $line["ip"];
                                break;
                            }
                        }
                        if ($ip == $this->groups[$guid]["ip"]) {
                            $this->players[$guid]->setGroup($this->groups[$guid]["group"]);
                            if ($this->groups[$guid]["protected"] == 1) {
                                $this->players[$guid]->serProtection(true);
                                $this->logging->write(MOD_NOTICE, "Guid($guid) neue Gruppe {$this->groups[$guid]["group"]}");
                            }
                        }
                    }
                } else {
                    $this->logging->write(MOD_NOTICE, "Fehler be Autentifiziereung von Guid($guid) von $ip");
                }
            }
        }
    }

    public function eventReadConfig() {
        $file = file("./" . $this->mod->getConfigDir() . "/plugins/admin_groups.txt");
        foreach ($file as $lines) {
            $datas = explode(":", $lines);
            $this->groups[$datas["0"]]["group"] = $datas["1"];
            $this->groups[$datas["0"]]["protected"] = $datas["2"];
            $this->groups[$datas["0"]]["hash"] = str_replace("\n", "", $datas["3"]);
        }
    }

    public function eventJoin($guid) {
        $ip = false;
        $status = $this->mod->rconPlayerList();
        foreach ($status as $line) {
            if ($line["pid"] == $this->players[$guid]->getPid() || $line["guid"] == $guid) {
                $ip = $line["ip"];
                break;
            }
        }
        if (array_key_exists($guid, $this->groups) && $ip == $this->groups[$guid]["ip"]) {
            $this->players[$guid]->setGroup($this->groups[$guid]["group"]);
            if ($this->groups[$guid]["protected"] == 1) {
                $this->players[$guid]->serProtection(true);
                $this->logging->write(MOD_NOTICE, "Guid($guid) neue Gruppe {$this->groups[$guid]["group"]}");
            }
        }
    }

    public function eventQuit($guid) {
        $status = $this->mod->rconPlayerList();
        foreach ($status as $line) {
            if ($line["pid"] == $this->players[$guid]->getPid() || $line["guid"] == $guid) {
                $ip = $line["ip"];
                break;
            }
        }
        if (array_key_exists($guid, $this->groups)) {
            $this->players[$guid]->setProtection(false);

            $this->players[$guid]->setGroup("default");
            $this->groups[$guid]["ip"] = false;
        }
    }

}

class admin_socket {

    public $clients = array();
    public $read = array();
    public $socketServer = array();
    private $logging = false;
    private $players = false;
    private $mod = false;

    /**
     * 
     * @param string $ip
     * @param int $port
     * @return  
     */
    function __construct($ip, $port) {

        $this->logging = & $GLOBALS["logging"];
        $this->players = & $GLOBALS['players'];
        $this->mod = & $GLOBALS['mod'];

        $this->socketServer = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

        if (!$this->socketServer) {
            $this->logging->write(MOD_ERROR, socket_strerror(socket_last_error()));
            return array("0001", socket_strerror(socket_last_error()));
        }
        if (!socket_bind($this->socketServer, $ip, $port)) {
            $this->logging->write(MOD_ERROR, socket_strerror(socket_last_error()));
            return array("0002", socket_strerror(socket_last_error()));
        }
        if (!socket_listen($this->socketServer)) {
            $this->logging->write(MOD_ERROR, socket_strerror(socket_last_error()));
            return array("0003", socket_strerror(socket_last_error()));
        }
        if (!socket_set_nonblock($this->socketServer)) {
            $this->logging->write(MOD_ERROR, socket_strerror(socket_last_error()));
            return array("0004", socket_strerror(socket_last_error()));
        }

        $this->clients = array($this->socketServer);
        $this->logging->write(MOD_NOTICE, "Admin Valid is ready to use");
        return $this->socketServer;
    }

    /**
     *
     * @return boolean 
     */
    public function connections() {
        // create a copy, so $this->clients doesn't get modified by socket_select()
        $this->read = $this->clients;

        // get a list of all the clients that have data to be read from
        // if there are no clients with data, go to next iteration
        $except = NULL;
        $write = NULL;
        if (socket_select($this->read, $write, $except, 0) < 1) {
            return false;
        }

        // check if there is a client trying to connect
        if (in_array($this->socketServer, $this->read)) {
            // accept the client, and add him to the $this->clients array
            $newsocket = socket_accept($this->socketServer);
            $this->clients[] = $newsocket;
        }

        // remove the listening socket from the clients-with-data array
        $key = array_search($this->socketServer, $this->read);
        unset($this->read[$key]);
        if (@$key)
            return false;
        if (!@$newsocket)
            return false;
        $this->logging->write(MOD_NOTICE, "New Admin connection: {$this->ip($newsocket)}");
        return $newsocket;
    }

    /**
     *
     * @param type $msg
     * @param type $sock 
     */
    public function send($msg, $sock = FALSE) {
        if ($sock != FALSE) {
            socket_write($sock, $msg);
        } else {
            foreach ($this->clients as $socket) {
                if ($socket === $this->clients["0"])
                    continue;
                socket_write($socket, $msg);
            }
        }
    }

    /**
     *
     * @param type $login
     * @param type $loginsocket
     * @return type 
     */
    public function receive($read_sock) {


        $data = @socket_read($read_sock, 1024, PHP_NORMAL_READ);
        $data = trim($data);
        if (!empty($data)) {
            return $data;
        }
//        //   foreach ($this->read as $read_sock) {
//        // read until newline or 1024 bytes
//        $data = @socket_read($read_sock, 1024, PHP_NORMAL_READ);
//        // socket_read while show errors when the client is disconnected, so silence the error messages
//        // check if the client is disconnected
//        if ($data === false) {
//            // remove client for $this->clients array
//            $this->clearlisten($read_sock, 1);
//
//            // continue to the next client to read from, if any
//            return false;
//        }
//
//        // trim off the trailing/beginning white spaces
//        $data = trim($data);
//        if (empty($data)) {
//            return false;
//        }
//        $ID = array_keys($this->clients, $read_sock);
//        $ID = $ID["0"];
//
//        return $data;
//        //     }
    }

    /**
     *
     * @param type $sock
     * @return boolean 
     */
    public function ip($sock) {
        if (in_array($sock, $this->clients)) {
            socket_getpeername($sock, $ip);
            return $ip;
        }
        else
            return false;
    }

    /**
     *
     * @param type $sock
     * @param type $delclient 
     */
    private function clearlisten($sock, $delclient = false) {
        if ($delclient) {
            $key = array_search($sock, $this->clients);
            unset($this->clients[$key]);
            unset($this->users[$key]);
        }
        // remove the listening socket from the clients-with-data array
        $key = array_search($sock, $this->read);
        unset($this->read[$key]);
    }

}

?>