<?php
/**
 * GSManager
 *
 * This is a mighty and platform independent software for administrating game servers of various kinds.
 * If you need help with installing or using this software, please visit our website at: www.gsmanager.de
 * If you have licensing enquiries e.g. related to commercial use, please contact us at: sales@gsmanager.de
 *
 * @copyright Greenfield Concept UG (haftungsbeschränkt)
 * @license GSManager EULA <https://www.gsmanager.de/eula.php>
 * @version 1.1.0
**/

namespace GSM\Plugins\Rules;

use GSM\Daemon\Core\Utils;

/**
 * Automessages plugin
 *
 * sends auto messages messages all x seconds
 *
 */
class Rules extends Utils {
    /**
     * Inits the plugin
     *
     * This function initiates the plugin. This means that it register commands
     * default values, and events. It's important that every plugin has this function
     * Otherwise the plugin exists but can't be used
     */
    public function initPlugin() {
        parent::initPlugin();

        $this->config->setDefault('rules', 'enabled', false);
        $this->config->setDefault('rules', 'messages', array());
        $this->config->setDefault('rules', 'showonjoin', false);
        $this->config->setDefault('rules', 'showonjoindelay', 5);
    }

    public function enable() {
        parent::enable();

        $this->events->register('playerJoined', [$this, 'playerJoined']);
        $this->commands->register('rules', false, "send", $this);
    }

    public function disable() {
        parent::disable();

        $this->events->unregister('playerJoined', [$this, 'playerJoined']);
        $this->commands->unregister('rules');
    }

    public function playerJoined($guid) {
        if (!$this->config->get('rules', 'showonjoin')) {
            return false;
        }
        $this->jobs->addSingleJob($this->config->get('rules', 'showonjoindelay'), function() use ($guid) {
            foreach ($this->config->get('rules', 'messages') as $message) {
                $this->players[$guid]->say(trim($message));
            }
        });
    }

    /**
     * This Plugin sends the Message and adds new job
     *
     * @return false on fail
     */
    public function send($guid, $parameters) {
        if ($this->players[$guid]->getGroup() != "default") {
            foreach ($this->config->get('rules', 'messages') as $message) {
                $this->rcon->rconSay(trim($message));
            }
        } else {
            foreach ($this->config->get('rules', 'messages') as $message) {
                $this->players[$guid]->say(trim($message));
            }
        }
    }
}
