/*
 * admin_valid_client
 *
 * Sends the guid and password to the admin_valid plugin.
 * The password will be hashed (md5) before transmitting.
 *
 * author: Yenz
 * contact: via manuadminmod.de
 * version: 1.0
 * build: 3
 * licence: Creative Commons, BY-NC-SA http://creativecommons.org/licenses/by-nc-sa/3.0/
 */

#include <windows.h>
#include <winsock2.h>
#include <stdio.h>
#include "md5.h"

#define BUFFER_LENGTH 1024 // length of both temp and sending char array

/*
 * Function: str2md5
 * -----------------
 * Computes the md5 hash for a string.
 *
 * str: char array
 * length: length of the string
 * out: char array, md5 hash will be written into it (minimum length: 33),
 *      can be the same as str
 */
void str2md5(char * str, int length, char * out)
{
	unsigned char digest[16];
	int n;
	MD5_CTX ctx;
	
	MD5_Init(&ctx);
	MD5_Update(&ctx, str, length);
	MD5_Final(digest, &ctx);
	
	for (n = 0; n < 16; n++)
	{
		sprintf(&out[n * 2], "%02x", (unsigned int)digest[n]);
	}
}

int main(int argc, char* argv[])
{
	long rc; // return code (used for multiple function calls)
	int port; // port of the admin_valid plugin
	SOCKET s;
	SOCKADDR_IN addr;
	char buf[BUFFER_LENGTH]; // temp buffer
	char out[BUFFER_LENGTH]; // sending buffer

	// check paramter count
	if (argc != 5)
	{
		printf("usage: %s ip port guid passwort\n", argv[0]);
		printf("example: %s 10.11.12.13 8009 123...def secure\n", argv[0]);
		exit(1);
	}
	
	// convert port parameter
	port = atoi(argv[2]);
	if (port == 0)
	{
		printf("error: port must be between 1 and 65535\n");
		exit(1);
	}
	
	// convert ip address
	memset(&addr, 0, sizeof(SOCKADDR_IN)); // set everything to 0
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr.s_addr = inet_addr(argv[1]);
	if (addr.sin_addr.s_addr == INADDR_NONE)
	{
		printf("error: ip must be in format a.b.c.d\n");
		exit(1);
	}
	
	// fill sending buffer (in php it would be: md5($pw) . md5(md5($pw) . $guid) . $guid . "\n")
	str2md5(argv[4], strlen(argv[4]), buf);
	strcpy(out, buf);
	strcat(buf, argv[3]);
	str2md5(buf, strlen(buf), buf);
	strcat(out, buf);
	strcat(out, argv[3]);
	strcat(out, "\n");
	
	// start winsock
	WSADATA wsa;
	rc = WSAStartup(MAKEWORD(2, 0), &wsa);
	if(rc != 0)
	{
		printf("error: starting winsock failed\n");
		exit(1);
	}

	// create socket
	s = socket(AF_INET, SOCK_STREAM, 0);
	if(s == INVALID_SOCKET)
	{
		printf("error: creating socket failed\n");
		exit(1);
	}
	
	// connect
	rc = connect(s, (SOCKADDR*)&addr, sizeof(SOCKADDR));
	if(rc == SOCKET_ERROR)
	{
		printf("error: connecting failed\n");
		exit(1);
	}
	
	// transmit sending buffer
	rc = send(s, out, strlen(out), 0);
	if (rc == SOCKET_ERROR)
	{
		printf("error: sending guid failed\n");
	}
	else
	{
		printf("sent \"%s\"\n", out);
	}
	memset(buf, '\0', BUFFER_LENGTH);

	// receive answer
	rc = recv(s, buf, BUFFER_LENGTH, 0);
	if (rc == SOCKET_ERROR)
	{
		printf("error: receiving answer failed\n");
	}
	else
	{
		printf("answer: %s\n", buf);
	}

	// cleanup and exit
	closesocket(s);
	WSACleanup();
	exit(0);
}
