<?php

/**
 * With this plugin you're able to declare a function that will be run in the future.
 * In the meantime the MAM is running in the usual way.
 *
 * Usage:
 * deferredJobs::add(3, array($mod, "rconSay"), array("whatever you want to say"));
 *
 * Syntax:
 * deferredJobs::add($sec, $callback, array $parameters = array())
 * $sec = time in seconds in which the callback will be executed, float possible (1.5)
 * $callback = a valid callback, see http://www.php.net/manual/en/language.types.callable.php
 * $parameters = optional array with parameters for the callback function
 *
 * Possible callbacks (examples):
 * "global_user_function"
 * "banner_send"
 * array($mod, "rconKickAll");
 * array($players, "kick");
 *
 * @author: Yenz
 * @version: 1.0
 */

$deferredJobs = new deferredJobs();

$mod->registerEvent("everyTime", "everyTime", $deferredJobs);

class deferredJobs {
	private static $jobs = array();
	
	public static function add($sec, $callback, array $parameters = array()) {
		self::$jobs[] = array(
			"time" => microtime(true) + $sec,
			"callback" => $callback,
			"parameters" => $parameters
		);
	}
	
	public function everyTime() {
		for ($i = 0; $i < count(self::$jobs); $i++) {
			if (self::$jobs[$i]["time"] < microtime(true)) {
				call_user_func_array(self::$jobs[$i]["callback"], self::$jobs[$i]["parameters"]);
				unset(self::$jobs[$i]);
			}
		}
		self::$jobs = array_values(self::$jobs);
	}
}
