<?php
/**
 * Anti Namesteal Plugin
 * This plugin will kick a player, if he is stealing somebody's other name.
 *
 * @author Yenz
 * @license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
 * @version 1.0
 */

$antiNamesteal = new antiNamesteal();

$mod->registerEvent("playerJoined", "eventHandler", $antiNamesteal);
$mod->registerEvent("playerNameChange", "eventHandler", $antiNamesteal);

class antiNamesteal
{
	public function __construct()
	{
		// nothing to do
	}
	
	public function eventHandler($param)
	{
		global $players, $logging;
		
		if (is_array($param))
		{
			$guid = $param[0]; //playerChangeName event
		}
		else
		{
			$guid = $param; //playerJoined event
		}
		
		foreach ($players as $player)
		{
			if ($player->getGuid() != $guid && $player->getName() == $players[$guid]->getName())
			{
				$logging->write(MOD_NOTICE, "antiNamesteal: player uses somebody's other name, kick him");
				$players[$guid]->kick("namesteal");
			}
		}
	}
}
