<?php
/**
 * Anti Multi GUID Plugin
 * This plugin will kick a joining player if another player with his guid is already on the server.
 *
 * @author Yenz
 * @license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
 * @version 1.0
 */

$antiMultiGuid = new antiMultiGuid();

$mod->registerEvent("playerPIDChange", "playerPIDChange", $antiMultiGuid);

class antiMultiGuid
{
	public function __construct()
	{
		// nothing to do
	}
	
	public function playerPIDChange($param)
	{
		global $mod, $logging;
		
		$guid = $param[0];
		$old_pid = $param[1];
		$new_pid = $param[2];
		
		$logging->write(MOD_NOTICE, "antiMultiGuid: playerPIDChange, GUID: $guid, old_pid: $old_pid, new_pid: $new_pid");
		$logging->write(MOD_NOTICE, "antiMultiGuid: kick new player id and sync playerlist");
		
		$mod->rconRcon("clientkick $new_pid");
		
		$mod->syncPlayerlist();
	}
}
