<?php
/**
 * Change Game Plugin
 * This file contains the class for the Change Game Plugin and manage the mod to call
 * the user functions !changegame.
 * 
 * Commands:
 *      !changegame game
 *          Change the game to game and restart the map.
 * 
 * Config (example):
 *      [changegame]
 *      enabled = 1
 *      games = "main,night"
 *      main_logfile = "../mods/nomod/games_mp.log"
 *      main_fs_game = "mods/nomod"
 *      night_logfile = "../mods/night/games_mp.log"
 *      night_fs_game = "mods/night"
 * 
 * @author silva202
 * @license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
 * @version 1.0
 */

$changeGame = new changeGame();

// events and commands
$mod->registerCommand("changegame", false, "commandChangeGame", $changeGame);

// default CVars
$mod->setDefaultCV("changegame", "enabled", 0);
$mod->setDefaultCV("changegame", "games", "");


/**
 * The Change Game Plugin class offers the command for changing the game to an(other) mod.
 */
class changeGame {
    
    /**
     * It sets the fs_game dvar and restart the map via rcon following by the recreation
	 * of the parser object, giving it the new game's logfile.
     */
    public function commandChangeGame($guid, $parameters) {
        global $mod, $players, $parser, $logging;
        
        if ($mod->getCV("changegame", "enabled") != 1) {
            return;
        }
		
		$games = explode(",", $mod->getCV("changegame", "games"));
        
		if (count($parameters) != 1 || !in_array($parameters[0], $games)) {
			$players[$guid]->say("Usage: !changegame " . str_replace(",", "|", $mod->getCV("changegame", "games")));
			return false;
		}
        
        $game = $parameters[0];
		$logfile = $mod->getCV("changegame", $game . "_logfile");
		$fs_game = $mod->getCV("changegame", $game . "_fs_game");
		
		// fs_game and map_restart
		$logging->write(MOD_NOTICE, "Change fs_game and restart map");
        $mod->rconRcon("fs_game \"$fs_game\"");
		$mod->rconRcon("map_restart");
		
		// recreate parser with specific logfile
		$success = false;
		if (!$mod->getCV("ftp", "enabled")) {
			$logging->write(MOD_NOTICE, "Recreation of parser");
			$parser = new parser($logfile, $success);
		} else {
			$logging->write(MOD_NOTICE, "Recreation of parser_ftp");
			$parser = new parser_ftp($logfile, $success, $mod->getCV("ftp", "host"), $mod->getCV("ftp", "user"), $mod->getCV("ftp", "password"), $mod->getCV("ftp", "port"), (bool)(int)$mod->getCV("ftp", "passive"));
		}
		if (!$success) {
			$logging->write(MOD_ERROR, "Couldn't open server's logfile: '$logfile'");
		}
    }

}
