<?php
/*

PLUGIN: B3 Poweradmin
=============
Plugin for the Servermod b3_poweradmin (z_svr_b3.iwd) by xlr8or.
If you are using OpenWarfare MOD just "set scr_b3_poweradmin_enable 1" in configs/server/others.cfg:89

CONFIG "config/plugins/poweradmin.cfg"
------
[poweradmin]
defaultshocktime = 7        ;The Default time for !shock in seconds
maxshocktime = 60			;The highest possible shocktime in seconds

CONTACT
------
xfire: ganxta222
email: mam@sky-e.de

*/


$poweradmin = new poweradmin();

$mod->setDefaultCV("poweradmin",	"defaultshocktime",	7	);
$mod->setDefaultCV("poweradmin",	"maxshocktime",		60	);

//                    COMMAND       SYNTAX                      FUNCTION		OBJECT
$mod->registerCommand("saybold",	'~^saybold .+$~i' ,			"saybold",		$poweradmin);
$mod->registerCommand("endmap",		false ,						"endmap",		$poweradmin);
$mod->registerCommand("shock",		'~^shock \S.*$~i' ,			"shock",		$poweradmin);
$mod->registerCommand("burn",		'~^burn \S.*$~i' ,			"burn",			$poweradmin);
$mod->registerCommand("explode",	'~^explode \S.*$~i' ,		"explod",		$poweradmin);
$mod->registerCommand("rename",		'~^rename \S.*$~i' ,		"rename",		$poweradmin);
$mod->registerCommand("putspec",	'~^putspec \S.*$~i' ,		"putspec",		$poweradmin);
$mod->registerCommand("switch",		'~^switch \S.*$~i' ,		"swtch",		$poweradmin);
$mod->registerCommand("switchall",	false ,						"switchall",	$poweradmin);
$mod->registerCommand("putspecall",	false ,						"putspecall",	$poweradmin);
$mod->registerCommand("kill",		'~^kill \S.*$~i' ,			"kill",			$poweradmin);



class poweradmin {

	private $players = array();
	private $mod = false;
	
	public function __construct() {
		$this->players = &$GLOBALS['players'];
		$this->mod = &$GLOBALS['mod'];
	}
	
	public function saybold($guid, $params) {
		$this->mod->rconSetDvar("b3_saybold", implode(" ", $params));
	}
	
	public function endmap($guid, $params) {
		$this->mod->rconSetDvar("b3_endmap", "1");
	}
	
	public function shock($guid, $params) {
		$parastring = implode(" ",$params);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $params) = explode("\\", $params);
	        $player = trim($player);
	        $params = array(trim($params));
	    }
	    else {
		    $player = array_shift($params);
	    }
		
		$toshock = $this->mod->findPlayerGuid($player);

		if (!$toshock) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
			if ($this->players[$toshock]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantEffectProtected"));
		        return false;
		    }
			if (!empty($params)) {
			    if (is_numeric($params[0]) && $params[0] > 0) {
			        $time = array_shift($params);
					if ($time > $this->mod->getCV("poweradmin", "maxshocktime")) {
						$time = $this->mod->getCV("poweradmin", "maxshocktime");
					}
			    }
			    else {
			        $time = $this->mod->getCV("poweradmin", "defaultshocktime");
			    }
			}
			else {
				$time = $this->mod->getCV("poweradmin", "defaultshocktime");
			}
			$this->players[$toshock]->say($this->mod->getLngString("pa_shock", array("<DURATION>"), array($time)));
			$this->mod->rconSetDvar("b3_shocktime", $time);
			$this->mod->rconSetDvar("b3_shock", $this->players[$toshock]->getPID());
		}
	}
	
	public function burn($guid, $params) {
		$parastring = implode(" ",$params);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $params) = explode("\\", $params);
	        $player = trim($player);
	        $params = array(trim($params));
	    }
	    else {
		    $player = array_shift($params);
	    }
		
		$toburn = $this->mod->findPlayerGuid($player);
		
		if (!$toburn) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
			if ($this->players[$toburn]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantEffectProtected"));
		        return false;
		    }
			$this->players[$toburn]->say($this->mod->getLngString("pa_burn"));
			$this->mod->rconSetDvar("b3_burn", $this->players[$toburn]->getPID());
		}
	}
	
	public function explod($guid, $params) {
		$parastring = implode(" ",$params);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $params) = explode("\\", $params);
	        $player = trim($player);
	        $params = array(trim($params));
	    }
	    else {
		    $player = array_shift($params);
	    }
		
		$toexplode = $this->mod->findPlayerGuid($player);
		
		if (!$toexplode) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
			if ($this->players[$toexplode]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantEffectProtected"));
		        return false;
		    }
		    $this->players[$toexplode]->say($this->mod->getLngString("pa_explode"));
			$this->mod->rconSetDvar("b3_explode", $this->players[$toexplode]->getPID());
		}
	}
	
	public function rename($guid, $params) {
		$search = array_shift($params);
	    $newname = implode(" ", $params);
		
	    $torename = $this->mod->findPlayerGuid($search);
	    if (!$player) {
	        $this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($params)));
	        return false;
	    } elseif (!$newname) {
			$this->players[$guid]->say($this->mod->getLngString("pa_needname"));
		}
		if ($this->players[$torename]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantEffectProtected"));
		        return false;
		    }
	    $this->players[$torename]->say($this->mod->getLngString("pa_needname", array("<NEWNAME>"), array($newname)));
		$this->mod->rconSetDvar("b3_rname", $newname);
		$this->mod->rconSetDvar("b3_rcid", $this->players[$torename]->getPID());
	}
	
	public function putspec($guid, $params) {
		$parastring = implode(" ",$params);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $params) = explode("\\", $params);
	        $player = trim($player);
	        $params = array(trim($params));
	    }
	    else {
		    $player = array_shift($params);
	    }
		
		$toputspec = $this->mod->findPlayerGuid($player);
		
		if (!$toputspec) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
			if ($this->players[$toputspec]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantEffectProtected"));
		        return false;
		    }
			$this->players[$toputspec]->say($this->mod->getLngString("pa_putspec"));
			$this->mod->rconSetDvar("g_switchspec", $this->players[$toputspec]->getPID());
		}
	}
	
	public function swtch($guid, $params) {
		$parastring = implode(" ",$params);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $params) = explode("\\", $params);
	        $player = trim($player);
	        $params = array(trim($params));
	    }
	    else {
		    $player = array_shift($params);
	    }
		
		$toswitch = $this->mod->findPlayerGuid($player);
		
		if (!$toswitch) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
			if ($this->players[$toswitch]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantEffectProtected"));
		        return false;
		    }
			$this->players[$toswitch]->say($this->mod->getLngString("pa_switch"));
			$this->mod->rconSetDvar("g_switchteam", $this->players[$toswitch]->getPID());
		}
	}
	
	public function switchall($guid, $params) {
		$this->mod->rconSay($this->mod->getLngString("pa_switchall"));
		$this->mod->rconSetDvar("g_switchteam", -1);
	}
	
	public function putspecall($guid, $params) {
		$this->mod->rconSay($this->mod->getLngString("pa_putspecall"));
		$this->mod->rconSetDvar("g_switchspec", -1);
	}
	
	public function kill($guid, $params) {
		$parastring = implode(" ",$params);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $params) = explode("\\", $params);
	        $player = trim($player);
	        $params = array(trim($params));
	    }
	    else {
		    $player = array_shift($params);
	    }
		
		$tokill = $this->mod->findPlayerGuid($player);
		
		if (!$tokill) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
			if ($this->players[$tokill]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantEffectProtected"));
		        return false;
		    }
			$this->players[$tokill]->say($this->mod->getLngString("pa_kill"));
			$this->mod->rconSetDvar("g_killplayer", $this->players[$tokill]->getPID());
		}
	}

}


?>