<?php

namespace GSM\Plugins\Antihack;

use GSM\Daemon\Core\Utils;

class Antihack extends Utils {

    public function initPlugin() {
        parent::initPlugin();

        $this->config->setDefault('antihack', 'enabled', true);
        $this->config->setDefault('antihack', 'maxdetects', 2);
        $this->config->setDefault('antihack', 'message', 'You got kicked for hacking');

        array_map(array($this, 'playerInit'), array_keys($this->players));
    }

    public function enable() {
        parent::enable();
        $this->events->register('playerSay', 'anticheatDetect', $this);
        $this->events->register('playerJoined', 'playerInit', $this);
    }

    public function disable() {
        parent::disable();

        $this->events->unregister('playerSay', 'anticheatDetect', $this);
        $this->events->unregister('playerJoined', 'playerInit', $this);
    }

    /**
     * Inits a Player
     *
     * @param string $guid
     */
    public function playerinit($guid) {
        $this->players[$guid]->hack_detector = 0;
        $this->players[$guid]->hack_lastmsg = '';
    }

    /**
     * Checks if a player sends a obv. message
     *
     * @param array $args $guid $message $executed
     * @return false on fail
     */
    function anticheatDetect($args) {
        list($guid, $message, $executed) = $args;

        $detectstrings = array();
        $detectstrings[] = '^7just got owned by ^2k^7oncept COD4';
        $detectstrings[] = 'got raped by ^1!^7Evil-Hook^1!';
        $detectstrings[] = '^7] ^1Was Killed By ^7[ ';


        if ($this->permissions->isPlayerAllowed($guid, 'antihack.ignore')) {
            return false;
        }

        //Is $tofind in the message?
        foreach ($detectstrings as $tofind) {
            $pos_concept = strpos($message, $tofind);
            if ($pos_concept !== false) {
                break;
            }
        }

        //Check if it is a only a bind or not
        if ($pos_concept !== false && $this->players[$guid]->hack_lastmsg != $message) {
            $this->players[$guid]->hack_detector++;
            $this->players[$guid]->hack_lastmsg = $message;

            if ($this->players[$guid]->hack_detector == $this->config->get('antihack', 'maxdetects')) {
                $this->players[$guid]->ban($this->config->get('antihack', 'message'));
            }
        }
    }

}
