<?php
/**
 * GSManager
 *
 * This is a mighty and platform independent software for administrating game servers of various kinds.
 * If you need help with installing or using this software, please visit our website at: www.gsmanager.de
 * If you have licensing enquiries e.g. related to commercial use, please contact us at: sales@gsmanager.de
 *
 * @copyright Greenfield Concept UG (haftungsbeschränkt)
 * @license GSManager EULA <https://www.gsmanager.de/eula.php>
 * @version 1.0.3
**/

namespace GSM\Plugins\ExtendedCommands;

use GSM\Daemon\Core\Utils;

class ExtendedCommands extends Utils {

    public function initPlugin() {
        parent::initPlugin();

        $this->config->setDefault('extendedcommands', 'enabled', false);
    }

    public function enable() {
        parent::enable();

        $this->commands->register('kill',       '~^kill \S.*$~i',       'kill',     $this);
        $this->commands->register('wtf',        '~^wtf \S.*$~i',        'wtf',      $this);
        $this->commands->register('drop',       '~^drop \S.*$~i',       'drop',     $this);
        $this->commands->register('bounce',     '~^bounce \S.*$~i',     'bounce',   $this);
        $this->commands->register('move',       '~^move \S.*$~i',       'move',     $this);
        $this->commands->register('cmd',        '~^cmd \S.*$~i',        'cmd',      $this);
        $this->commands->register('msg',        '~^msg \S.*$~i',        'msg',      $this);
        $this->commands->register('getguid',    '~^getguid \S.*$~i',    'getguid',  $this);
    }

    public function disable() {
        parent::disable();

        $this->commands->unregister('kill');
        $this->commands->unregister('wtf');
        $this->commands->unregister('drop');
        $this->commands->unregister('bounce');
        $this->commands->unregister('move');
        $this->commands->unregister('cmd');
        $this->commands->unregister('msg');
        $this->commands->unregister('getguid');
    }

    public function kill($guid, $parameters) {
        $from = $this->players[$guid];
        $target = $this->mod->findPlayerGuid($parameters[0]);
        if($target === false) {
            $from->say($this->language->get('daemon.playerNotFound', ['<SEARCH>'], [$parameters[0]]));
            return;
        }
        $target = $this->players[$target];
        array_shift($parameters);

        $this->rcon->rcon('set admin kill:' . $target->getPID());
        $this->rcon->rconSay('^1Player ^7' . $target->getName()
            . ' ^1was killed by ^7' . $from->getName() . ' ^1for reason '
            . implode(' ', $parameters) . '!');

    }

    public function wtf($guid, $parameters) {
        $from = $this->players[$guid];
        $target = $this->mod->findPlayerGuid($parameters[0]);
        if($target === false) {
            $from->say($this->language->get('daemon.playerNotFound', ['<SEARCH>'], [$parameters[0]]));
            return;
        }
        $target = $this->players[$target];
        array_shift($parameters);

        $this->rcon->rcon('set admin wtf:' . $target->getPID());
        $from->say('^1WTF ^7executed.');
    }

    public function bounce($guid, $parameters) {
        $from = $this->players[$guid];
        $target = $this->mod->findPlayerGuid($parameters[0]);
        if($target === false) {
            $from->say($this->language->get('daemon.playerNotFound', ['<SEARCH>'], [$parameters[0]]));
            return;
        }
        $target = $this->players[$target];
        array_shift($parameters);

        $this->rcon->rcon('set admin bounce:' . $target->getPID());
        $from->say('^1Bounce ^7executed.');
    }

    public function drop($guid, $parameters) {
        $from = $this->players[$guid];
        $target = $this->mod->findPlayerGuid($parameters[0]);
        if($target === false) {
            $from->say($this->language->get('daemon.playerNotFound', ['<SEARCH>'], [$parameters[0]]));
            return;
        }
        $target = $this->players[$target];
        array_shift($parameters);

        $this->rcon->rcon('set admin drop:' . $target->getPID());
        $from->say('^1Drop weapon ^7executed.');
    }

    public function move($guid, $parameters) {
        $from = $this->players[$guid];
        $target = $this->mod->findPlayerGuid($parameters[0]);
        if($target === false) {
            $from->say($this->language->get('daemon.playerNotFound', ['<SEARCH>'], [$parameters[0]]));
            return;
        }
        $target = $this->players[$target];
        array_shift($parameters);
        $direction = $parameters[0];

        if($direction === 'spec' || $direction === 'auto') {
            $this->rcon->rconSay('^1Player ^7' . $target->getName() . ' ^1was moved to ^7'
                . $direction .'.');
            $this->rcon->rcon('set admin move:' . $target->getPID() . ':' . $direction);
        } else {
            $from->say('Allowed Groups: auto|spec|axis|allies. Try again!');
        }
    }

    public function cmd($guid, $parameters) {
        $from = $this->players[$guid];
        $target = $this->mod->findPlayerGuid($parameters[0]);
        if($target === false) {
            $from->say($this->language->get('daemon.playerNotFound', ['<SEARCH>'], [$parameters[0]]));
            return;
        }
        $target = $this->players[$target];
        array_shift($parameters);
        $cmd = implode(' ', $parameters);

        $return = $this->rcon->rcon('set admin cmd:' . $target->getPID() . ':' . $cmd);
        $return = preg_replace('#(\r\n|\r|\n)#', "\n", $return);
        $return = implode("\n", array_slice(explode("\n", $say), 0, 6));

        $from->say($return);
    }

    public function msg($guid, $parameters) {
        $this->rcon->rcon('set admin msg:' . implode(' ', $parameters));
        $this->players[$guid]->say('^1Message was ^7sent.');
    }

    public function getguid($guid, $parameters) {
        $from = $this->players[$guid];
        $target_guid = $this->mod->findPlayerGuid($parameters[0]);
        if($target === false) {
            $from->say($this->language->get('daemon.playerNotFound', ['<SEARCH>'], [$parameters[0]]));
            return;
        }
        $target = $this->players[$target_guid];

        $from->say('^1The GUID of ^7' . $target->getName() . ' ^1is ^7' . $target_guid . '.');

        $timestamp = date('[d.m.y H:i:s]');

        $handle = fopen($this->registry->args['logdir'] . DIRECTORY_SEPARATOR . 'guids.log', 'a');
        fwrite($handle, $timestamp . ' ' . $target->getName() . ':' . $target_guid . PHP_EOL);
        fclose($handle);
    }
}