<?php
/*
PLUGIN: VAS
================
Interaction with Vote&AdminSystem for MW2
Used to kick, ban and tempban from VAS menu
created by Dimnik_u11

*/

	global $mod;

	if (!$mod->getCV("ftp", "enabled")) {
		$vasparser = new parser($mod->getCV("main", "logfile"), $success);
	}
	else {
		$vasparser = new parser_ftp($mod->getCV("main", "logfile"), $success, $mod->getCV("ftp", "host"), $mod->getCV("ftp", "user"), $mod->getCV("ftp", "password"), $mod->getCV("ftp", "port"), (bool)(int)$mod->getCV("ftp", "passive"));
	}
	if (!$success) {
		$logging->write(MOD_ERROR, "Couldn't open server's logfile: '".$mod->getCV("main", "logfile")."'");
		return;
	}

	$logging->write(MOD_NOTICE, "--- VAS plugin: Start processing loglines... ---");
	
	$mod->setDefaultCV("vas", "banlistfile", $mod->getConfigDir() . "/plugins/banlist.txt");
	$mod->setDefaultCV("vas", "enableban", 0);
	$mod->setDefaultCV("vas", "logging", 0);

	
	$banlistfile = $mod->getCV("vas", "banlistfile");
	$srvlogfile = $mod->getCV("main", "logfile");
	$logenable = $mod->getCV("vas", "logging");

	$mod->registerEvent("everyTime", "vas_check");
	$mod->registerEvent("playerJoined", "ban_check");


function vas_check() {
	global $logging;
	
	$vas_command = getLine();
	if ($vas_command === false){
		return;
	}
	$action = $vas_command["action"];
	$parts = $vas_command["parts"];
	vas_execute($action,$parts); 

}

function getLine() {
	global $logging;
	global $vasparser;
	global $logenable;

    clearstatcache();

	$newlines = $vasparser->getNewLines();
	foreach ($newlines as $line) {
		//$logging->write(MOD_NOTICE, "VAS: New line. $line");
		$pattern_abs = '|^\s*(\d+) |';
		$pattern_rel = '|^\s*(\d+):(\d{2}) |';

		if (preg_match($pattern_rel, $line, $subpatterns)) {
            $timestamp = 60 * $subpatterns[1] + $subpatterns[2];
		}
		elseif (preg_match($pattern_abs, $line, $subpatterns)) {
            $timestamp = $subpatterns[1];
		}
		else {
		    return false;
		}
		$line = trim(str_replace($subpatterns[0], "", $line));
		
		if (strpos($line, "VAS") === 0) {
			$line = trim(str_replace("VAS;", "", $line));
			if($logenable) $logging->write(MOD_NOTICE, "VAS: $line");
			if (strpos($line, "execute") === 0) {
				$line = trim(str_replace("execute;", "", $line));
				//$logging->write(MOD_NOTICE, "VAS: execute in line. $line");				
				$vas_action = vas_getAction($line);
				$vas_parts = vas_ParseParts($line);
				return array(
				"action" => $vas_action,
				"parts" => $vas_parts,
				);	
			}
		}
	}
	return false;
}

function vas_ParseParts($line) {
	$parts = explode(";", $line);
	array_shift($parts);
	return $parts;
}

function vas_getAction($line) {
		$vas_actions = array(
			"kick" => "kick;",
			"ban" => "ban;",
			"tempban" => "tempban;",
			"warning" => "warning;"
		);
		foreach ($vas_actions as $key => $value) {
			if (strpos($line, $value) === 0) {
				return $key;
			}
		}
		return "unknown";

}

function vas_execute($action,$parts) {
	//global $players;
	global $mod;
	global $logging;
	global $banlistfile;
	$rcon = & $GLOBALS['rcon'];

	//list($except_guid, $except_pid, $except_name, $except_reason, $except_by) = $parts;

	switch ($action) {
		case "kick":
			//"VAS - guid ; name ; reason ; kickby
			list($except_guid, $except_pid, $except_name, $except_reason, $except_by, $adminname) = $parts;
			//list($kick_guid, $kick_pid, $kick_name, $kick_reason, $kickby) = $parts;
			$toclient = "kicked for reason: " . $except_reason .  " (" . $except_by . ")";
			$logging->write(MOD_NOTICE, "VAS: command kick - player '$except_name', PID: $except_pid, GUID: $except_guid, reason: $toclient");				
			$rcon->rcon("clientkick " . $except_pid . " " . $toclient );
			$mod->triggerEvent("playerKicked", array($except_guid, $except_reason));
			break;
			
		case "tempban":
			//"VAS - guid ; name ; reason ; by
			list($except_guid, $except_pid, $except_name, $except_reason, $except_by, $adminname) = $parts;
 			//list($tban_guid, $tban_pid, $tban_name, $tban_reason, $tbanby) = $parts;
			$toclient = "tempbanned for reason: " . $except_reason .  " (" . $except_by . ")";
			$logging->write(MOD_NOTICE, "VAS: command tempban - player '$except_name', PID: $except_pid, GUID: $except_guid, reason: $toclient");				
			$rcon->rcon("tempBanClient " . $except_pid . " " . $toclient);
			$mod->triggerEvent("playerTempBanned", array($except_guid, $except_reason));
			break;

		case "ban":
			list($except_guid, $except_pid, $except_name, $except_reason, $except_by, $adminname) = $parts;
			$toclient = "banned for reason: " . $except_reason .  " (" . $except_by . ")";
			$logging->write(MOD_NOTICE, "VAS: command ban - player '$except_name', PID: $except_pid, GUID: $except_guid, reason: $toclient");				
			$rcon->rcon("tempBanClient " . $except_pid . " " . $toclient);
			$date = date("[d.m.y H:i:s]");
			$str = "$date Player \"$except_name\" ($except_guid) got BANNED for reason: $except_reason ($except_by)\n";
			$banlistfile_filehandle = fopen($banlistfile, "a");
			fwrite($banlistfile_filehandle, $str);
			fclose($banlistfile_filehandle);
			
			$mod->triggerEvent("playerBanned", array($except_guid, $except_reason));
			break;
		
		case "warning":
			
		default:
			return;
	}
	
}

function ban_check($guid) {

	global $players;
	global $mod;
	global $logging;
	$rcon = & $GLOBALS['rcon'];
	global $banlistfile;

	
	if (!$mod->getCV("vas", "enableban")) {
		return false;
	}

    //$ret = false; 
    if (($cont = file_get_contents($banlistfile)) === FALSE) return false;
    $findguidpos = strpos($cont, $guid);
	if ($findguidpos !== false) {
		$endstr = strpos($cont, chr(10), $findguidpos);
		$resonestart = strpos($cont, "reason:", $findguidpos);
		//$reasone = substr($cont, $resonestart, $endstr-$resonestart);
		$reasone = str_replace("reason: ", "" ,substr($cont, $resonestart, $endstr-$resonestart));

		$pid = $players[$guid]->getPID();
		$rcon->rcon("tempBanClient " . $pid . " " . $reasone);
		
		//$players[$guid]->kick("Autokick! BANED for $reasone");
		$logging->write(MOD_NOTICE, "BANCHECK: Player '".$players[$guid]->getName()."' guid: ($guid) was TempBanned. Stored reasone: '$reasone'");
	}

}

//}
?>