<?php
class GameServerList {
    private $database = array('host' => 'localhost', 'user' => '', 'pass' => '', 'db' => '');
    private $databaseHandler = NULL;
    private $gameserver = array('ip' => NULL, 'port' => NULL, 'game' => NULL, 'timeout' => 2);
    private $gameserverHandler = NULL;
    public function __construct($db, $gs) {
        $this -> database = array_merge($this -> database, $db);
        $this -> gameserver = array_merge($this -> gameserver, $gs);
        $this -> connect();
    }

    public function __destruct() {
        $this -> disconnect();
    }

    public function connect() {
        if (!isset($this -> databaseHandler)) {
            $this -> databaseHandler = @new mysqli($this -> database['host'], $this -> database['user'], $this -> database['pass'], $this -> database['db']);
            if ($this -> databaseHandler -> connect_errno) {
                throw new Exception($this -> databaseHandler -> connect_error, $this -> databaseHandler -> connect_errno);
            }
        }

        if (!isset($this -> gameserverHandler)) {
            $this -> gameserverHandler = @fsockopen("udp://" . $this -> gameserver['ip'], $this -> gameserver['port'], $errno, $errstr, 5);
            if (!$this -> gameserverHandler) {
                throw new Exception($errstr, $errno);
            }

            if (!stream_set_timeout($this -> gameserverHandler, $this -> gameserver['timeout'])) {
                throw new Exception("stream_set_timeout");
            }

            if (!stream_set_blocking($this -> gameserverHandler, true)) {
                throw new Exception("stream_set_blocking");
            }
        }
    }

    public function disconnect() {
        if (isset($this -> databaseHandler)) {
            $this -> databaseHandler -> close();
        }
        if (isset($this -> gameserverHandler)) {
            fclose($this -> gameserverHandler);
        }
    }

    private function allowToReport() {
        $this -> connect();
        $result = $this -> databaseHandler -> query("SELECT timestamp FROM wcf1_serverlist WHERE ip = '" . $this -> gameserver['ip'] . "' AND port = " . $this -> gameserver['port'] . " AND timestamp >= " . (time() - 55));
        if ($result -> num_rows) {
            return false;
        } else {
            return true;
        }
        $result -> close();
    }

    private function isListed() {
        $this -> connect();
        $result = $this -> databaseHandler -> query("SELECT timestamp FROM wcf1_serverlist WHERE ip = '" . $this -> gameserver['ip'] . "' AND port = " . $this -> gameserver['port']);
        if ($result -> num_rows) {
            return true;
        } else {
            return false;
        }
        $result -> close();
    
    }

    public function getInformation() {
        switch ($this->gameserver['game']) {
            case 'cod4' :
                fwrite($this -> gameserverHandler, "\xFF\xFF\xFF\xFFgetstatus\x00");
                $raw = fread($this -> gameserverHandler, 4096);

                $raw = trim($raw);

                if (!$raw) {
                    throw new Exception("Gameserver unreadable");
                }

                $raw = explode("\n", $raw);
                $rawsetting = explode("\\", $raw[1]);

                for ($i = 1; $i < count($rawsetting); $i++) {
                    $rawsetting[$i] = strtolower($rawsetting[$i]);
                    $rawsetting[$i + 1] = $rawsetting[$i + 1];
                    $output[$rawsetting[$i]] = $rawsetting[$i + 1];
                    $i++;
                }

                $output['player'] = array();
                for ($i = 2; $i < count($raw); $i++) {
                    list($score, $ping, $name) = explode(" ", $raw[$i], 3);
                    if ($ping != 0 && $ping != 999) {
                        $setting['player'][$i - 1]['score'] = $score;
                        $setting['player'][$i - 1]['ping'] = $ping;
                        $setting['player'][$i - 1]['name'] = substr(preg_replace("/\^./", "", $name), 1, -1);
                    }
                }
                break;

            default :
                throw new Exception("not Supported Gameserver");
                break;
        }
        return $output;
    }

    public function save() {
        if (!$this -> allowToReport()) {
            throw new Exception("Too fast Report");
        }
        switch ($this->gameserver['game']) {
            case 'cod4'  : 
            case 'cod2'  :
            case 'cod5'  :
            case 'cod2uo':
                $information = $this -> getInformation();

                //TODO: remake                        /*  $information['gamename'] == "Call of Duty 4" && */
                if (isset($information['gamename']) && 
                    isset($information['sv_hostname']) && is_string($information["sv_hostname"]) && !empty($information["sv_hostname"]) &&
                    isset($information['player']) && is_array($information["player"]) &&
                    isset($information['sv_maxclients']) && is_numeric($information["sv_maxclients"]) &&
                    isset($information['sv_privateclients']) && is_numeric($information["sv_privateclients"]) &&
                    isset($information['mapname']) && is_string($information["mapname"]) &&
                    isset($information['g_gametype']) && is_string($information["g_gametype"]) &&
                    isset($information['sv_punkbuster']) && ($information["sv_punkbuster"] == 0 || $information["sv_punkbuster"] == 1) &&
                    isset($information['mod']) && ($information["mod"] == 0 || $information["mod"] == 1) &&
                    isset($information['pswrd']) && ($information["pswrd"] == 0 || $information["pswrd"] == 1) &&
                    isset($information['shortversion']) 
                    ) {                                 /* && ($information["shortversion"] == "1.7" || $information["shortversion"] == "1.0") */
                    
                    if($this->isListed == false) {
                    $this -> databaseHandler -> query("INSERT INTO wcf1_serverlist VALUES ('" . $this->gameserver['ip'] . "', " . $this->gameserver['port'] . ", " . time() . ", '" . $this->gameserver['game'] . "', '" . base64_encode(json_encode($information)) . "')");
                    } else if($this->isListed == true) {
                    $this -> databaseHandler -> query("UPDATE wcf1_serverlist SET timestamp='" . time() . "' , game='" . $this->gameserver['game'] . "', value='" . base64_encode(json_encode($information)) . "' WHERE ip = '" . $this -> gameserver['ip'] . "' AND port = " . $this -> gameserver['port']);
                    
                    
                    }
                } else {
                    throw new Exception("not supported serverversion or variables at the moment");
                }
                break;

            default :
                throw new Exception("not Supported Gameserver");
                break;
        }
    }

}

//class ende


function getMysqlConnectData() {
    $mysqli = array('host' => 'localhost', 'user' => '', 'pass' => '', 'db' => '');
    if (file_exists('connect.php')) {
        include_once 'connect.php';
    } else if (file_exists('wcf/config.inc.php')) {
        include ('wcf/config.inc.php');
        $mysqli = array('host' => $dbHost, 'user' => $dbUser, 'pass' => $dbPassword, 'db' => $dbName);
    } else {
        throw new Exception("no connection data found");
    }
    return $mysqli;
}

function isValidNetwork($type, $string) {
    if ($string === NULL) {
        return false;
    }
    switch ($type) {
        case 'ip' :
            return preg_match("/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\z/", $string);
            break;

        case 'port' :
            return preg_match("/^\d{2,5}\z/", $string);
            break;

        case 'ip:port' :
            return preg_match("/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\:\d{2,5}\z/", $string);
            break;

        default :
            throw new Exception("no Network type defined");
            break;
    }
}

function get($var) {
    return isset($_GET[$var]) ? $_GET[$var] : NULL;
}

function logServer($error) {
        $logHandler = fopen("report.log", 'a');
        if (!$logHandler) {
            //throw new Exception("server can't save for add support");
            die("server can't save for add support");
        }
        fwrite($logHandler, "[" . get('ip') . ":" . get("port") . "@" . get("game") . "]" . $error . "\n");
        fclose($logHandler);
}

try {
    if (!isValidNetwork("ip", get("ip"))) {
        throw new Exception("ip has wrong syntax or is not set");
    }
    if (!isValidNetwork("port", get("port"))) {
        throw new Exception("port has wrong syntax or is not set");
    }
    if (!in_array(get("game"), array('cod4', 'cod2', 'cod5', 'cod2uo'))) {
        throw new Exception("game not allowed or not supported");
    } else {
        $GameServer = new GameServerList(getMysqlConnectData(), array('ip' => get("ip"), 'port' => get("port"), 'game' => get("game")));
        $GameServer -> save();
    }
    echo "SUCCESS";
} catch (Exception $e) {
    logServer($e -> getMessage() . " (Debug: " . $e -> getCode() . "at" . $e -> getLine() . ")");
    echo "ERROR: " . $e -> getMessage() . " (Debug: " . $e -> getCode() . "at" . $e -> getLine() . ")";
}
?>
