<?php

namespace wcf\page;

use wcf\system\WCF;
use wcf\util\StyleUtil;

class ServerlistPage extends AbstractPage {

  //  const AVAILABLE_DURING_OFFLINE_MODE = SIMPLE_PAGE_ENABLE_OFFLINEMODE;

    /**
     * @see        wcf\page\AbstractPage::$activeMenuItem
     */
    public $activeMenuItem = 'wcf.serverlist.menu';

    /**
     * @see        \wcf\page\AbstractPage::$enableTracking
     */
    public $enableTracking = true;

    /**
     * @see        wcf\page\AbstractPage::$neededPermissions
     */
  //  public $neededPermissions = array('user.serverlist.canView');

    /**
     * @see        wcf\page\AbstractPage::$neededModules
     */
   // public $neededModules = array('MODULE_SERVERLIST_PAGE');
    public $templateName = 'serverlist';
    public $serverlist = array();

    /**
     * @see Page::serverlist()
     */
    public function readData() {
        parent::readData();

        $sql = "SELECT ip, port, MAX(timestamp) AS timestamp, game, value FROM wcf" . WCF_N . "_serverlist WHERE timestamp >= " . (time() - 60 * 60 * 2) . " GROUP BY ip, port, game, value";
        $pdo = WCF::getDB()->prepareStatement($sql);
        $pdo->execute();
        while ($row = $pdo->fetchArray()) {
            $server["ip"] = $row["ip"];
            $server["port"] = $row["port"];
            $server["game"] = $row["game"];
            $server["timestamp"] = $row["timestamp"];
            $values = json_decode(base64_decode($row["value"]), true);
            $server["name"] = preg_replace('#(\^.)#', '', $values["sv_hostname"]);
            $server["players"] = count($values["player"]);
            $server["maxplayers"] = $values["sv_maxclients"] - $values["sv_privateclients"];
            $server["map"] = $values["mapname"];
            $server["gametype"] = $values["g_gametype"];
            $server["punkbuster"] = $values["sv_punkbuster"];
            $server["mod"] = $values["mod"];
            $server["password"] = $values["pswrd"];
            $server["version"] = $values["shortversion"];
            if (in_array($server["ip"], array(
                        "88.198.1.230",
                        "176.9.118.212"
                    ))) {
                $server["premium"] = 1;
            } else {
                $server["premium"] = 0;
            }
           if (stripos($server["name"], "crack") === false && stripos($server["name"], "Crack") === false) {
                $this->serverlist[] = $server;
            }
        }
    }

    /**
     * @see AbstractPage::assignVariables();
     */
    public function assignVariables() {
        parent::assignVariables();
        WCF::getTPL()->assign(array('serverlist' => $this->serverlist));
        StyleUtil::updateStyleFile();
    }

}

?>
