{include file='documentHeader'}
<head>
    <title>{lang}wcf.serverlist.sitetitle{/lang} - {PAGE_TITLE}</title>
    {include file='headInclude' sandbox=false}
    <script src="{@$__wcf->getPath()}js/3rdParty/jquery.min.js"></script>
    <script src="{@$__wcf->getPath()}js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#serverlist').dataTable();
        });

    </script>
    <style type="text/css">



        table.serverlist thead .game {
            width: 24px;
        }
        table.serverlist thead .connect {
            width: 100px;
            min-width: 100px;
        }
        table.serverlist thead .address {
            min-width: 150px;
        }
        table.serverlist thead .name {
            width: 220px;
        }
        table.serverlist thead .gamer {
            width: 60px;
        }
        table.serverlist thead .gt {
            width: 50px;
        }
        table.serverlist thead .map {
            width: 150px;
        }
        table.serverlist thead .version {
            width: 70px;
        }
        table.serverlist thead .pb {
            width: 23.65px;
        }
        table.serverlist thead .mod {
            width: 23.65px;
            font-size: 0.85em;
        }
        table.serverlist thead .mod div {
            padding: 0;
        }
        table.serverlist thead .pw {
            width: 23.65px;
        }
        table.serverlist tbody .connect {
            text-align: center;
        }
        table.serverlist tbody .ip {
            width: 112px;
        }
        table.serverlist tbody .port {
            width: 38px;
        }
        table.serverlist tbody .name {
            width: 220px;
            max-width: 220px;
            overflow: hidden;
            text-overflow: ellipsis;
            -o-text-overflow: ellipsis;
            white-space: nowrap;
        }
        table.serverlist tbody tr.container-1.highlight, table.serverlist tbody tr.container-2.highlight {
            background: #FAC540;
            color: #57595A;
        }
        table.serverlist tbody tr.container-1.highlight:hover, table.serverlist tbody tr.container-2.highlight:hover {
            background: #EAB530;
        }
    </style>
</head>
<body>
    {include file='header' sandbox=false}
    <div id="main" class="help">
        <header class="boxHeadline">
            <h1>{lang}wcf.serverlist.title{/lang}</h1>
            <p>
                {lang}wcf.serverlist.description{/lang}
            </p>
        </header>

    {if $userMessages|isset}{@$userMessages}{/if}
    <div class="subTabMenu">
        <div class="containerHead"></div>
    </div>
    <div class=".sortableListContainer">
        <table id="serverlist" class="table serverlist">
            <thead>
                <tr class="table">
                    <th class="game">
                    </th>
                    <th class="connect">
                    </th>
                    <th class="address">
                        {lang}wcf.serverlist.serveradress{/lang}
                    </th>
                    <th class="name">
                        {lang}wcf.serverlist.servername{/lang}
                    </th>
                    <th class="gamer">
                        {lang}wcf.serverlist.serverplayer{/lang}
                    </th>
                    <th class="map">
                        {lang}wcf.serverlist.servermap{/lang}
                    </th>
                    <th class="gt">
                        {lang}wcf.serverlist.servergametype{/lang}
                    </th>
                    <th class="version">
                        {lang}wcf.serverlist.serverversion{/lang}
                    </th>
                    <th class="pb">
                        <img src="{@$__wcf->getPath()}icon/punkbuster.png">           
                    </th>
                    <th class="mod">            
                        {lang}wcf.serverlist.servermod{/lang}            
                    </th>
                    <th class="pw">        
                        <img src="{@$__wcf->getPath()}icon/password.png">
                    </th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$serverlist item=server}
                    <tr class="{cycle values='container-1,container-2'}{if $server.premium} highlight{/if}">
                        <td style="background:url({@$__wcf->getPath()}icon/{$server.game}.png) no-repeat 50% 50%;"></td>
                        <td class="connect">
                            <a href="xfire:join?game=cod4mp&server={$server.ip}:{$server.port}" style="background:url({@$__wcf->getPath()}icon/connect_xfire.png); display:inline-block; height: 16px; width: 25px;vertical-align: middle;"></a>
                            <a href="hlsw://{$server.ip}:{$server.port}?Connect" style="background:url({@$__wcf->getPath()}icon/connect_hlsw.png); display:inline-block; height: 16px; width: 25px;vertical-align: middle;margin-left: 4px;"></a>
                            <a href="gt://joinGame:game=cod4&ip={$server.ip}&port={$server.port}" style="background:url({@$__wcf->getPath()}icon/connect_gt.png); display:inline-block; height: 16px; width: 25px;vertical-align: middle;margin-left: 4px;"></a>
                        </td>  
                        <td style="text-align: center;">
                            <span class="ip">{$server.ip}</span>:<span class="port">{$server.port}</span>
                        </td>
                        <td class="name">
                            {$server.name}
                        </td>
                        <td style="text-align: center;">
                            {$server.players}/{$server.maxplayers}
                        </td>
                        <td>
                            {$server.map}
                        </td>
                        <td style="text-align: center;">
                            {$server.gametype}
                        </td>
                        <td style="text-align: center;">
                            {$server.version}
                        </td>
                        <td style="background: #{if $server.punkbuster}0f0{else}f00{/if};"></td>
                        <td style="background: #{if $server.mod}0f0{else}f00{/if};"></td>
                        <td style="background: #{if $server.password}0f0{else}f00{/if};"></td>
                    </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
</div>
{include file='footer' sandbox=false}
</body>
</html>