<?php

error_reporting(E_ALL);


$language = "en";
if (isset($_GET["lang"]) && in_array($_GET["lang"], array("en", "de"))) $language = $_GET["lang"];

$lang["de"]["title"] = "Serverlog Finder";
$lang["de"]["heading"] = "Serverlog Finder";
$lang["de"]["changelang"] = "Show this page in ENGLISH";
$lang["de"]["otherlang"] = "en";
$lang["de"]["findlog"] = "Serverlog finden (games_mp.log)";
$lang["de"]["ip"] = "Server-IP:";
$lang["de"]["port"] = "Port:";
$lang["de"]["rconpw"] = "RCON-Passwort:";
$lang["de"]["os"] = "Betriebssystem:";
$lang["de"]["descr"] = "Das RCON-Passwort wird nur fr die Verbindungherstellung bentigt und wird NICHT gespeichert!";
$lang["de"]["submit"] = "Serverlog-Pfad abrufen";
$lang["de"]["inputerror"] = "Die Eingaben sind ungltig!";

$lang["en"]["title"] = "Serverlog Finder";
$lang["en"]["heading"] = "Serverlog Finder";
$lang["en"]["changelang"] = "Zeige diese Seite in DEUTSCH";
$lang["en"]["otherlang"] = "de";
$lang["en"]["findlog"] = "Find serverlog (games_mp.log)";
$lang["en"]["ip"] = "Server IP:";
$lang["en"]["port"] = "Port:";
$lang["en"]["rconpw"] = "RCON password:";
$lang["en"]["os"] = "Operation system:";
$lang["en"]["descr"] = "RCON password is only needed to establish a connection. It won't be saved.";
$lang["en"]["submit"] = "Get serverlog path";
$lang["en"]["inputerror"] = "Die Eingaben sind ungltig!";

$ip = isset($_POST["ip"]) ? stripslashes($_POST["ip"]) : "";
$port = isset($_POST["port"]) ? stripslashes($_POST["port"]) : "";
$rconpw = isset($_POST["rconpw"]) ? stripslashes($_POST["rconpw"]) : "";
$os = isset($_POST["os"]) ? stripslashes($_POST["os"]) : "windows";


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title><?php echo $lang[$language]["title"] ?></title>
<link href="style.css" type="text/css" rel="stylesheet" />
<style type="text/css">
<!--
body {
    width: 800px;
}
th {
    width: 150px;
    text-align: right;
}
.input {
    width: 250px;
}
-->
</style>
<script type="text/javascript">
<!--
function setPort() {

    var ip = window.document.getElementById("ip");
    var port = window.document.getElementById("port");

    var found = ip.value.match(/\s*^(.*?):([0-9]{1,5})\s*$/);

    if (found) {
        ip.value = found[1];
        port.value = found[2];
    }
}
-->
</script>
</head>
<body>
<img src="http://images.gw-2.de/images/901e2d94448ee5576dd3.png" alt="Manu-Admin-Mod" style="margin: auto; display:block" />
<h1><?php echo $lang[$language]["heading"] ?></h1>

<p><a href="?lang=<?php echo $lang[$language]["otherlang"]; ?>"><?php echo $lang[$language]["changelang"]; ?></a></p>
<fieldset>
<p><?php echo $lang[$language]["descr"] ?></p>
<legend><?php echo $lang[$language]["findlog"] ?></legend>
<form action="" method="post">
<table cellspacing="1">
<tr><th><?php echo $lang[$language]["ip"]; ?></th><td class="input"><input type="text" name="ip" value="<?php echo htmlentities($ip) ?>" size="35" onblur="setPort()" id="ip" /></td>
<td rowspan="4" class="status">
<?php
if (isset($_POST["submit"])) {
    if (empty($ip) || empty($rconpw) || !is_numeric($port) || $port < 1 || $port > 65535 || !in_array($os, array("linux", "windows"))) {
        echo "<span class='error'>". $lang[$language]["inputerror"] ."</span>";
    }
    else {
        flush();
        $rcon = new q3query($ip, $port, $success, $errno, $errstr);
        if (!$success) {
            echo "<span class='error'>Error while connecting to server: $errstr</span>";
            flush();
        }
        else {
            $rcon->setRconpassword($rconpw);
            $response = $rcon->rcon("g_log");
            if ($response == "") {
                echo "<span class='error'>RCON-Connection invalid! Check IP & Port</span>";
                flush();
            }
            else {
                echo "Connected to server...<br />";
                flush();
                if (stripos($response, "Invalid password.") !== false) {
                    echo "<span class='error'>Wrong RCON password</span>";
                }
                else {
                    $filename = dvar($response);
                    echo "Got filename: <b>$filename</b><br />";
                    flush();
                    $fsgame = dvar($rcon->rcon("fs_game"));
                    if ($fsgame == "") $fsgame = "main";
                    else $fsgame = "Mods/$fsgame";
                    echo "Got moddir: <b>$fsgame</b><br />";
                    flush();
                    $gamedir = dvar($rcon->rcon("fs_homepath"));
                    echo "Got homepath: <b>$gamedir</b><br />";
                    flush();
                    if ($gamedir == "./") {
                        $game = dvar($rcon->rcon("gamename"));
                        echo "Got gamename: <b>$game</b><br />";
                        flush();
                        if ($game == "Call of Duty: World at War" && $os == "windows") {
                            $gamedir = dvar($rcon->rcon("fs_localAppData"));
                            echo "Got AddDataDir: <b>$gamedir</b><br />";
                        }
                        elseif ($game == "Call of Duty: World at War") {
                            echo "<span class='error'>Error while detection, path might be wrong</span>";
                        }
                        else {
                            $gamedir = dvar($rcon->rcon("fs_basepath"));
                            echo "Got basebath: <b>$gamedir</b><br />";
                        }
                        flush();
                    }
                    echo "Your gameserver log path is: <br /><span class='success'>";
                    $logpath = $gamedir . "/" . $fsgame . "/" . $filename ;
                    echo preg_replace('#/|\\\\#', ($os == "windows") ? '\\' : "/", $logpath);
                    echo "</span>";
                    flush();
                }
            }
        }
    }
}
?>
</td>
</tr>
<tr><th><?php echo $lang[$language]["port"]; ?></th><td class="input"><input type="text" id="port" name="port" value="<?php echo htmlentities($port) ?>" maxlength="5" size="3" /></td></tr>
<tr><th><?php echo $lang[$language]["rconpw"]; ?></th><td class="input"><input type="password" name="rconpw" value="<?php echo htmlentities($rconpw) ?>" /></td></tr>
<tr><th><?php echo $lang[$language]["os"]; ?></th><td class="input"><select name="os"><option value="windows">Windows</option><option value="linux" <?php if($os=="linux")echo"selected='selected'";?>>Linux</option></select></td></tr>
</table>
<p><input type="submit" value="<?php echo $lang[$language]["submit"]; ?>" name="submit" /></p>
</form>
</fieldset>
<p style='text-align: center'>Copyright by <a href='http://manuadminmod.de/'>ManuAdminMod.de</a></p>
</body>
</html>
<?php

class q3query {

	private $address;
	private $port;
    private $rconpassword = false;
    private $fp;
    private $cmd = "\xFF\xFF\xFF\xFF";

    public function __construct($address, $port, &$success = NULL, &$errno = NULL, &$errstr = NULL) {
    	$this->address = $address;
    	$this->port = $port;

        $this->fp = fsockopen("udp://$address", $port, $errno, $errstr, 5);
        if (!$this->fp) {
        	$success = false;
        }
        else {
        	$success = true;
        }
    }

    public function setRconpassword($pw) {
        $this->rconpassword = $pw;
    }

    public function rcon($str) {
    	if (!$this->rconpassword) {
    		return false;
    	}
    	fwrite($this->fp, $this->cmd . "rcon " . $this->rconpassword . " $str\n");
		return $this->getResponse();
    }

    private function getResponse() {
    	stream_set_timeout($this->fp, 0, 7e5);
        $s = '';
        do {
        	$read = fread($this->fp, 9999);
			$s .= substr($read, 10);
			$info = stream_get_meta_data($this->fp);
		}
		while (!$info["timed_out"]);

        return $s;
    }

    public function quit() {
    	if (is_resource($this->fp)) {
			fclose($this->fp);
    	}
    	return false;
    }

    public function reconnect() {
    	$this->quit();
    	$this->__construct($this->address, $this->port);
    }

}

function dvar($input) {
	$pattern = '|^"(.*?)" is: "(.*)\^7" default: "(.*)\^7"|i';
	if (preg_match($pattern, trim($input), $subpatterns)) {
		return $subpatterns[2];
	}
	return false;
}

?>