<?php

error_reporting(E_ALL);

$language = "en";
if (isset($_GET["lang"]) && in_array($_GET["lang"], array("en", "de"))) $language = $_GET["lang"];

$versions = array(
    "0.11.4" => "0.11.4",
    "0.11.3" => "0.11.2",
    "0.11.2" => "0.11.2",
    "0.11.1" => "0.11",
    "0.11" => "0.11",
    "0.10.1" => "0.10",
    "0.10" => "0.10",
    "0.9.2" => "0.9.1",
    "0.9.1" => "0.9.1",
    "0.9" => "0.9",
    "0.8.1" => "0.8.1",
    "0.8" => "0.8",
    "0.7.1" => "0.7.1",
    "0.7" => "0.7"
);
$version = current($versions);
if (isset($_GET["version"]) && array_key_exists($_GET["version"], $versions)) $version = $versions[$_GET["version"]];

$games = array(
    "cod4" => "Call of Duty 4 - Modern Warfare",
    "cod5" => "Call of Duty: World at War (&gt;= v0.8)",
    "cod2" => "Call of Duty 2 (&gt;= v0.9)",
    "cod6" => "Call of Duty - Modern Warfare 2 (AIW.net) (&gt;= 0.11.4)"
);
$game = "cod4";
if (isset($_GET["game"]) && array_key_exists($_GET["game"], $games)) $game = $_GET["game"];

$lang["de"]["title"] = "Config-Generator";
$lang["de"]["heading"] = "Config-Generator";
$lang["de"]["versionwarning"] = "<b><u>Achtung:</u></b><br />Dieser Generator ist NUR f&uuml;r <b>Versionen &gt;= 0.7</b> geeignet!";
$lang["de"]["moreinfo"] = "Mehr Infos hier...";
$lang["de"]["tablehead"] = "<tr><th>Variable</th><th>Wert</th><th>Beschreibung</th><th>&nbsp;</th></tr>";
$lang["de"]["yes"] = "Ja";
$lang["de"]["no"] = "Nein";
$lang["de"]["kick"] = "Kicken";
$lang["de"]["ban"] = "Bannen";
$lang["de"]["tempban"] = "Tempor&auml;rbannen";
$lang["de"]["generate"] = "Generieren";
$lang["de"]["reset"] = "Zur&uuml;cksetzen";
$lang["de"]["alltodefault"] = "Alles auf Default";
$lang["de"]["shure"] = "Alle Werte auf Standard setzen...\\nSicher?";
$lang["de"]["otherlang"] = "en";
$lang["de"]["changelang"] = "Show this page in ENGLISH";
$lang["de"]["overview"] = "&Uuml;bersicht";
$lang["de"]["version"] = "Version";
$lang["de"]["versiontext"] = "Bitte w&auml;hle deine installierte Manu-Admin-Mod-Version aus:";
$lang["de"]["gametext"] = "Bitte w&auml;hle dein installiertes Spiel aus:";
$lang["de"]["download"] = "Herunterladen &amp; speichern";


$lang["en"]["title"] = "Config-Generator";
$lang["en"]["heading"] = "Config-Generator";
$lang["en"]["versionwarning"] = "<b><u>Attention:</u></b><br />This generator can only be used for <b>versions &gt;= 0.7</b>!";
$lang["en"]["moreinfo"] = "More infos here...";
$lang["en"]["tablehead"] = "<tr><th>Variable</th><th>Value</th><th>Description</th><th>&nbsp;</th></tr>";
$lang["en"]["yes"] = "Yes";
$lang["en"]["no"] = "No";
$lang["en"]["kick"] = "Kick";
$lang["en"]["ban"] = "Ban";
$lang["en"]["tempban"] = "Temporary ban";
$lang["en"]["generate"] = "Generate";
$lang["en"]["reset"] = "Reset";
$lang["en"]["alltodefault"] = "All to default";
$lang["en"]["shure"] = "Set all values to default...\\nShure?";
$lang["en"]["otherlang"] = "de";
$lang["en"]["changelang"] = "Zeige diese Seite in DEUTSCH";
$lang["en"]["overview"] = "Overview";
$lang["en"]["version"] = "Version";
$lang["en"]["versiontext"] = "Please choose your installed Manu-Admin-Mod version:";
$lang["en"]["gametext"] = "Please choose your game:";
$lang["en"]["download"] = "Download &amp; save";


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title><?php echo $lang[$language]["title"]; ?></title>
<link href="style.css" type="text/css" rel="stylesheet" />
<script type="text/javascript">
function showhide(elementid) {
    if (window.document.getElementById(elementid).style.display=='block') {
        window.document.getElementById(elementid).style.display='none';
        window.document.getElementById(elementid + 'img').src = 'maximize.png';
        window.document.getElementById(elementid + 'img').alt = '+';
    }
    else {
        window.document.getElementById(elementid).style.display='block';
        window.document.getElementById(elementid + 'img').src = 'minimize.png';
        window.document.getElementById(elementid + 'img').alt = '-';
    }
}
</script>
<style type="text/css">
<!--
.changelog {
    overflow: auto;
    height: 300px;
    float: right;
    width: 500px;
}
#gameselect option {
	background-repeat:no-repeat;
	padding-left: 18px;
}
-->
</style>
</head>
<body>
<img src="http://images.gw-2.de/images/901e2d94448ee5576dd3.png" alt="Manu-Admin-Mod" style="margin: auto; display:block" />
<h1><?php echo $lang[$language]["heading"]; ?></h1>
<p><a href="?lang=<?php echo $lang[$language]["otherlang"]; ?>&amp;version=<?php echo $version; ?>&amp;game=<?php echo $game; ?>"><?php echo $lang[$language]["changelang"]; ?></a></p>
<?php

mysql_connect("localhost", "mam_website", "3ror6BRf");
mysql_select_db("manuadminmod_website");

$sql = "SELECT *
        FROM config_textfields";
$result = mysql_query($sql);
$textfields = array();
while ($row = mysql_fetch_assoc($result)) {
    $textfields[$row["id"]] = $row["text"];
}

$sql = "SELECT m.id,
               m.name_$language AS name,
               m.section,
               m.descr_$language AS description,
               m.wiki_$language AS wikilink
        FROM config_modules m
        LEFT JOIN config_modules_version v ON v.moduleid = m.id
        WHERE v.version = '$version'
        ORDER BY m.pos";

$res_modules = mysql_query($sql);

$sql = "SELECT v.name,
               v.module,
               v.`default_$game` AS `default`,
               v.`default_$game` AS current,
               v.type,
               v.descr_$language AS description
        FROM config_vars v
        LEFT JOIN config_vars_version ver ON ver.varid = v.id
        WHERE ver.version = '$version'
        ORDER BY v.pos";

$res_vars = mysql_query($sql);
echo mysql_error();

$vars = array();
while ($row = mysql_fetch_assoc($res_vars)) {
    if ($row["type"] == "textfield") {
        $row["current"] = $textfields[$row["default"]];
        $row["default"] = $textfields[$row["default"]];
    }
	$vars[$row["module"]][] = $row;
}

$config = array();
while ($row = mysql_fetch_assoc($res_modules)) {
    $config[] = $row + array("vars"=>$vars[$row["id"]]);
}

if (isset($_POST["submitbutton"])) {
	foreach ($config as $sectionid => $section) {
		foreach ($section["vars"] as $optionid => $option) {

			$valid = false;

			if (isset($_POST[$section["section"]][$option["name"]])) {
                $_POST[$section["section"]][$option["name"]] = trim($_POST[$section["section"]][$option["name"]]);
			    $field = &$_POST[$section["section"]][$option["name"]];

				switch ($option["type"]) {
					case "posnum":
						$valid = preg_match('|^[1-9][0-9]*$|', $field);
						break;
					case "port":
						$valid = preg_match('|^[1-9][0-9]*$|', $field) && $field <= 65535;
						break;
					case "text":
					case "textfield":
						if (get_magic_quotes_gpc()) {
							$field = stripslashes($field);
						}
						$valid = true;
						break;
					case "boolean":
						$valid = true;
						$field = (bool)(int)($field);
						break;
					case "kickban":
						$valid = in_array($field, array("kick", "ban", "tempban"));
						break;
					case "language":
					    $valid = in_array($field, array("en", "de"));
					    break;
					case "list":
					    $valid = true;
						if (get_magic_quotes_gpc()) {
							$field = stripslashes($field);
						}
						$field = preg_replace('(\r\n|\r|\n)', ",", $field);
					    break;
					case "onechar":
					    $valid = true;
					    $field = $field{0};
					    break;
					case "float":
                        $valid = preg_match('|^-?[0-9]*(\.[0-9]+)?$|', $field);
					    break;
				}
			}

			if ($valid) {
				$config[$sectionid]["vars"][$optionid]["current"] = $field;
			}
		}
	}

	$configfile = "";
	foreach ($config as $section) {
		$configfile .= "[".$section["section"]."]\n";
		foreach ($section["vars"] as $option) {
		    if ($option['type'] == "textfield") {
		        $configfile .= $option["current"] . "\n";
		        continue;
		    }
			$configfile .= $option["name"] . " = ";
			switch ($option['type']) {
				case "text":
				case "kickban":
				case "language":
				case "list":
				case "onechar":
					$configfile .= "\"".$option['current']."\"";
					break;
				case "float":
					$configfile .= (float)$option['current'];
					break;
				case "port":
				case "boolean":
				case "posnum":
					$configfile .= (int)$option['current'];
					break;
			}
			$configfile .= "\n";
		}
		$configfile .= "\n";
	}


	echo "<p><b>config.cfg:</b><br /><textarea cols='117' rows='20' wrap='off'>".htmlentities($configfile, ENT_QUOTES) . "</textarea></p>\n";
	echo "<form action='download.php' method='post'>\n";
	echo "<p><input type='submit' value='".$lang[$language]["download"]."' /></p>\n";
	echo "<input type='hidden' value='".base64_encode($configfile)."' name='data' />\n";
	echo "<input type='hidden' name='filename' value='config.cfg' />\n";
	echo "</form>\n";
}

?>
<fieldset>
<legend onclick='javascript:showhide("version")'> <img src='minimize.png' alt='-' id='versionimg'/> <?php echo $lang[$language]["version"]; ?></legend>
<div id='version' style="display:block">
<p><img src='warning.png' alt='' class="warning" /><?php echo $lang[$language]["versionwarning"]; ?></p>
<form action="config.php" method="get" id="versionform">
<p>
<?php echo $lang[$language]["versiontext"]; ?>&nbsp;
<select name="version" onchange="javascript:window.document.getElementById('versionform').submit()">
<?php
foreach ($versions as $key => $value) {
    if (isset($_GET["version"]) && $_GET["version"] == $key) {
        echo "<option value='$key' selected='selected'>$key</option>\n";
    }
    else {
        echo "<option value='$key'>$key</option>\n";
    }
}
?>
</select><br />
<?php echo $lang[$language]["gametext"]; ?>&nbsp;
<select name="game" onchange="javascript:window.document.getElementById('versionform').submit()" id="gameselect">
<?php
foreach ($games as $key => $value) {
    if ($game == $key) {
        echo "<option value='$key' selected='selected' style='background-image: url(\"$key.png\")'>$value</option>\n";
    }
    else {
        echo "<option value='$key' style='background-image: url(\"$key.png\")'>$value</option>\n";
    }
}
?>
</select>
<input type="submit" value="OK!" name="okbutton" />
</p>
<input type="hidden" name="lang" value="<?php echo $language; ?>" />
</form>
<script type="text/javascript">
<!--
window.document.getElementById('versionform').okbutton.style.display='none';
-->
</script>
</div>
</fieldset>
<fieldset>
<legend onclick='javascript:showhide("content")'> <img src='minimize.png' alt='-' id='contentimg'/> <?php echo $lang[$language]["overview"]; ?></legend>
<div id='content' style="display:block">
<div class="changelog">
<h2>Changelog:</h2>
<h3>0.11.2 beta</h3>
<ul>
<li><b>Added: </b>[voting]allowsetnextmap </li>
<li><b>Added: </b>[voting]ignoremapchange </li>
<li><b>Added: </b>[voting]timelimit </li>
<li><b>Added: </b>[voting]allowhardcore </li>
</ul>
<h3>0.11 beta</h3>
<ul>
<li><b>Added: </b>[nameprotection]maxnamechanges*</li>
<li><b>Added: </b>[nameprotection]uppercase*</li>
<li><b>Added: </b>[voting]banduration  </li>
<li><b>Added: </b>[mapvote]*</li>
<li><b>Added: </b>[customcommands]*</li>
</ul>
<h3>0.10 beta</h3>
<ul>
<li><b>Added: </b>[tcp_query]*</li>
<li><b>Added: </b>[kickban]maxtempbantime</li>
<li><b>Added: </b>[main]responsefailcmds</li>
<li><b>Added: </b>[statistics_mysql]*</li>
<li><b>Changed: </b>[statistics]savestats</li>
</ul>
<h3>0.9.1 beta</h3>
<ul>
<li><b>Added: </b>[ftp]* </li>
</ul>
<h3>0.9 beta</h3>
<ul>
<li><b>Added: </b>[main]pmprefix </li>
<li><b>Added: </b>[welcomemessages]whisper</li>
<li><b>Added: </b>CoD2 Support</li>
</ul>
<h3>0.8 beta</h3>
<ul>
<li><b>Added: </b>CoDWaW Support</li>
<li><b>Removed: </b>[minianticheat]*</li>
</ul>
<h3>0.7.1 beta</h3>
<ul>
<li><b>Added: </b>[main]fixguidrelax</li>
<li><b>Added: </b>[statistics]savestats</li>
<li><b>Changed: </b>[spreemessages]spreends =&gt; [spreemessages]spreeends</li>
<li><b>Removed: </b>[voting]percentage</li>
</ul>
</div>
<ul>
<?php
    foreach ($config as $section) {
        echo "  <li><a href='#content$section[section]'>$section[name]</a></li>\n";
    }
?>
</ul>
</div>
</fieldset>
<form action="config.php?lang=<?php echo $language; ?>&amp;version=<?php echo $version; ?>&amp;game=<?php echo $game; ?>" method="post" name="formular">
<?php
$tabindex = 1;
foreach ($config as $section) {
    echo "<fieldset id='content".$section["section"]."'>";
	echo "<legend onclick='javascript:showhide(\"".$section["section"]."\")'> <img src='minimize.png' alt='-' id='".$section["section"]."img'/> $section[name]</legend>\n";
	echo "<div id='".$section["section"]."' style='display: block'>";
	echo "<p>$section[description]<br /><a href='$section[wikilink]' target='_blank'>".$lang[$language]["moreinfo"]."</a></p>";
	echo "<table cellspacing='1'>\n";
	echo "  ".$lang[$language]["tablehead"] . "\n";

	foreach ($section["vars"] as $option) {
		echo "  <tr>\n";
		echo "    <td><i>$option[name]</i></td>\n";

		switch ($option["type"]) {
			case "posnum":
			case "float":
			case "port":
				echo "    <td><input tabindex='".($tabindex++)."' type='text' name='".$section["section"] . "[" . $option["name"]."]' value='$option[current]' size='5' id='".$section["section"] . "__$option[name]' /></td>\n";
				break;

			case "text":
				echo "    <td><input tabindex='".($tabindex++)."' type='text' name='".$section["section"]. "[" . $option["name"]."]' value='".htmlspecialchars($option['current'], ENT_QUOTES)."' size='50' id='".$section["section"] . "__$option[name]' /></td>\n";
				break;

			case "boolean":
				echo "    <td><input tabindex='".($tabindex++)."' type='radio' name='".$section["section"]. "[" . $option["name"]."]' value='1' ".(($option['current'] == "1") ? "checked='checked'" : "")." id='".$section["section"] . "__" .$option["name"] ."__1' /> <label for='".$section["section"] . "__" .$option["name"] ."__1'>".$lang[$language]["yes"]."</label> <input tabindex='".($tabindex++)."' type='radio' name='".$section["section"]."[$option[name]]' value='0' ".(($option['current'] == "1") ? "" : "checked='checked'")." id='".$section["section"] . "__" .$option["name"] ."__0' /> <label for='".$section["section"] . "__" .$option["name"] ."__0'>".$lang[$language]["no"]."</label></td>\n";
				break;

			case "kickban":
				echo "    <td><select tabindex='".($tabindex++)."' name='".$section["section"]. "[" . $option["name"]."]' id='".$section["section"] . "__$option[name]'><option value='kick' ".(($option['current'] == "kick") ? "selected='selected'" : "").">".$lang[$language]["kick"]."</option><option value='ban' ".(($option['current'] == "ban") ? "selected='selected'" : "").">".$lang[$language]["ban"]."</option><option value='tempban' ".(($option['current'] == "tempban") ? "selected='selected'" : "").">".$lang[$language]["tempban"]."</option></select></td>\n";
				break;

			case "onechar":
				echo "    <td><input tabindex='".($tabindex++)."' type='text' maxlength='1' name='".$section["section"]. "[" . $section["section"]."]' value='".htmlspecialchars($option['current'], ENT_QUOTES)."' size='1' id='".$section["section"] . "__$option[name]' /></td>\n";
				break;

			case "list":
		        echo "    <td><textarea tabindex='".($tabindex++)."' wrap='off' name='".$section["section"]. "[" . $option["name"]."]' id='".$section["section"] . "__$option[name]' rows='4' cols='38'>".htmlspecialchars(str_replace(",","\n", $option['current']), ENT_QUOTES)."</textarea></td>";
		        break;

			case "language":
				echo "    <td><select tabindex='".($tabindex++)."' name='".$section["section"]. "[" . $option["name"]."]' id='".$section["section"] . "__$option[name]'><option value='en' ".(($option['current'] == "en") ? "selected='selected'" : "").">English</option><option value='de' ".(($option['current'] == "de") ? "selected='selected'" : "").">German</option></select></td>\n";
				break;

			case "textfield":
		        echo "    <td><textarea tabindex='".($tabindex++)."' wrap='off' name='".$section["section"]. "[" . $option["name"]."]' id='".$section["section"] . "__$option[name]' rows='8' cols='50'>".htmlspecialchars($option['current'], ENT_QUOTES)."</textarea></td>";
		        break;
		        break;


		}

		echo "    <td><b>";
		echo htmlentities($option["description"], ENT_QUOTES);
		echo "</b></td>\n";

		echo "    <td>";
		if ($option["type"] == "boolean") {
			echo "<a href='javascript:void(0)' onclick='javascript:window.document.getElementById(\"". $section["section"] . "__$option[name]". "__" . (int)$option["default"] ."\").checked=1' title='".(int)$option["default"]."'>Default</a>";
		}
		elseif ($option["type"] == "list") {
			echo "<a href='javascript:void(0)' onclick='javascript:window.document.getElementById(\"". $section["section"] . "__$option[name]\").value=\"".htmlspecialchars(str_replace(",","\\n", $option['default']), ENT_QUOTES)."\";' title='".htmlspecialchars($option["default"], ENT_QUOTES)."'>Default</a>";
		}
		elseif ($option["type"] == "textfield") {
			echo "<a href='javascript:void(0)' onclick='javascript:window.document.getElementById(\"". $section["section"] . "__$option[name]\").value=\"".htmlspecialchars(str_replace(array("\r\n", "\r", "\n"),"\\n", str_replace("\"", "\\\"", $option['default'])), ENT_QUOTES)."\";' title='Default'>Default</a>";
		}
		else {
			echo "<a href='javascript:void(0)' onclick='javascript:window.document.getElementById(\"". $section["section"] . "__$option[name]\").value=\"".htmlspecialchars($option["default"], ENT_QUOTES)."\";' title='".htmlspecialchars($option["default"], ENT_QUOTES)."'>Default</a>";
		}
		echo "</td>\n";

		echo "  </tr>\n";
	}

	echo "</table>\n";
    echo "</div></fieldset>";
}
?>
<p style="text-align: center"><input tabindex="<?php echo $tabindex++; ?>" type="submit" name="submitbutton" value="<?php echo $lang[$language]["generate"]; ?>" /> <input tabindex="<?php echo $tabindex++; ?>" type="reset" value="<?php echo $lang[$language]["reset"]; ?>" onclick="return confirm('<?php echo $lang[$language]["shure"]; ?>')" /> <input tabindex="<?php echo $tabindex++; ?>" type="submit" value="<?php echo $lang[$language]["alltodefault"]; ?>" onclick="return confirm('<?php echo $lang[$language]["shure"]; ?>')" /></p>
</form>
<p style='text-align: center'>Copyright by <a href='http://manuadminmod.de/'>ManuAdminMod.de</a></p>
</body>
</html>