<?php

error_reporting(E_ALL);

$language = "en";
if (isset($_GET["lang"]) && in_array($_GET["lang"], array("en", "de"))) $language = $_GET["lang"];

$lang["de"]["title"] = "tcp_user.db-Generator";
$lang["de"]["heading"] = "tcp_user.db-Generator";
$lang["de"]["changelang"] = "Show this page in ENGLISH";
$lang["de"]["overview"] = "bersicht";
$lang["de"]["otherlang"] = "en";
$lang["de"]["currentadmins"] = "Aktuelle Admins";
$lang["de"]["group"] = "Gruppe";
$lang["de"]["generate"] = "tcp_user.db generieren";
$lang["de"]["edit"] = "Bearbeiten";
$lang["de"]["del"] = "Lschen";
$lang["de"]["addadmin"] = "Admin hinzufgen/bearbeiten";
$lang["de"]["save"] = "Speichern";
$lang["de"]["onegroup"] = "Ein Gruppe pro Zeile";
$lang["de"]["groups"] = "Gruppen";
$lang["de"]["error"] = "Fehler";
$lang["de"]["canceledit"] = "Bearbeiten abbrechen";
$lang["de"]["load"] = "Laden";
$lang["de"]["loadfile"] = "tcp_user.db einlesen";
$lang["de"]["override"] = "berschreibe aktuelle Admins";
$lang["de"]["err_group"] = "Fehlerhafte Gruppe";
$lang["de"]["err_user"] = "Bitte nur die Zeichen A-Z, 0-9, - und _ fr den Benutzernamen verwenden";
$lang["de"]["err_pw1"] = "Bitte die Passwortfelder ausfllen";
$lang["de"]["err_pw2"] = "Die beiden Passwrter stimmen nicht berein";
$lang["de"]["err_userexists"] = "Der Benutzer existiert bereits";
$lang["de"]["user"] = "Benutzer";
$lang["de"]["password"] = "Passwort";
$lang["de"]["password2"] = "Passwort wiederholen";
$lang["de"]["download"] = "Herunterladen &amp; speichern";


$lang["en"]["title"] = "tcp_user.db-Generator";
$lang["en"]["heading"] = "tcp_user.db-Generator";
$lang["en"]["changelang"] = "Zeige diese Seite in DEUTSCH";
$lang["en"]["overview"] = "Overview";
$lang["en"]["otherlang"] = "de";
$lang["en"]["currentadmins"] = "Current admins";
$lang["en"]["group"] = "Group";
$lang["en"]["generate"] = "Generate tcp_user.db";
$lang["en"]["edit"] = "Edit";
$lang["en"]["del"] = "Delete";
$lang["en"]["addadmin"] = "Add/Edit admin";
$lang["en"]["save"] = "Save";
$lang["en"]["onegroup"] = "One group per line";
$lang["en"]["groups"] = "Groups";
$lang["en"]["error"] = "Error";
$lang["en"]["canceledit"] = "Cancel edit";
$lang["en"]["load"] = "Load";
$lang["en"]["loadfile"] = "Load tcp_user.db";
$lang["en"]["override"] = "Override current admins";
$lang["en"]["err_group"] = "Wrong Group";
$lang["en"]["err_user"] = "Please use only the chars A-Z, 0-9, - and _ for usernames";
$lang["en"]["err_pw1"] = "Please enter the password in both fields";
$lang["en"]["err_pw2"] = "The passwords do not match each other";
$lang["en"]["err_userexists"] = "This user already exists";
$lang["en"]["user"] = "User";
$lang["en"]["password"] = "Password";
$lang["en"]["password2"] = "Repeat password";
$lang["en"]["download"] = "Download &amp; save";



session_start();

if (!isset($_SESSION["users"])) {
	$_SESSION["users"] = array();
}

if (!isset($_SESSION["groups"])) {
	$_SESSION["groups"] = array("master", "admin", "member", "user");
}

if (isset($_GET["del"]) && is_numeric($_GET["del"]) && array_key_exists($_GET["del"], $_SESSION["users"])) {
	unset($_SESSION["users"][$_GET["del"]]);
}

if (isset($_POST["groups"]) && !empty($_POST["groupssubmit"])) {
    $groups = trim($_POST["groups"]);
    if (preg_match('~^[a-z0-9_-]+((\r|\n|\r\n)[a-z0-9_-]+)*$~i', $groups)) {
        $_SESSION["groups"] = explode("\n", $groups);
        $_SESSION["groups"] = array_map("trim", $_SESSION["groups"]);
    }
}

if (isset($_POST["upload"]) && $_FILES["file"]["size"] > 0 && $_FILES["file"]["size"] < 50 * 1024) {
    if (isset($_POST["override"])) $_SESSION["users"] = array();
    $upload = file($_FILES["file"]["tmp_name"], true);
    $upload = array_map("trim", $upload);

    foreach ($upload as $admin) {
        if (!preg_match('#^([a-z0-9-_]+):([a-z0-9-_]+):([a-f0-9]{40})$#i', $admin, $subpatterns)) {
            continue;
        }
        if (!in_array($subpatterns[2], $_SESSION["groups"])) {
            $_SESSION["groups"][] = $subpatterns[2];
        }
        foreach ($_SESSION["users"] as $id => $admin2) {
            if ($admin2["user"] == $subpatterns[1]) {
                unset($_SESSION["users"][$id]);
            }
        }
        $_SESSION["users"][] = array("user"=>$subpatterns[1], "group" => $subpatterns[2], "password" => $subpatterns[3]);
    }
}

if (isset($_POST["submit"]) && !is_numeric($_GET["edit"])) {
	$edit = false;

	$error = array();
	if (!isset($_POST["user"]) || !preg_match('#^[a-z0-9-_]+$#i', $_POST["user"])) {
		$error[] = $lang[$language]["err_user"];
	}
	if (!isset($_POST["group"]) || !in_array($_POST["group"], $_SESSION["groups"])) {
		$error[] = $lang[$language]["err_group"];
	}
	if (empty($_POST["password1"]) || empty($_POST["password2"])) {
		$error[] = $lang[$language]["err_pw1"];
	}
	if ($_POST["password1"] != $_POST["password2"]) {
		$error[] = $lang[$language]["err_pw2"];
	}
    foreach ($_SESSION["users"] as $admin) {
        if ($admin["user"] == $_POST["user"]) {
            $error[] = $lang[$language]["err_userexists"];
        }
    }

	if (empty($error)) {
		$_POST["password1"] = stripslashes($_POST["password1"]);

		$_SESSION["users"][] = array(
			"user" => $_POST["user"],
			"group" => $_POST["group"],
			"password" => sha1($_POST["password1"])
		);
		$edit = false;
		$user = "";
		$group = "user";
	}
	else {
		$user = htmlspecialchars(stripslashes($_POST["user"]));
		$group = htmlspecialchars(stripslashes($_POST["group"]));
	}
}
elseif (isset($_GET["edit"]) && is_numeric($_GET["edit"]) && array_key_exists($_GET["edit"], $_SESSION["users"])) {
	$edit = $_GET["edit"];
	if (isset($_POST["submit"])) {

		$error = array();

    	if (!isset($_POST["user"]) || !preg_match('#^[a-z0-9-_]+$#', $_POST["user"])) {
    		$error[] = $lang[$language]["err_user"];
    	}
    	if (!isset($_POST["group"]) || !in_array($_POST["group"], $_SESSION["groups"])) {
    		$error[] = $lang[$language]["err_group"];
    	}
        foreach ($_SESSION["users"] as $admin) {
            if ($admin["user"] == $_POST["user"] && $_POST["user"] != $_SESSION["users"][$edit]["user"]) {
                $error[] = $lang[$language]["err_userexists"];
            }
        }
    	if (!empty($_POST["password1"]) && !empty($_POST["password2"]) && $_POST["password1"] != $_POST["password2"]) {
    		$error[] = $lang[$language]["err_pw2"];
    	}


		if (empty($error)) {

		    if (empty($_POST["password1"])) {
		        $pw = $_SESSION["users"][$edit]["password"];
		    }
		    else {
		        $pw = sha1(stripslashes($_POST["password1"]));
		    }

			$_SESSION["users"][$edit] = array(
				"user" => $_POST["user"],
				"group" => $_POST["group"],
				"password" => $pw
			);
			$edit = false;
			$user = "";
			$group = "user";
		}
		else {
			$user = htmlspecialchars(stripslashes($_POST["user"]));
			$group = htmlspecialchars(stripslashes($_POST["group"]));
		}
	}
	else {
		$user = $_SESSION["users"][$_GET["edit"]]["user"];
		$group = $_SESSION["users"][$_GET["edit"]]["group"];
	}
}
else {
	$edit = false;
	$user = "";
	$group = "user";
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-2" />
<title><?php echo $lang[$language]["title"] ?></title>
<link href="style.css" type="text/css" rel="stylesheet" />
</head>
<body>
<img src="http://images.gw-2.de/images/901e2d94448ee5576dd3.png" alt="Manu-Admin-Mod" style="margin: auto; display:block" />
<h1><?php echo $lang[$language]["heading"] ?></h1>

<p><a href="?lang=<?php echo $lang[$language]["otherlang"]; ?>"><?php echo $lang[$language]["changelang"]; ?></a></p>

<?php

if (isset($_POST["generate"])) {
	echo "<p><b>tcp_user.db:</b><br /><textarea cols='117' rows='20' wrap='off'>";

	$file = "";
	$file .= "; This file contains all users that can connect via TCP-Interface
; It will be overwritten by the mod automatically
; Do not make any comments inhere
;
; To easily administrate this file use the generator at
; http://manuadminmod.de/config/tcp.php
;
; Description:
; Each line is a user with the following syntax:
; loginname:group:sha1_of_password\n\n";

	foreach ($_SESSION["users"] as $admin) {
		$file .= "$admin[user]:";
		$file .= "$admin[group]:";
		$file .= "$admin[password]\n";
	}

	echo htmlentities($file) . "</textarea></p>";

	echo "<form action='download.php' method='post'>\n";
	echo "<p><input type='submit' value='".$lang[$language]["download"]."' /></p>\n";
	echo "<input type='hidden' value='".base64_encode($file)."' name='data' />\n";
	echo "<input type='hidden' name='filename' value='tcp_user.db' />\n";
	echo "</form>\n";
}

?>

<fieldset>
<legend><?php echo $lang[$language]["currentadmins"] ?></legend>
<table cellspacing="1">
<tr><th><?php echo $lang[$language]["user"] ?></th><th><?php echo $lang[$language]["group"] ?></th><th><?php echo $lang[$language]["password"] ?></th><th></th><th></th></tr>
<?php

foreach ($_SESSION["users"] as $adminid => $admin) {
	echo "<tr>\n";
	echo "<td><i>" . $admin["user"] . "</i></td>";
	echo "<td>" . $admin["group"] . "</td>";
	echo "<td>********</td>";
	echo "<td><a href='?edit=$adminid&amp;lang=$language'>".$lang[$language]["edit"]."</a></td>";
	echo "<td><a href='?del=$adminid&amp;lang=$language'>".$lang[$language]["del"]."</a></td>";
	echo "</tr>\n";
}

?>
</table>

<form action="tcp.php?lang=<?php echo $language ?>" method="post">
<p><input type="submit" name="generate" value="<?php echo $lang[$language]["generate"] ?>" /></p>
</form>
</fieldset>

<fieldset>
<legend><?php echo $lang[$language]["addadmin"] ?></legend>

<?php
if (!empty($error)) {
	echo "<p class='error'><b>".$lang[$language]["error"].":</b><br />" . implode("<br />\n", $error) . "</p>\n";
}
?>

<form action="tcp.php?edit=<?php echo $edit ?>&amp;lang=<?php echo $language ?>" method="post">
<table cellspacing="1">
<tr>
<td><b><?php echo $lang[$language]["user"] ?>: </b></td>
<td><input type="text" name="user" value="<?php echo $user ?>" size="34" /> </td>
</tr>
<tr>
<td><b><?php echo $lang[$language]["group"] ?>: </b></td>
<td><select name='group'><?php
foreach ($_SESSION["groups"] as $value) {
    if ($group == $value) {
        echo "<option value='$value' selected='selected'>$value</option>";
    }
    else {
        echo "<option value='$value'>$value</option>";
    }
}
?></select></td>
</tr>
<tr>
<td><b><?php echo $lang[$language]["password"] ?>: </b></td>
<td><input type="password" name="password1" value="" size="34" /></td>
</tr>
<tr>
<td><b><?php echo $lang[$language]["password2"] ?>:</b></td>
<td><input type="password" name="password2" value="" size="34" /></td>
</tr>
</table>
<p><input type="submit" name="submit" value="<?php echo $lang[$language]["save"] ?>" /><?php if ($edit !== false) echo " <a href='tcp.php?lang=$language'>".$lang[$language]["canceledit"]."</a>" ?></p>
</form>
</fieldset>
<fieldset>
<legend><?php echo $lang[$language]["loadfile"]; ?></legend>
<form action="" method="post" enctype="multipart/form-data">
<p><input type="file" name="file" size="50" /><input type="submit" value="<?php echo $lang[$language]["load"]; ?>" name="upload" /> <input type="checkbox" name="override" id="override" checked="checked" /> <label for="override"><?php echo $lang[$language]["override"]; ?></label></p>
</form>
</fieldset>
<fieldset>
<legend><?php echo $lang[$language]["groups"] ?></legend>
<form action="tcp.php?lang=<?php echo $language ?>" method="post">
<textarea cols="30" rows="5" name="groups"><?php echo implode("\n", $_SESSION["groups"]); ?></textarea><br />
<small><?php echo $lang[$language]["onegroup"] ?></small>
<p><input type="submit" name='groupssubmit' value="<?php echo $lang[$language]["save"] ?>" /></p>
</form>
</fieldset>
<p style='text-align: center'>Copyright by <a href='http://manuadminmod.de/'>ManuAdminMod.de</a></p>
</body>
</html>