<?php

/*
PLUGIN: Warns
=============
Admins can warn players with !warn [reason]; when a player has more than X
warnings he will be kicked/banned

CONFIG
------
[warns]
enabled = 1                            ;enable plugin
warnstokick = 3                        ;warnings to kick
mode = "tempban"                       ;kick/ban/tempban
kickreason = "To many warns by admin"  ;Reason for kick

COMMANDS
--------
!warn

NAMESPACE: warns

Functions:
    warn_main

*/

$mod->setDefaultCV("warns", "enabled", 0);
$mod->setDefaultCV("warns", "warnstokick", 3);
$mod->setDefaultCV("warns", "mode", "tempban");
$mod->setDefaultCV("warns", "kickreason", "To many warns by admin");

$mod->registerCommand("warn", "|^warn \S.*$|i", "warn_main");

$warns_playerwarns = array();

function warn_main($guid, $parameters) {
    global $mod;
    global $players;
    global $warns_playerwarns;

    if (!$mod->getCV("warns", "enabled")) {
        return false;
    }

    $parastring = implode(" ", $parameters);
    if (strpos($parastring, "\\") !== false) {
        list($player, $parameters) = explode("\\", $parastring, 2);
        $player = trim($player);
        $parameters = array(trim($parameters));
    }
    else {
	    $player = array_shift($parameters);
    }
	$towarn = $mod->findPlayerGuid($player);

	if (!$towarn) {
        $players[$guid]->say($mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
        return false;
	}

    $rankwarner = $this->players[$guid]->getRank();
    $rankwarned = $this->players[$towarn]->getRank();
    if ($rankwarner > $rankwarned) {
        $flag = "i";
    }
    elseif ($rankwarner == $rankwarned) {
        $flag = "o";
    }
    else {
        $flag = "u";
    }
	if ($players[$towarn]->isProtected("W,".$flag)) {
        $players[$guid]->say($mod->getLngString("cantEffectProtected"));
        return false;
    }

	$reason = implode(" ", $parameters);

	$mod->findReason($reason);

	$players[$towarn]->warns_warns ++;

	if (!array_key_exists($towarn, $warns_playerwarns)) {
	    $warns_playerwarns[$towarn] = 0;
	}

	$warns_playerwarns[$towarn] ++;


	$players[$towarn]->say($mod->getLngString("warnedByAdmin", array("<REASON>", "<WARNS>", "<MAXWARNS>"), array($reason, $warns_playerwarns[$towarn], $mod->getCV("warns", "warnstokick"))));
	$GLOBALS['logging']->write(MOD_NOTICE, "Warns: Player '".$players[$towarn]->getName()."' has been warned, reason: '$reason', PID".$players[$towarn]->getPID().", GUID:".$players[$towarn]->getGuid());

	$players[$guid]->say($mod->getLngString("hasBeenWarned", array("<NAME>", "<REASON>", "<WARNS>", "<MAXWARNS>"), array($players[$towarn]->getName(), $reason, $warns_playerwarns[$towarn], $mod->getCV("warns", "warnstokick"))));

	if ($warns_playerwarns[$towarn] >= $mod->getCV("warns", "warnstokick")) {
    	switch ($mod->getCV("warns", "mode")) {
            case "tempban":
                $players[$towarn]->tempBan($mod->getCV("warns", "kickreason"));
                break;
            case "kick":
                $players[$towarn]->kick($mod->getCV("warns", "kickreason"));
                break;
            case "ban":
                $players[$towarn]->ban($mod->getCV("warns", "kickreason"));
                break;
        }
	}

}