<?php


/*

[reserveslots]
enabled = 1
slots = 4
keepfree = 1
kickreason = "Using a reserved slot"

*/

$mod->setDefaultCV("reserveslots", "enabled", 0);
$mod->setDefaultCV("reserveslots", "slots", 4);
$mod->setDefaultCV("reserveslots", "keepfree", 1);
$mod->setDefaultCV("reserveslots", "kickreason", "Kicked for using a reserve slot");

$reserveslots = new reserveslots();

$mod->registerEvent("serverRestart", "init", $reserveslots);
$mod->registerEvent("playerJoined", "eventPlayerJoined", $reserveslots);
$mod->registerEvent("playerQuit", "eventPlayerQuit", $reserveslots);
$mod->registerCommand("reserveslot", '~^reserveslot \S.*$~i', "commandReserveSlot", $reserveslots);



class reserveslots {
	private $players;
	private $mod;
	private $logging;

	private $reservedused;
	private $maxplayers;

	public function __construct() {
        $this->mod = & $GLOBALS['mod'];
        $this->logging = & $GLOBALS['logging'];
        $this->players = & $GLOBALS['players'];

        $this->init();
	}

    public function init() {
        if (!$this->mod->getCV("reserveslots", "enabled")) {
            return;
        }

        $this->maxplayers = intval($this->mod->rconGetDvar("sv_maxclients"));

        $this->reservedused = array();

        foreach (array_keys($this->players) as $guid) {
            if ($this->hasReservedSlot($guid)) {
                $this->reservedused[$guid] = $guid;
            }
        }


        //Bereits alle reserved slots belegt
        if (count($this->reservedused) >= $this->mod->getCV("reserveslots", "slots")) return;

        //Wenn soviele Spieler auf dem Server sind, dass sie einen
        //freizuhaltenden Slot blockieren, solange Spieler kicken,
        //bis alle freizuhaltenden Slots wieder frei sind
        if (count($this->players) > $this->maxplayers - $this->mod->getCV("reserveslots", "keepfree")) {
            $tokick = count($this->players) - $this->maxplayers + $this->mod->getCV("reserveslots", "keepfree");
            $this->kickLastJoined($tokick);
        }

/*
        if ($this->maxplayers - $this->mod->getCV("reserveslots", "keepfree") < count($this->players) && count($this->reservedused) < $this->mod->getCV("reserveslots", "slots")) {
            for ($i = count($this->players) + $this->mod->getCV("reserveslots", "keepfree") - $this->maxplayers; $i > 0; $i --) {
                $this->kickLastJoined();
            }
        }
*/
    }

    private function hasReservedSlot($guid) {
        if (!isset($this->players[$guid]->getAdmin()->reserveslot)) {
            return false;
        }

        return (bool)(int)$this->players[$guid]->getAdmin()->reserveslot;
    }

    private function kickLastJoined($number = 1) {
        if ($number <= 0) return;

        $players = array();

        foreach(array_keys($this->players) as $player) {
            if ($this->hasReservedSlot($player)) continue;

            $players[$player] = $this->players[$player]->joined;
        }


        arsort($players);
        $players = array_keys($players);

        for ($i = 0; $i < $number; $i++) {
            $this->players[$players[$i]]->kick($this->mod->getCV("reserveslots", "kickreason"));
        }
/*

        $joined = 2147483647;
        $guid = "";
        foreach(array_keys($this->players) as $player) {
            if ($this->players[$player]->joined < $joined && !$this->hasReservedSlot($player)) {
                $joined = $this->players[$player]->joined;
                $guid = $player;
            }
        }
        if ($guid == "") return;
        $this->players[$guid]->kick($this->mod->getCV("reserveslots", "kickreason"));
*/
    }

    public function eventPlayerJoined($guid) {
        if (!$this->mod->getCV("reserveslots", "enabled")) {
            return;
        }

        //Der Reihe nach verschiedene Prfungen durchfhren

        //Prfen, ob der neue User einen RS hat oder nicht
        $hasreserved = $this->hasReservedSlot($guid);

        //Wenn er einen RS hat, dann in die interne Liste eintragen
        if ($hasreserved) {
            $this->reservedused[$guid] = $guid;
        }

        // Sind jetzt bereits alle RS belegt (der neue kann auch den letzten
        // belegt haben)? Dann tue nichts...
        if (count($this->reservedused) >= $this->mod->getCV("reserveslots", "slots")) {
            //Bereits alle reserved slots belegt
            return;
        }

        //A: Herausfinden, wieviele Slots jetzt noch freigehalten werden
        //    -> Von den RSs die benutzten abziehen und dann Minimum von dieser
        //       Differenz bzw. den freizuhaltenden Slots bestimmen


        $keepfree = min(array(
            $this->mod->getCV("reserveslots", "slots") - count($this->reservedused),
            $this->mod->getCV("reserveslots", "keepfree")
        ));

        $keepfree = $keepfree < 0 ? 0 : $keepfree;

        //B: Nun prfen, ob noch mindestens so viele Slots frei sind

        if ($this->maxplayers - count($this->players) >= $keepfree) {
            //I) Ja, es sind noch genug frei
            return;
        }
        else {
            //II) Nein, es sind nicht mehr so viele frei, es muss einer weg
            //Am besten der, der gerade gejoint ist. Oder, wenn dieser einen RS
            //hat, dann der, der zuletzt gejoint ist, aber keinen RS hat

            if (!$hasreserved) {
                $this->players[$guid]->kick($this->mod->getCV("reserveslots", "kickreason"));
            }
            else {
                $this->kickLastJoined();
            }
            return;
        }
    }

    public function eventPlayerQuit($guid) {
        if (!$this->mod->getCV("reserveslots", "enabled")) {
            return;
        }

        if (array_key_exists($guid, $this->reservedused)) unset($this->reservedused[$guid]);
    }

    public function commandReserveSlot($guid, $parameters) {

        if (!$this->mod->getCV("reserveslots", "enabled")) {
            return;
        }

        $name = implode(" ", $parameters);

		$player = $this->mod->findPlayerGuid($name);

		if (!$player) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($name)));
			return;
		}

		$admin = $this->players[$player]->getAdmin();

		if ($admin->getGroup()->getShortName() == group::NAME_DEFAULT) {
		    $this->players[$guid]->say($this->mod->getLngString("errorMustBeAdmin"));
		    return;
		}

		$admin->reserveslot = (int)empty($admin->reserveslot);
		if ($admin->reserveslot) {
		    $this->players[$guid]->say($this->mod->getLngString("hasNowReserveSlot", "<NAME>", $this->players[$player]->getName()));
		}
		else {
		    $this->players[$guid]->say($this->mod->getLngString("hasNoReserveSlotAnymore", "<NAME>", $this->players[$player]->getName()));
		}
    }
}




?>