<?php


$mod->registerEvent("everyTime", "plugin_update");
$mod->setDefaultCV("plugin_update", "enabled", 0);
$mod->setDefaultCV("plugin_update", "updateserver", "http://127.0.0.1/update.cfg");
$mod->setDefaultCV("plugin_update", "downloadserver", "ftp://127.0.0.1/");
$mod->setDefaultCV("plugin_update", "ftp_user", "anonymous");
$mod->setDefaultCV("plugin_update", "ftp_pw", "");
$mod->setDefaultCV("plugin_update", "interval", 1);
$mod->setDefaultCV("plugin_update", "check_all", 1);
$mod->registerCommand("updates", false, "updates_cmd");
$mod->registerCommand("download", false, "download");



$last_check = 0;
function plugin_update ()
{
global $mod;
global $logging;


//prüfen ob angeschalten
if (!$mod->getCV("plugin_update", "enabled")) {
		return;
	}

//update datei laden
$server_version = parse_ini_file($mod->getCV("plugin_update", "updateserver"));


//eigene Versionen Prüfen
$versionen = array();
$dir = opendir("plugins");
while (($file = readdir($dir)) !== false) {
	if (in_array($file, array(".", ".."))) continue;
	if (substr($file, -4, 4) == ".php") {
	
$datei = substr($file, 0, -4);

$x=0;
while ($x+1<strlen($datei)) {
$x++;
if(stristr($datei[$x],"#")){
break;
}
}

$plugin = substr($datei, 0,$x);
$x++;
$d = "-";
$d .= $x;
$version = substr($datei, -$d);

if ($version == false && $mod->getCV("plugin_update", "check_all") == false) continue;
elseif ($version == false && $mod->getCV("plugin_update", "check_all") == true) $version = "0.0";

$versionen[$plugin] = $version;

}
}

//Vergleichen der 2 Versionen
$updates = array();
	foreach( $versionen as $key => $value){
	
		if(!empty($server_version[$key]) && $server_version[$key] > $value){
			$updates[$key]["mam"] = $value;
			$updates[$key]["server"] = $server_version[$key];
		}
	}
	update_nachricht($updates);
	return $updates;
}

function update_nachricht($updates) {
global $mod;
global $logging;
global $last_check;
    if (time() - $last_check < $mod->getCV("plugin_update", "interval") * 60) {
        return;
    }	
	    $logging->write(MOD_NOTICE, "New Updates:");	
		foreach ($updates as $p => $v){
		
		$notiz = $p;
		$notiz .= ": ";
		$notiz .= $updates[$p]["mam"];
		$notiz .= " => ";
		$notiz .= $updates[$p]["server"];
		
		
		$logging->write(MOD_NOTICE, $notiz);
}
$last_check = Time();
}

function updates_cmd ($guid) {
global $mod;
global $players;
    $player = &$players[$guid];
	$updates = plugin_update();
	
	$player->say("New Updates:");
		foreach ($updates as $p => $v){
		
		$notiz = $p;
		$notiz .= ": ";
		$notiz .= $updates[$p]["mam"];
		$notiz .= " => ";
		$notiz .= $updates[$p]["server"];
		$player->say($notiz);
}
}

function download ($guid){
global $mod;
global $players;
global $logging;
    $player = &$players[$guid];
$benutzer = $mod->getCV("plugin_update", "ftp_user");
$passwd = $mod->getCV("plugin_update", "ftp_pw");
$server = $mod->getCV("plugin_update", "downloadserver");
$updates = plugin_update();



if (!is_dir("./temp"))
{
	$player->say($mod->getLngString("dir_fail"));
	return false;
	}


// Die Verbindung herstellen
$connection_id = ftp_connect($mod->getCV("plugin_update", "downloadserver"));

// Mit Benutzername und Kennwort anmelden 
$login_result = ftp_login($connection_id, $benutzer, $passwd);

// überprüfen ob alles gutgegangen ist 
if ((!$connection_id) || (!$login_result)) {  
	    $logging->write(MOD_ERROR, $mod->getLngString("ftp_error")); 
	    $logging->write(MOD_ERROR,  $mod->getLngString("login_error", "<user>", $benutzer)); 
		$player->say($mod->getLngString("ftp_error"));
		$player->say($mod->getLngString("login_error", "<user>", $benutzer));
	return 0; 
} 
else {  
	    $logging->write(MOD_NOTICE, $mod->getLngString("login_ok", "<server>", $server));
}

foreach ($updates as $p => $v){
	
	$dat = $p ."#" .$updates[$p]["server"] .".php";
	$local = "./temp/" .$dat;
	$down = $dat;
	
	
$download = ftp_get($connection_id,$local,$down,FTP_BINARY); 

// download-Status überprüfen
if (!$download) {  
	    $logging->write(MOD_NOTICE, $mod->getLngString("download_fail", "<file>", $dat)); 
		$player->say($mod->getLngString("download_fail", "<file>", $dat));
} 
else {  
	    $logging->write(MOD_NOTICE, $mod->getLngString("download_ok", "<file>", $dat));
		$player->say($mod->getLngString("download_ok", "<file>", $dat));		
}

}

}
 

?>