<?php

/*
PLUGIN: Pingkicker
================
Kicks players whos ping is to high.
ATTENTION: This function might not work correctly cause of a bug in the CoD
           RCON response

CONFIG:
-------
[pingkicker]
enabled = 1                         ;Enable plugin
maxping = 150                       ;Maximum ping that a player can have
checkinterval = 30                  ;Check pings every X secounds
warnstokick = 2                     ;Warns until kick
mode = "tempban"                    ;kick/ban/tempban
kickreason = "Your ping is to high" ;Reason of a kick

NAMESPACE: pingkicker

Functions:
    pingkicker_main
    pingkicker_playerInit

Vars:
    $pingkicker_lastcheck

*/

$pingkicker = new pingkicker();

$mod->registerEvent("playerJoined", "playerInit", $pingkicker);
$mod->registerEvent("everyTime", "main", $pingkicker);
$mod->registerEvent("nextMap", "reset", $pingkicker);  //Do not check while the clients are loading the map

$mod->registerCommand("pingkick", "~^pingkick( \d+)?$~i", "commandPingkick", $pingkicker);

$mod->setDefaultCV("pingkicker", "enabled", 0);
$mod->setDefaultCV("pingkicker", "maxping", 150);
$mod->setDefaultCV("pingkicker", "checkinterval", 30);
$mod->setDefaultCV("pingkicker", "warnstokick", 2);
$mod->setDefaultCV("pingkicker", "mode", "tempban");
$mod->setDefaultCV("pingkicker", "kickreason", "Your ping is to high");


class pingkicker {
    private $mod;
    private $logging;
    private $players;

    private $lastcheck;

    public function __construct() {
        $this->mod = &$GLOBALS['mod'];
        $this->logging = &$GLOBALS['logging'];
        $this->players = &$GLOBALS['players'];

        $this->lastcheck = 0;

        foreach (array_keys($this->players) as $player) {
            $this->playerInit($player);
        }
    }

    public function playerInit($guid) {
        $this->players[$guid]->pingkicker_warns = 0;
    }

    public function main() {
        if (!$this->mod->getCV("pingkicker", "enabled")) {
            return;
        }

        if (time() - $this->lastcheck < $this->mod->getCV("pingkicker", "checkinterval")) {
            return;
        }

        $this->lastcheck = time();

        $playerlist = $this->mod->rconPlayerList();

        foreach ($playerlist as $value) {
            if (!array_key_exists($value["guid"], $this->players)) {
                continue;
            }
            if ($value["ping"] <= $this->mod->getCV("pingkicker", "maxping")) {
                $this->players[$value["guid"]]->pingkicker_warns = 0;
            }
            else {
                if ($this->players[$value["guid"]]->isProtected("M,p")) continue;

                $this->players[$value["guid"]]->pingkicker_warns ++;

                if ($this->players[$value["guid"]]->pingkicker_warns >= $this->mod->getCV("pingkicker", "warnstokick")) {
                    switch ($this->mod->getCV("pingkicker", "mode")) {
                        case "tempban":
                            $this->players[$value["guid"]]->tempBan($this->mod->getCV("pingkicker", "kickreason"));
                            break;
                        case "kick":
                            $this->players[$value["guid"]]->kick($this->mod->getCV("pingkicker", "kickreason"));
                            break;
                        case "ban":
                            $this->players[$value["guid"]]->ban($this->mod->getCV("pingkicker", "kickreason"));
                            break;
                    }
                }
                else {
                     $this->players[$value["guid"]]->say($this->mod->getLngString("warningPingToHigh"));
                     $this->logging->write(MOD_NOTICE, "Player '".$this->players[$value["guid"]]->getName()."' has been warned for his high ping (".$value["ping"]."), PID: ".$this->players[$value["guid"]]->getPID().", GUID:".$value["guid"]);
                }
            }
        }
    }

    public function reset() {
        $this->lastcheck = time() + 30;
    }

    public function commandPingkick($guid, $parameters) {
        if (isset($parameters[0]) && is_numeric($parameters[0])) {
            $maxping = $parameters[0];
        }
        else {
            $maxping = $this->mod->getCV("pingkicker", "maxping");
        }

        $playerlist = $this->mod->rconPlayerList();

        foreach ($playerlist as $value) {
            if (!array_key_exists($value["guid"], $this->players)) {
                continue;
            }

            if ($value["ping"] <= $maxping) {
                continue;
            }

            if ($this->players[$value["guid"]]->isProtected("p,M")) continue;

            $this->players[$value["guid"]]->kick($this->mod->getCV("pingkicker", "kickreason"));
        }
    }

}
?>