<?php

class group {
    private $mod;

    static private $groupcfg = array();

    private $short;

    const NAME_DEFAULT = "default";


    public function __construct($short) {
		$this->mod = & $GLOBALS["mod"];

        if (!array_key_exists($short, self::$groupcfg)) {
            throw new Exception("Group '$short' does not exist, check your admins.cfg");
        }
        $this->short = $short;

    }

    public function getCommands() {
		if (in_array("*", self::$groupcfg[$this->short]["commands"])) return $this->mod->getCommandList();
		return self::$groupcfg[$this->short]["commands"];
    }

    public function getLongName() {
        return self::$groupcfg[$this->short]["name"];
    }

    public function getShortName() {
        return $this->short;
    }

    public function getRank() {
        return (int)self::$groupcfg[$this->short]["rank"];
    }

    public function __toString() {
        return $this->getShortName();
    }

    public function getProtection() {
        if (empty(self::$groupcfg[$this->short]["protection"])) {
            return array();
        }
        return explode(",", self::$groupcfg[$this->short]["protection"]);
    }


    //Statische Funktionen

    public static function setConfig($cfg) {
        self::$groupcfg = $cfg;
    }

    public static function getGroups() {
        return array_keys(self::$groupcfg);
    }

    public static function factory($group) {
        return new self($group);
    }

    public static function exists($group) {
        return array_key_exists($group, self::$groupcfg);
    }
}


