<?php



$mod->setDefaultCV("voting", "enabled", 0);
$mod->setDefaultCV("voting", "duration", 45);
$mod->setDefaultCV("voting", "interval", 120);
$mod->setDefaultCV("voting", "annouce", 15);
$mod->setDefaultCV("voting", "minplayers", 3);
$mod->setDefaultCV("voting", "maxvotesperplayer", 2);
$mod->setDefaultCV("voting", "allowkick", 0);
$mod->setDefaultCV("voting", "allowban", 0);
$mod->setDefaultCV("voting", "allowmap", 0);
$mod->setDefaultCV("voting", "allowgametype", 0);
$mod->setDefaultCV("voting", "allownextmap", 0);
$mod->setDefaultCV("voting", "allowrestart", 0);
$mod->setDefaultCV("voting", "allowsetnextmap", 0);
$mod->setDefaultCV("voting", "allowhardcore", 1);
//$mod->setDefaultCV("voting", "allowedmaps", "<maps.cfg>");
//$mod->setDefaultCV("voting", "allowedgametypes", "war,dom,koth,dm,sab,sd");
$mod->setDefaultCV("voting", "banduration", 0);
$mod->setDefaultCV("voting", "ignoremapchange", 0);
$mod->setDefaultCV("voting", "timelimit", 0);

$voting = new voting();

$voting->registerVote("kick",       "Vote_Kick");
$voting->registerVote("ban",        "Vote_Ban");
$voting->registerVote("map",        "Vote_Map");
$voting->registerVote("nextmap",    "Vote_Nextmap");
$voting->registerVote("restart",    "Vote_Restart");
$voting->registerVote("gametype",   "Vote_Gametype");
$voting->registerVote("setnextmap", "Vote_Setnextmap");
$voting->registerVote("hardcore",   "Vote_Hardcore");



class Voting {
    private $mod;
    private $logging;
    private $players;
    private $votes = array();
    private $vote;
    private $mapstart = 0;
    private $votestarted = 0;
    private $lastmap = "";
    private $lastgt = "";

    public function __construct() {
        $this->mod = &$GLOBALS['mod'];
        $this->players = &$GLOBALS['players'];
        $this->logging = &$GLOBALS['logging'];

        $this->mod->registerCommand("vote", false, "commandVote", $this);
        $this->mod->registerCommand("avote", false, "commandAvote", $this);
        $this->mod->registerCommand("yes", false, "commandYes", $this);
        $this->mod->registerCommand("no", false, "commandNo", $this);
        $this->mod->registerCommand("cancel", false, "commandCancel", $this);
        $this->mod->registerCommand("pass", false, "commandPass", $this);

        $this->mod->registerEvent("nextMap", "triggerNextMap", $this);
        $this->mod->registerEvent("everyTime", "triggerEveryTime", $this);
        $this->mod->registerEvent("playerJoined", "playerInit", $this);
        $this->mod->registerEvent("playerSay", "playerSay", $this);
        $this->mod->registerEvent("playerQuit", "playerQuit", $this);

        foreach (array_keys($this->players) as $guid) {
            $this->playerInit($guid);
        }

        $this->mapstart = time();
    }

    public function registerVote($name, $class) {
        if (!class_exists($class)) {
            throw new Exception("Class $class does not exist");
        }

        $this->votes[$name] = $class;
    }

    public function commandVote($guid, $parameters) {
        if (!$this->mod->getCV("voting", "enabled")) return;
        if ($this->isVoteInProgress()) return;

        $parameters = array_map("strtolower", $parameters);


        if (empty ($parameters[0]) || !array_key_exists($parameters[0], $this->votes)) {
            $this->players[$guid]->say($this->mod->getLngString("allowedVotes", "<ALLOWED>", implode(", ", $this->getAllowed())));
            return;
        }

        if (!$this->mod->getCV("voting", "allow".$parameters[0])) {
            $this->players[$guid]->say($this->mod->getLngString("allowedVotes", "<ALLOWED>", implode(", ", $this->getAllowed())));
            return;
        }

        if ($this->players[$guid]->voting_votesstarted >= $this->mod->getCV("voting", "maxvotesperplayer")) {
            $this->players[$guid]->say($this->mod->getLngString("voteMaximumVotesReached"));
            return;
        }

        if (count($this->players) < $this->mod->getCV("voting", "minplayers")) {
            $this->players[$guid]->say($this->mod->getLngString("voteNotNotEnoughPlayers"));
            return;
        }

        if (time () - $this->votestarted < $this->mod->getCV("voting", "interval")) {
            $wait = $this->mod->getCV("voting", "interval") - (time () - $this->votestarted);
            $this->players[$guid]->say($this->mod->getLngString("votePleaseWait", "<WAIT>", $wait));
            return;
        }

        if ($this->mod->getCV("voting", "timelimit") != 0 && time() - $this->mapstart > $this->mod->getCV("voting", "timelimit") * 60) {
            $this->players[$guid]->say($this->mod->getLngString("voteTooLate"));
            return;
        }

        $vote = array_shift($parameters);

        try {
            $this->vote = new $this->votes[$vote]($this, $guid, $parameters);
            $this->votestarted = time();
            $this->logging->write(MOD_NOTICE, "Voting: Vote started: $vote (Parameters: " . implode(", ", $parameters) . ")");
        }
        catch (Vote_Exception $e) {
            $this->players[$guid]->say($e->getMessage());
        }
    }

    private function getAllowed() {
        $allowed = array();
        foreach ($this->votes as $key => $value) {
            if ($this->mod->getCV("voting", "allow".$key)) {
                $allowed[] = $key;
            }
        }
        return $allowed;
    }

    public function playerInit($guid) {
        $this->players[$guid]->voting_votesstarted = 0;
    }

    public function commandYes($guid, $parameters) {
        if (!$this->isVoteInProgress()) return;
        $this->vote->voteYes($guid);
        $this->checkForEarlyEnd();
    }

    public function commandNo($guid, $parameters) {
        if (!$this->isVoteInProgress()) return;
        $this->vote->voteNo($guid);
        $this->checkForEarlyEnd();
    }

    private function checkForEarlyEnd() {
        if ($this->vote->getYes() > count($this->players) / 2 || $this->vote->getNo() > count($this->players) / 2) {
            $this->vote->end();
            $this->logging->write(MOD_NOTICE, "Voting: Vote ended (Yes: " . $this->vote->getYes() . ", No: " . $this->vote->getNo() . ")");
            $this->vote = null;
        }
    }

    private function isVoteInProgress() {
        return $this->vote instanceof Vote;
    }

    public function triggerNextMap($dvars) {

        if ($this->lastmap == $dvars["mapname"] && $this->lastgt == "sd" && $dvars["g_gametype"] = "sd") {
            return;
        }

        $this->lastmap = $dvars["mapname"];
        $this->lastgt = $dvars["g_gametype"];

        $this->mapstart = time();
        if ($this->mod->getCV("voting", "ignoremapchange")) {
            return;
        }
        $this->vote = null;
    }

    public function triggerEveryTime() {
        if (!$this->isVoteInProgress()) return;

        if ($this->vote->selfcanceled) {
            $this->vote->cancel();
            $this->vote = null;
            $this->logging->write(MOD_NOTICE, "Voting: Vote has been self canceled");
            return;
        }

        if (time() - $this->vote->getStarted() > $this->mod->getCV("voting", "duration")) {
            $this->logging->write(MOD_NOTICE, "Voting: Vote ended (Yes: " . $this->vote->getYes() . ", No: " . $this->vote->getNo() . ")");
            $this->vote->end();
            if (array_key_exists($this->vote->getStarter(), $this->players )) {
                $this->players[$this->vote->getStarter()]->voting_votesstarted ++;
            }
            $this->vote = null;
            return;
        }

        $this->vote->triggerEveryTime();
    }

    public function commandPass($guid, $paramters) {
        if (!$this->isVoteInProgress()) return;
        $this->vote->pass();
        $this->vote = null;
            $this->logging->write(MOD_NOTICE, "Voting: Vote has been passed by admin");
    }

    public function commandCancel($guid, $paramters) {
        if (!$this->isVoteInProgress()) return;
        $this->vote->cancel();
        $this->vote = null;
        $this->logging->write(MOD_NOTICE, "Voting: Vote has been canceled by admin");
    }

    public function commandAvote($guid, $parameters) {
        if (!$this->mod->getCV("voting", "enabled")) return;
        if ($this->isVoteInProgress()) return;

        $parameters = array_map("strtolower", $parameters);

        if (empty ($parameters[0]) || !array_key_exists($parameters[0], $this->votes)) {
            $this->players[$guid]->say($this->mod->getLngString("allowedVotes", "<ALLOWED>", implode(", ", array_keys($this->votes))));
            return;
        }

        $vote = array_shift($parameters);

        try {
            $this->vote = new $this->votes[$vote]($this, $guid, $parameters);
            $this->votestarted = time();
            $this->logging->write(MOD_NOTICE, "Voting: Vote forced: $vote (Parameters: " . implode(", ", $parameters) . ")");
        }
        catch (Vote_Exception $e) {
            $this->players[$guid]->say($e->getMessage());
        }
    }

    public function playerSay($args) {
        if (!$this->isVoteInProgress()) return;

        list($guid, $msg, $executed) = $args;
        if ($executed) return;

        $msg = strtolower(trim($this->mod->removecolor($msg)));

        if ($msg == "yes" || $msg == "ja") {
            $this->mod->executeCommand($this->mod->getCV("main", "prefix")."yes", $guid, $executed);
        }
        elseif ($msg == "no" || $msg == "nein") {
            $this->mod->executeCommand($this->mod->getCV("main", "prefix")."no", $guid, $executed);
        }
    }

    public function playerQuit($guid) {
        if ($this->isVoteInProgress()) {
            $this->vote->playerQuit($guid);
        }
    }

}

class Vote_Exception extends Exception {}

abstract class Vote {
    protected $mod;
    protected $players;
    protected $logging;
    protected $parameters;
    protected $parent;
    protected $yes = 0;
    protected $no = 0;
    protected $started = false;
    protected $voted = array();
    protected $lastannounce;
    public $selfcanceled = false;

    public function __construct($parent, $starter, $parameters) {
        $this->mod = &$GLOBALS['mod'];
        $this->players = &$GLOBALS['players'];
        $this->logging = &$GLOBALS['logging'];
        $this->parameters = $parameters;
        $this->parent = $parent;
        $this->starter = $starter;
        $this->yes ++;
        $this->voted[] = $starter;
        $this->started = time();
        $this->lastannounce = time();

        $this->parameterCheck();

        $this->start();
    }

    protected function parameterCheck() {

    }

    public function playerQuit($guid) {}

    //abstract public function getName();

    public function getStarter() {
        return $this->starter;
    }

    //abstract static public function isAllowed();

    abstract public function start();

    abstract public function cancel();

    abstract public function pass();

    abstract public function failed();

    abstract public function announce();

    public function voteYes($player) {
        if (in_array($player, $this->voted)) return;
        $this->yes++;
        $this->voted[] = $player;
        $this->players[$player]->say($this->mod->getLngString("votedYes"));
    }

    public function voteNo($player) {
        if (in_array($player, $this->voted)) return;
        $this->no++;
        $this->voted[] = $player;
        $this->players[$player]->say($this->mod->getLngString("votedNo"));
    }

    public function getVoteRatio() {
        return ($this->yes) / ($this->yes + $this->no);
    }

    public function getYes() {
        return $this->yes;
    }

    public function getNo() {
        return $this->no;
    }

    public function getVotersNum() {
        return ($this->yes + $this->no);
    }

    public function end() {
        if ($this->getVoteRatio() > 0.5) {
            $this->pass();
        }
        else{
            $this->failed();
        }
    }

    public function getParameters() {
        return $this->parameters;
    }

    public function triggerEveryTime() {
        if ($this->started == 0) return;
        if (time() - $this->lastannounce > $this->mod->getCV("voting", "annouce")) {
            $this->announce();
            $this->lastannounce = time();
        }
    }

    public function getStarted() {
        return $this->started;
    }

}

class Vote_Kick       extends Vote {
    private $playerHasQuit = false;

    protected function parameterCheck() {
        if (empty($this->parameters[0])) {
            throw new Vote_Exception($this->mod->getLngString("voteSpecifyPlayer"));
        }
        $search = implode(" ", $this->parameters);
        $this->parameters = $this->mod->findPlayerGuid($search);
		if (!$this->parameters) {
			throw new Vote_Exception($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($search)));
		}
		if ($this->players[$this->parameters]->isProtected("v,M")) {
            throw new Vote_Exception($this->mod->getLngString("cantEffectProtected"));
		}
    }

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteKick", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);
    }

    public function cancel() {
        if ($this->playerHasQuit) {
            $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("votePlayerLeft");
        }
        else {
            $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteKick", "<PLAYER>", $this->players[$this->parameters]->getName());
        }
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteKick", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        $this->players[$this->parameters]->kick("Votekick passed");
    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteKick", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteKick", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function playerQuit ($guid) {
        if ($guid == $this->parameters) {
            $this->selfcanceled = true;
            $this->playerHasQuit = true;
        }
    }

}
class Vote_Ban        extends Vote {
    private $playerHasQuit = false;

    protected function parameterCheck() {
        if (empty($this->parameters[0])) {
            throw new Vote_Exception($this->mod->getLngString("voteSpecifyPlayer"));
        }
        $search = implode(" ", $this->parameters);
        $this->parameters = $this->mod->findPlayerGuid($search);
		if (!$this->parameters) {
			throw new Vote_Exception($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($search)));
		}
		if ($this->players[$this->parameters]->isProtected("v,M")) {
            throw new Vote_Exception($this->mod->getLngString("cantEffectProtected"));
		}
    }

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteBan", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);
    }

    public function cancel() {
        if ($this->playerHasQuit) {
            $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("votePlayerLeft");
        }
        else {
            $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteBan", "<PLAYER>", $this->players[$this->parameters]->getName());
        }
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteKick", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        if ($this->mod->getCV("voting", "banduration") > 0) {
		    $this->players[$this->parameters]->tempBan("Voteban passed", $this->mod->getCV("voting", "banduration"));
		}
		else {
		    $this->players[$this->parameters]->ban("Voteban passed");
		}
    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteBan", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteBan", "<PLAYER>", $this->players[$this->parameters]->getName()) . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function playerQuit ($guid) {
        if ($guid == $this->parameters) {
            $this->selfcanceled = true;
            $this->playerHasQuit = true;
        }
    }

}
class Vote_Map        extends Vote {

    protected function parameterCheck() {
        if (empty($this->parameters[0])) {
            throw new Vote_Exception($this->mod->getLngString("voteSpecifyMap"));
        }
        $search = implode(" ", $this->parameters);
        $map = $this->mod->findMap($search);
		if (!$map) {
			throw new Vote_Exception($this->mod->getLngString("mapNotFound", array("<MAP>"), array($search)));
		}
        if (!$map["voting"]) {
            throw new Vote_Exception($this->mod->getLngString("voteMapNotAllowed"));
        }
        if (!in_array($this->mod->getCurrentGametype(), $map["possiblegametypes"])) {
            throw new Vote_Exception($this->mod->getLngString("mapNotCompatible", array("<MAP>", "<GAMETYPE>", "<SHORTGT>"), array($map["longname"], $this->mod->getLongGametype($this->mod->getCurrentGametype()), $this->mod->getCurrentGametype())));
        }
        $this->parameters = $map["cname"];
    }

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);
    }

    public function cancel() {
        $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteMap", "<MAP>", $this->mod->getLongMapName($this->parameters));
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        sleep(2);
        if (!$this->mod->rconChangeMap($this->parameters)) {
        	$this->mod->rconSay($this->mod->getLngString("mapNotFound", "<MAP>", $this->parameters));
        }
    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

}
class Vote_Nextmap    extends Vote {

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteNextmap") . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);
    }

    public function cancel() {
        $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteNextmap");
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteNextmap") . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        sleep(2);
        $this->mod->rconMapRotate();
    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteNextmap") . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteNextmap") . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

}
class Vote_Restart    extends Vote {

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteRestart") . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);
    }

    public function cancel() {
        $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteRestart");
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteRestart") . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        sleep(2);
        $this->mod->rconMapRestart(true);
    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteRestart") . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteRestart") . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

}
class Vote_Gametype   extends Vote {
    protected function parameterCheck() {
        if (empty($this->parameters[0])) {
            throw new Vote_Exception($this->mod->getLngString("voteSpecifyGametype"));
        }
        if (!$this->mod->mapAllowsGametype($this->mod->getCurrentMap(), $this->parameters[0]) && !$this->mod->mapAllowsGametype($this->mod->getCurrentMap(), $this->mod->correctGametype($this->parameters[0]))) {
            throw new Vote_Exception($this->mod->getLngString("mapNotCompatible", array("<MAP>", "<GAMETYPE>", "<SHORTGT>"), array($this->mod->getLongMapname($this->mod->getCurrentMap()), $this->mod->getLongGametype($this->parameters[0]), $this->parameters[0])));
        }
        $this->parameters = $this->parameters[0];
    }

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteGametype", "<GAMETYPE>", $this->mod->getLongGametype($this->parameters)) . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);
    }

    public function cancel() {
        $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteGametype", "<GAMETYPE>", $this->mod->getLongGametype($this->parameters));
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteGametype", "<GAMETYPE>", $this->mod->getLongGametype($this->parameters)) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        sleep(2);
        $this->mod->rconSetGametype($this->parameters);
        $this->mod->rconMapRestart(true);
    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteGametype", "<GAMETYPE>", $this->mod->getLongGametype($this->parameters)) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteGametype", "<GAMETYPE>", $this->mod->getLongGametype($this->parameters)) . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }
}
class Vote_Setnextmap extends Vote {

    protected function parameterCheck() {
        if (empty($this->parameters[0])) {
            throw new Vote_Exception($this->mod->getLngString("voteSpecifyMap"));
        }
        $search = implode(" ", $this->parameters);
        $map = $this->mod->findMap($search);
		if (!$map) {
			throw new Vote_Exception($this->mod->getLngString("mapNotFound", array("<MAP>"), array($search)));
		}
        if (!$map["voting"]) {
            throw new Vote_Exception($this->mod->getLngString("voteMapNotAllowed"));
        }
        if (!in_array($this->mod->getCurrentGametype(), $map["possiblegametypes"])) {
            throw new Vote_Exception($this->mod->getLngString("mapNotCompatible", array("<MAP>", "<GAMETYPE>", "<SHORTGT>"), array($map["longname"], $this->mod->getLongGametype($this->mod->getCurrentGametype()), $this->mod->getCurrentGametype())));
        }
        $this->parameters = $map["cname"];
    }

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteSetNextMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);
    }

    public function cancel() {
        $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteSetNextMap", "<MAP>", $this->mod->getLongMapName($this->parameters));
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteSetNextMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        //sleep(2);
        $this->mod->rconSetNextMap($this->parameters, $this->mod->getCurrentGametype(), true);
    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteSetNextMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteSetNextMap", "<MAP>", $this->mod->getLongMapName($this->parameters)) . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

}
class Vote_Hardcore   extends Vote {
    private $lngstring;

    public function parameterCheck() {
        $hc = $this->mod->rconGetDvar("scr_hardcore");
        $this->parameters = ($hc == 1) ? false : true;
        $this->lngstring = $this->mod->getLngString($this->parameters ? "enable" : "disable");
    }

    public function start() {
        $say = $this->mod->getLngString("voteStarted") . " " . $this->mod->getLngString("voteHardcore", "<SETTO>", $this->lngstring) . " " . $this->mod->getLngString("voteYesNo");
        $this->mod->rconSay($say);

    }

    public function cancel() {
        $say = $this->mod->getLngString("voteCanceled") . " " . $this->mod->getLngString("voteHardcore", "<SETTO>", $this->lngstring);
        $this->mod->rconSay($say);
    }

    public function pass() {
        $this->mod->rconSay($this->mod->getLngString("votePassed") . " " . $this->mod->getLngString("voteHardcore", "<SETTO>", $this->lngstring) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no)));
        sleep(2);
        $this->mod->rconSetDvar("scr_hardcore", (int) $this->parameters);
        $this->mod->rconMapRestart();

    }

    public function failed() {
        $say = $this->mod->getLngString("voteFailed") . " " . $this->mod->getLngString("voteHardcore", "<SETTO>", $this->lngstring) . " " . $this->mod->getLngString("voteYesNo3", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }

    public function announce () {
        $say = $this->mod->getLngString("voteInProgress") . " " . $this->mod->getLngString("voteHardcore", "<SETTO>", $this->lngstring) . " " . $this->mod->getLngString("voteYesNo2", array("<YES>", "<NO>"), array($this->yes, $this->no));
        $this->mod->rconSay($say);
    }
}

?>