<?php

/*
PLUGIN: Funmessages
================
Players can print funny message with !fun [MSG]

CONFIG:
-------
[funmessages]
enabled = 1                       ;Enable plugin
message1 = "Message 1"
message2 = "Message 2"
andsoon = "More Messages"         ;Messages

COMMANDS:
---------
!fun


NAMESPACE: funmessages

Functions:
    funmessages_main

Commands
    fun

*/

$mod->setDefaultCV("funmessages", "enabled", 0);

$mod->registerCommand("fun", false, "funmessages_main");

function funmessages_main($guid, $parameters) {
    global $mod;
    global $players;

    if (!$mod->getCV("funmessages", "enabled")) {
        return;
    }

    array_map("strtolower", $parameters);

    if (empty($parameters[0]) || $parameters[0] == "enabled" || !$mod->existsCV("funmessages", $parameters[0])) {
        $messages = implode(", ", array_keys($mod->getCVSection("funmessages", array("enabled"))));
        $players[$guid]->say($mod->getLngString("funmessagesAvailable", array("<LIST>"), array($messages)));
        return;
    }

    $search = array(
        "<PLAYER_NAME>",
        "<PLAYER_TEAM>",
        "<PLAYER_LASTKILLER>",
        "<PLAYER_LASTVICTIM>",
        "<PLAYER_LASTWEAPONKILL>",
        "<PLAYER_LASTWEAPONDEATH>",
        "<PLAYER_KILLS>",
        "<PLAYER_DEATHS>",
        "<PLAYER_TEAMKILLS>",
        "<PLAYER_HEADSHOTS>",
        "<TIME>",
    );
    $player = &$players[$guid];

    if ($player->getLastVictim() == $guid) {
        $lastvictim = $mod->getLngString("himself");
    }
    else {
        $lastvictim = ($player->getLastVictim() != false) ? $players[$player->getLastVictim()]->getName() : $mod->getLngString("nobody");
    }
    if ($player->getLastKiller() == $guid) {
        $lastkiller = $mod->getLngString("himself");
    }
    else {
        $lastkiller = ($player->getLastKiller() != false) ? $players[$player->getLastKiller()]->getName() : $mod->getLngString("nobody");
    }
    $replace = array(
        $players[$guid]->getName(),
        $mod->getLongTeamName($player->getTeam()),
        $lastkiller,
        $lastvictim,
        $mod->getLongWeaponName($player->lastweaponkill),
        $mod->getLongWeaponName($player->lastweapondeath),
        $player->kills,
        $player->deaths,
        $player->teamkills,
        $player->headshots,
        date("H:i"),
    );

    $mod->rconSay(str_replace($search, $replace, $mod->getCV("funmessages", $parameters[0])));
}



?>