<?php

class Configparser {
    private $filename;
    private $line = 0;
    private $sections = array();
    private $sectionname = null;
    private $config;
    private $curchar = 0;
    private $totalchars;

    const EOF = "#EOF#";

    public function __construct($filename) {
        $this->filename = $filename;
        $this->readfile();
    }

    private function readfile() {
        if (!is_readable($this->filename)) {
            $this->error("Could not open file");
        }

        $this->config = file_get_contents($this->filename);

        $this->totalchars = strlen($this->config);
    }

    public function parse($parse_sections = true) {
        $this->line = 1;

        if (!$parse_sections) {
            $this->sectionname = "oink";
            $this->sections["oink"] = array();
        }

        while (($c = $this->nextChar()) != self::EOF) {

            //Whitespaces �berspringen
            while ($this->isWhiteSpaceWithNl($c)) {
                if ($c == "\n") $this->line ++;
                $c = $this->nextChar();
            }
            //Kommentare �berspringen
            if ($c == ";" ) {
                $this->handleComment();
                continue;
            }

            if ($c == self::EOF) break;

            //NEUE SECTION
            if ($parse_sections && $c == "[") {
                $this->sectionname = "";

                $c = $this->nextChar();
                while ($this->isWordOrDigit($c)) {
                    $this->sectionname .= $c;
                    $c = $this->nextChar();
                }
                if ($c != "]") {
                    $this->error("Parse Error, unexpected '$c'");
                }
                if (!array_keys($this->sections, $this->sectionname)) {
                    $this->sections[$this->sectionname] = array();
                }
                $this->handleEOL();
                continue;
            }

            //KEY => VALUE ohne SECTION
            if ($this->sectionname == null) {
               $this->error("Parse Error, unexpected '$c'");
            }

            //KEY VALUES PAARE EINLESEN


            //KEY EINLESEN

            //Key ist Zahl
            if ($this->isDigitWithMinus($c)) {
                $zahl = $c;
                $c = $this->nextChar();
                while($this->isDigit($c)) {
                    $zahl .= $c;
                    $c = $this->nextChar();
                }
                $key = intval($zahl);
            }
            //Key ist wort
            else {
                $key = $c;
                $c = $this->nextChar();
                while ($this->isWordOrDigit($c)) {
                    $key .= $c;
                    $c = $this->nextChar();
                }
            }

            //Whitespaces �berspringen
            while ($this->isWhiteSpaceWithoutNl($c)) {
                $c = $this->nextChar();
            }

            //Key als Value verwenden
            if ($c == "\n" || $c == self::EOF) {
                //Fall neue Zeile
                $this->sections[$this->sectionname][] = $key;
                $this->line ++;
                continue;
            }
            if ($c == ";") {
                //Fall Kommentar
                $this->handleComment();
                $this->sections[$this->sectionname][] = $key;
                continue;
            }

            //Irgendein anderes ung�ltiges Zeichen
            if ($c != "=") {
                $this->error("Parse Error, unexpected '$c'");
            }

            //VALUE LESEN

            //Whitespaces nach istgleich �berspringen
            do {
                $c = $this->nextChar();
            }
            while ($this->isWhiteSpaceWithoutNl($c));

            //Hinweis fehlende Zuweisung f�r key
            if ($c == "\n") {
                $this->error("Missing value for $key after equal sign");
            }

            //Zahl als value
            if ($this->isDigitWithMinusAndDot($c)) {


                $point = false;
                if ($c == "-") {
                    $zahl = "-";
                    $c = $this->nextChar();
                }
                else {
                    $zahl = "";
                }

                while ($this->isDigitWithDotAndE($c)) {
                    if ($c == ".") {
                        if ($point) {
                            $this->error("Parse Error, unexpected '.'");
                        }
                        $point = true;
                    }
                    if ($c == "e" || $c == "E") {
                        if ($zahl == "" || $zahl == "-" || $zahl == ".") {
                            $this->error("Parse Error, unexpected 'e'");
                        }
                        $c = $this->nextChar();
                        if ($this->isDigitWithMinus($c)) {
                            $e = $c;
                            $c = $this->nextChar();
                            while($this->isDigit($c)) {
                                $e .= $c;
                                $c = $this->nextChar();
                            }
                            $e = intval($e);
                            $zahl .= "e$e";
                            break;
                        }
                        else {
                            $this->error("Parse Error, unexpected 'e'");
                        }
                    }
                    $zahl .= $c;
                    $c = $this->nextChar();
                }
                if ($c != self::EOF ) {
                    $this->curchar --;
                }
                $value = floatval($zahl);
            }

            //String als Value
            elseif ($c == '"' || $c = "'") {
                //string als value

                $string = "";
                $quote = $c;

                $c = $this->nextChar();

                while ($c != $quote) {
                    $string .= $c;
                    if ($c == "\n") {
                        $this->line++;
                    }
                    if ($c == "\\") {
                        $c = $this->nextChar();
                        $string .= $c;
                    }
                    $c = $this->nextChar();
                }

                //$c = $this->nextChar();

                if ($quote == "\"") {
                    $string = str_replace("$", "\\\$", $string);
                }

                eval("\$value = $quote$string$quote;");

            }

            //Ung�ltiges zeichen
            else {
                $this->error("Parse Error, unexpected '$c'");
            }


            $this->handleEOL();

            if (array_key_exists($key, $this->sections[$this->sectionname])) {
                $this->error("Duplicate entry '$key' for section [$this->sectionname]");
            }
            $this->sections[$this->sectionname][$key] = $value;

        }

        if (!$parse_sections) {
            return $this->sections["oink"];
        }

        return $this->sections;
    }

    private function handleEOL() {
        do  {
            $c = $this->nextChar();
            if ($c == ";" ) {
                $this->handleComment();
                return;
            }
            if ($c == self::EOF ) return;
        }
        while($this->isWhiteSpaceWithoutNl($c));
        if ($c != "\n") {
            $this->error("Parse Error, unexpected '$c'");
        }
        $this->line++;
    }

    private function handleComment() {
        do {
            $c = $this->nextChar();
        }
        while($c != "\n" && $c != self::EOF);
        $this->line ++;
    }


    private function isWhiteSpaceWithoutNl($c) {
        $c = ord($c);
        return (($c >= 9 && $c <= 13 && $c != 10) || $c == 0 || $c == 32);
    }

    private function isWhiteSpaceWithNl($c) {
        $c = ord($c);
        return (($c >= 9 && $c <= 13) || $c == 0 || $c == 32);
    }

    private function isDigitWithMinus($c) {
        $c = ord($c);
        return ($c >= 48 && $c <= 57) || $c == 45;
    }

    private function isDigitWithMinusAndDot($c) {
        $c = ord($c);
        return ($c >= 48 && $c <= 57) || $c == 45 || $c == 46;
    }

    private function isDigitWithDotAndE($c) {
        $c = ord($c);
        return ($c >= 48 && $c <= 57) || $c == 101 || $c == 69 || $c == 46;
    }

    private function isDigit($c) {
        $c = ord($c);
        return ($c >= 48 && $c <= 57);
    }

    private function isWordOrDigit($c) {
        $c = ord($c);
        return ($c >= 48 && $c <= 57) || ($c >= 65 && $c <= 90) || ($c >= 97 && $c <= 122) || $c == 95;

    }

    private function nextChar() {
        if ($this->curchar == $this->totalchars) {
            return self::EOF;
        }
        return $this->config[$this->curchar ++];
    }

    private function error($msg) {
        throw new Parser_Exception($msg, $this->filename, $this->line);
    }


    public static function dParse($file, $sections = true) {
        $p = new self($file);

        return $p->parse($sections);
    }
}


class Parser_Exception extends Exception {
    private $configLine;
    private $filename;

    public function __construct($message, $filename, $configLine = 0) {
        $this->configLine = $configLine;
        $this->filename = $filename;
        parent::__construct($message);
    }

    public function getConfigLine() {
        return $this->configLine;
    }

    public function getFilename() {
        return $this->filename;
    }
}
