<?php

//Das Event registrieren
$mod->registerEvent("playerJoined", "welcomemessages_send");

//Die Standart CVs setzen, falls sie nicht in der config.cfg gesetzt sind
$mod->setDefaultCV("welcomemessages", "enabled", 0);
$mod->setDefaultCV("welcomemessages", "time", 120);
$mod->setDefaultCV("welcomemessages", "whisper", 0);

//Hauptfunktion die aufgerufen wird, wenn ein Spieler joint; Argument: GUID des neuen Spielers
function welcomemessages_send($guid) {
	global $players;
	global $mod;

	//Ist [welcomemessages]enabled = 1
	if (!$mod->getCV("welcomemessages", "enabled")) {
		return false;
	}

	//Gruppe des neuen Spielers abrufen
	$group = $players[$guid]->getGroup();

	//Existiert eine Welcomemessage fr diese Gruppe?
	if ($mod->existsCV("welcomemessages", $group->getShortName())) {

		//Fhre die replaces in der Message durch
		$search = array(
			"<PLAYER_NAME>",
			"<GROUP_NAME>"
		);
		$replace = array(
			$players[$guid]->getName(),
			$group->getLongName()
		);

		//Sende die Message
		if ($mod->getCV("welcomemessages", "whisper")) {
		    $players[$guid]->say(str_replace($search, $replace, $mod->getCV("welcomemessages", $group->getShortName())));
		}
		else {
		    $mod->rconSay(str_replace($search, $replace, $mod->getCV("welcomemessages", $group->getShortName())));
		}
	}
}

?>