<?php


/*
PLUGIN: Weaponrestrictions
================
Kicks players automatically when they are using a restricted weapon

CONFIG:
-------
[weaponrestrictions]
enabled = 1                                       ;Enable plugin
weapons = "gl,frag_grenade_short"                 ;restricted weapons
warnstokick = 2                                   ;Warns until players get kicked
mode = "tempban"                                  ;kick/ban/tempban
kickreason = "Used a restricted weapon: <WEAPON>" ;Reason of the kick


NAMESPACE: weaponrestrictions

Functions:
     weaponrestrictions_main
     weaponrestrictions_playerInit

*/

$mod->setDefaultCV("weaponrestrictions", "enabled", 0);
$mod->setDefaultCV("weaponrestrictions", "weapons", "");
$mod->setDefaultCV("weaponrestrictions", "warnstokick", 2);
$mod->setDefaultCV("weaponrestrictions", "mode", "tempban");
$mod->setDefaultCV("weaponrestrictions", "kickreason", "Used a restricted weapon: <WEAPON>");

$mod->registerEvent("playerJoined", "weaponrestrictions_playerInit");
$mod->registerEvent("playerKill", "weaponrestrictions_main");
$mod->registerEvent("playerTeamKill", "weaponrestrictions_main");


//Init Players because playerJoined isn't called at startup
array_map("weaponrestrictions_playerInit", array_keys($players));

function weaponrestrictions_main($parameters) {
    global $mod;
    global $players;
    global $logging;
    list($killer_guid, $victim_guid, $weapon) = $parameters;

    if (!$mod->getCV("weaponrestrictions", "enabled")) {
        return;
    }

    if ($players[$killer_guid]->isProtected("r,M")) {
        return;
    }

    $restricted = false;
    $weapons = explode(",", strtolower($mod->getCV("weaponrestrictions", "weapons")));

    if ($weapon[1] == "MOD_MELEE") {
        if (in_array("knife", $weapons)) {
            $restricted = true;
        }
        else {
            //Dont warn when player knived while he had a restricted weapon
            return;
        }
    }

    else {
        $weapmod = $weapon[0];

    	foreach ($weapons as $value) {
    	    if ($value{0} != "*") {
    	        if (strpos($weapmod, $value . "_") === 0) {
        			$restricted = true;
        			break;
        		}
    	    }
    	    else {
    	        $value = substr($value, 1);
    	        if (strpos($weapmod, $value . "_") !== false) {
        			$restricted = true;
        			break;
        		}
    	    }

    	}
    }

	if (!$restricted) return;

	$players[$killer_guid]->weaponrestrictions_warns ++;

	$weaponlong = $mod->getLongWeaponName($weapon);

	if ($players[$killer_guid]->weaponrestrictions_warns >= $mod->getCV("weaponrestrictions", "warnstokick")) {
        switch ($mod->getCV("weaponrestrictions", "mode")) {
            case "tempban":
                $players[$killer_guid]->tempBan(str_replace("<WEAPON>", $weaponlong, $mod->getCV("weaponrestrictions", "kickreason")));
                break;
            case "kick":
                $players[$killer_guid]->kick(str_replace("<WEAPON>", $weaponlong, $mod->getCV("weaponrestrictions", "kickreason")));
                break;
            case "ban":
                $players[$killer_guid]->ban(str_replace("<WEAPON>", $weaponlong, $mod->getCV("weaponrestrictions", "kickreason")));
                break;
        }
	}
	else {
	    $players[$killer_guid]->say($mod->getLngString("usedRestrictedWeapon", array("<WEAPON>", "<WARNS>", "<MAXWARNS>"), array($weaponlong, $players[$killer_guid]->weaponrestrictions_warns, $mod->getCV("weaponrestrictions", "warnstokick"))));
	    $logging->write(MOD_NOTICE, "Player '".$players[$killer_guid]->getName()."' has been warned for using restricted weapon: $weaponlong, PID: ".$players[$killer_guid]->getPID().", GUID: ".$killer_guid);
	}
}

function weaponrestrictions_playerInit($guid) {
    $GLOBALS['players'][$guid]->weaponrestrictions_warns = 0;
}

?>