<?php

$mod->setDefaultCV("tcp_query", "enabled",  0);
$mod->setDefaultCV("tcp_query", "ip",  "0.0.0.0");
$mod->setDefaultCV("tcp_query", "port",  1337);
$mod->setDefaultCV("tcp_query", "logintimeout",  30);
$mod->setDefaultCV("tcp_query", "maxconnections",  5);
$mod->setDefaultCV("tcp_query", "whitelist",  "127.0.0.1,localhost");
$tcp_query = new tcp_query();

$mod->registerEvent("everyTime", "everyTime", $tcp_query);


class tcp_query {
    private $socket = false;
    private $connections = array();
	private $shell_con = array();
    private $enabled = false;
    private $mod;
    private $logging;
    private $players;
    private $userDB = array();

    public function __construct() {
        $this->mod     =& $GLOBALS["mod"];
        $this->logging =& $GLOBALS["logging"];
        $this->players =& $GLOBALS["players"];


        $this->enabled = (bool)(int)$this->mod->getCV("tcp_query", "enabled");

        if (!$this->enabled) return;

        $this->initSocket();

    }

    public function eventReadConfig() {
        if ($this->enabled && !$this->mod->getCV("tcp_query", "enabled")) {
            $this->writeAll("You have been disconnected: TCP-Interface has been disabled by admin\n");

            foreach (array_keys($this->connections) as $conection) {
                unset ($this->connections[$conection]);
            }
        }
        elseif (!$this->enabled && $this->mod->getCV("tcp_query", "enabled")) {
            $this->enabled = true;
            $this->initSocket();
            $this->readUserDB();
        }
        elseif ($this->enabled) {
            $this->readUserDB();
        }
    }	
	
	
	
	
private function initSocket() {
        $this->socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
        if (!$this->socket) {
            $this->socketError();
            return;
        }
        if (!socket_bind($this->socket, $this->mod->getCV("tcp_query", "ip"), $this->mod->getCV("tcp_query", "port"))) {
            $this->socketError($this->socket);
            return;
        }
        if (!socket_listen($this->socket)) {
            $this->socketError($this->socket);
            return;
        }
        if (!socket_set_nonblock($this->socket)) {
            $this->socketError($this->socket);
            return;
        }
    }

private function socketError($socket = NULL) {
        $this->enabled = false;
        $err = socket_last_error($socket);
        $this->logging->write(MOD_WARNING, "TCP-Query: Socket-Error: " . socket_strerror($err));
    }

   public function everyTime() {
        if (!$this->enabled) return;

        $this->checkForConnections();

        foreach (array_keys($this->connections) as $conection) {
            //Vorsorge gegen Fehlermeldungen wenn die Verbindungen whrend der Schleifenausfhrung gelscht wurden
            if (!array_key_exists($conection, $this->connections)) continue;

//            $this->connections[$conection]->everyTime();
//            if ($this->connections[$conection]->closed) {
//                unset ($this->connections[$conection]);
//            }
        }
    }

    private function checkForConnections() {
        $connection = @socket_accept($this->socket);
        if (!$connection) return false;
        socket_set_nonblock($connection);
        socket_getpeername($connection, $ip, $port);
		$timeout = "100";
		$time = time();
		//while(time() - $time <= $timeout) {  //schleife...
	    $read = @socket_read($connection, 3, PHP_BINARY_READ);
		$read = trim($read);
		if (!empty($read)) {
		echo $read ."\n";		
		 if ($read == "mam" && in_array($ip, explode(",", $this->mod->getCV("tcp_query", "whitelist")))){
		// socket_write($connection, "Connected as mam, IP is {$ip}\n");
		 echo "ok\n";
		 		 $this->shell_con[] = new shell_tcp($connection);
		 
		}
		else if ($read == "out") {
	       if (count($this->connections) >= $this->mod->getCV("tcp_query", "maxconnections")) {
           socket_write($connection, chr(MT_CONSOLE).chr(0)."Maximum connections reached, you'll be disconnected\n");
           socket_close($connection);
            return;
		//	break; // fr schleife
        }
		 socket_write($connection, "Connected as out\n");
		 echo "goingout";
		 $this->connections[] = new tcp_query_connection($connection);
		}
		else
		{
		socket_write($connection, "Connection Fail\n");
		socket_close($connection);
			break;
		}
		}
		//}    	//schleife ende 
		
	
	}
}


?>