<?php

class tcp_query_connection {
    private $con = false;
    private $created = 0;
    private $loginStarted = 0;
    private $lastcommand = false;
    private $status = "loggedout";
    private $user = false;
    private $ip;
    private $port;
    private $buffer = "";
    private $mod = false;
    private $logging = false;
    private $group = false;
    private $players = array();
    public $closed = false;
    public $dummyplayer;
    private $sent = 0;
    private $received = 0;
    private $isResult = false;
	public	$rank = false;


    public function __construct($socket) {
        $this->mod     =& $GLOBALS["mod"];
        $this->logging =& $GLOBALS["logging"];
        $this->players =& $GLOBALS["players"];

        $this->con = $socket;
        $this->created = time();
        $this->loginStarted = time();
        socket_getpeername($this->con, $this->ip, $this->port);

        $this->logging->write(MOD_NOTICE, "TCP-Query: New connection from $this->ip on port $this->port");

        $this->welcome();
        $this->getUserName();
    }

    public function __destruct() {
        if (is_resource($this->con)) {
            $this->close();
        }
    }

    private function welcome() {
        $timeout = $this->mod->getCV("tcp_query", "logintimeout");
        $msg  = "Welcome to Manu-Admin-Mod TCP-Interface\n";
        $msg .= "Your IP is $this->ip and will be logged for security reasons\n";
        $msg .= "You have $timeout seconds to authentificate...\n";
        $this->write($msg);
    }

    private function read() {
        $read = @socket_read($this->con, 9999, PHP_BINARY_READ);

        $this->received += strlen($read);
                                                                          //WIN  , LINUX, FreeBSD
        if ($read === '' || !in_array(@socket_last_error($this->con), array(10035, 11,    35))) {
            $this->close();
            return;
        }

        $this->buffer .= $read;

        if (strpos($this->buffer, "\n") !== false) {
            $parts = explode("\n", $this->buffer, 2);
            $cmd = trim($parts[0]);
            if (!empty($cmd)) {
                $this->input($cmd);
            }
            $this->buffer = "";
        }
    }

    public function write($msg, $type = MT_CONSOLE)  {


        $isCmd = ($this->isResult) ? chr(1) : chr(0);
        $msg =  chr($type) . $isCmd . $msg;

		//$msg = str_replace("\n", "\r\n", $msg);

        @socket_write($this->con, $msg, strlen($msg));
        $this->sent += strlen($msg);
    }

    public function everyTime() {
        $this->read();

        $timeout = $this->mod->getCV("tcp_query", "logintimeout");
        if ($this->status == "loggedout" && time() - $this->loginStarted > $timeout) {
            $this->write("Your $timeout seconds are over, please try again\n");
            $this->close();
        }

    }

    private function close() {
        if ($this->closed)return;
        $this->write("Bye, see you later :D\n");
        $this->closed = true;
        if ($this->status == "loggedout") {
            $this->user = "NOBODY";
        }
        else {
            $this->status = "loggedout";
            $this->mod->rconSay("TCP-Admin ($this->user) has disconnected");
        }
        $this->logging->write(MOD_NOTICE, "TCP-Query: Connection closed: $this->user ($this->ip:$this->port)");
        socket_close($this->con);
    }

    private function input($input) {
        if ($this->status == "loggedout") {
            if ($this->user == false) {
                $this->user = $input;
                $this->getPassword();
            }
            else {
                if ($this->login($this->user, $input)) {
                    $this->write("You have been successfully logged in as $this->user\nHave fun :D\n");
                }
                else {
                    $this->write("Login failed, please try again...\n");
                    $this->user = false;
                    $this->getUserName();
                }
            }
        }
        else {
            $this->isResult = true;
            //quit command
            if (strtolower($input) == "quit" || strtolower($input) == "exit") {
                $this->close();
            }
            //logout command
            elseif (strtolower($input) == "logout") {
                $this->logout();
            }
            elseif (strtolower($input) == "info") {
                $this->connectionInfo();
            }
            //admin commands
            elseif (strtolower($input) == "lc" && in_array($this->group, explode(",", $this->mod->getCV("tcp_query", "admingroups")))) {
                $connections = $GLOBALS['tcp_query']->getConnections();
                $msg = "";
                foreach ($connections as $connection) {
                    $msg .= str_pad($connection["id"], 3, " ", STR_PAD_LEFT) . ": ";
                    $msg .= str_pad($connection["ip"] . ":" . $connection["port"], 21, " ", STR_PAD_RIGHT) . " ";
                    $msg .= $connection["user"] . "\n";
                }
                $this->write($msg);
            }
            //kick command
            elseif (substr(strtolower($input), 0, 5) == "kick " && in_array($this->group, explode(",", $this->mod->getCV("tcp_query", "admingroups")))) {
                $id = explode(" ", $input);
                $this->logging->write(MOD_NOTICE, "User '$this->user' used command kick");
                if ($GLOBALS['tcp_query']->kick($id[1])) {
                    $this->write("User has been kicked\n");
                }
                else {
                    $this->write("Error...\n");
                }
            }
            //getinfo command
            elseif (preg_match('|^getinfo([^\w].*)?$|', $input)) {
                if (strlen($input) <= 8) {
                     $this->write("Possible: players, maps");
                }
                else {
                    switch (substr($input, 8)) {
                        case "players":
                            $this->writePlayers();
                            break;
                        case "maps":
                            $this->writeMaps();
                            break;
                        default:
                            $this->write("error");
                    }
                }
            }
            elseif (substr(strtolower($input), 0, 5) == "rcon " && $this->dummyplayer->isAllowedToExec("rcon")) {
                $rcon = substr($input, 5);
                $return = $this->mod->rconRcon($rcon);
                $this->write($return);
            }
            //normal commands
            else {
                if ($input{0} == $this->mod->getCV("main", "prefix")) {
                    $this->players["TCPUSER"] =& $this->dummyplayer;
                    $this->mod->executeCommand($input, "TCPUSER", $executed);
                    if (!$executed && !$this->mod->getCV("main", "responsefailcmds")) {
                        $this->write("Unrecognized command: " . $input . "\n");
                    }
                    unset($this->players["TCPUSER"]);

                }
                else {
                    if ($this->mod->getCV("tcp_query", "defaulaction") == "say") {
                        $msg = str_replace("<ADMIN>", $this->user, $this->mod->getCV("tcp_query", "sayprefix")) . $input;
                        $this->logging->write(MOD_NOTICE, "TCP-Query: User '$this->user' says: '$input' ($this->ip:$this->port)");
                        $this->mod->rconSay($msg);
                    }
                    elseif($this->mod->getCV("tcp_query", "defaulaction") == "rcon") {
                        $return = $this->mod->rconRcon($input);
                        $this->logging->write(MOD_NOTICE, "TCP-Query: User '$this->user' executed RCON command: '$input' ($this->ip:$this->port)");
                        $this->write($return);
                    }
                }
            }
            $this->isResult = false;
        }
    }

    private function getUserName() {
        $this->write("User: \n");
    }

    private function getPassword() {
        $this->write("Password: \n");
    }

    private function login($user, $password) {
        if ($GLOBALS['tcp_query']->isValidLogin($user, $password, $group, $rank)) {
            $this->group = $group;  //Is changed by function isValidLogin
            $this->user = $user;    //Is changed by function isValidLogin
			$this->rank = $rank;
            $this->status = "loggedin";
            $this->logging->write(MOD_NOTICE, "TCP-Query: User logged in: $this->user ($this->ip:$this->port)");
            $this->mod->rconSay("TCP-Admin ($this->user) has connected");
            $this->dummyplayer = new tcp_query_playerDummy($this->user, $this->group, $this->rank, $this);
            return true;
        }
        return false;
    }

    private function logout() {
        $this->loginStarted = time();
        $this->status = "loggedout";;
        $this->write("You have been successfully logged out!\n\n");
        $this->logging->write(MOD_NOTICE, "TCP-Query: User logged out: $this->user ($this->ip:$this->port)");
        $this->mod->rconSay("TCP-Admin ($this->user) has disconnected");
        $this->user = false;
        $this->group = "";
        $this->welcome();
        $this->getUserName();
    }

    public function loggedin() {
        if ($this->status == "loggedin") return true;
        return false;
    }

    public function getIP() {
        return $this->ip;
    }

    public function getPort() {
        return $this->port;
    }

    public function getUser() {
        if ($this->loggedin()) return $this->user;
        return "NOT LOGGED IN";
    }

    public function kick() {
        $this->write("You have been kicked by Admin\n");
        $this->logging->write(MOD_NOTICE, "TCP-Query: Connection of '" . $this->getUser() . "' ($this->ip:$this->port) got kicked by admin");
        $this->close();
    }

    private function connectionInfo() {
        $ip = $this->getIP();
        $port = $this->getPort();
        $user = $this->getUser();
        $group = $this->dummyplayer->getGroup()->getLongName();
        $time = makeuptime2(time() - $this->created);

        $text  = "Connection info:\n================\n";
        $text .= "Username:        $user ($group)\n";
        $text .= "Address:         $ip:$port\n";
        $text .= "Connection time: $time\n";
        $text .= "Bytes read:      ".size($this->received)."\n";
        $text .= "Bytes sent:      ".size($this->sent)."\n";


        $this->write($text);
    }

    private function writeMaps() {
        $str = "Game: ".$this->mod->getGame() . "\n";
        $lastmaps = $this->mod->getLastMaps(1);
        $str .= "Current: " . $this->mod->getLongMapName($lastmaps[0]);
        $str .= " (".$this->mod->getLongGametype($this->mod->getCurrentGametype()).")\n";
        $maps = $this->mod->getMaps();
        sort($maps);
        foreach ($maps as $short) {
            $str .= "$short\t";
            $str .= $this->mod->getLongMapName($short) . "\n";
        }
        $str = trim($str);

        $this->write($str);
    }

    private function writePlayers() {
        $str = "";
        foreach (array_keys($this->players) as $guid) {
            $str .= $this->players[$guid]->getPID();
            $str .= "\t" . $this->players[$guid]->getName();
            $str .= "\t";
            $str .= $this->players[$guid]->getGroup()->getLongName();
            $str .= "\t$guid\t0\n";
        }
        $this->write(trim($str));
    }
}

?>