<?php

    private function readUserDB() {
        $this->userDB = array();
        $db = file($this->mod->getConfigDir() . "/plugins/tcp_user.db");
        if ($db === false) {
            $this->logging->write(MOD_ERROR, "TCP-Query: Could not open user database (" . $this->mod->getConfigDir() . "/plugins/tcp_user.db)");
            return;
        }
        foreach ($db as $lineno => $line) {
            //Comments
            $line = preg_replace('|;.*|', "", trim($line));

            if (empty($line)) {
                continue;
            }
            elseif (!preg_match('|^([a-z0-9_]+):([a-z0-9_]+):([a-f0-9]{40}+):([0-9_])$|i', $line, $subpatterns)) {
                $this->logging->write(MOD_WARNING, "TCP-Query: Error: Syntax error in tcp_user.db on line " . ($lineno + 1));
            }
            else {
                list ($dummy, $user, $group, $pw, $rank) = $subpatterns;
                $group = strtolower($group);
                $pw = strtolower($pw);
                if (!group::exists($group)) {
                    $this->logging->write(MOD_WARNING, "TCP-Query: Error: Group '$group' does not exist in tcp_user.db on line " . ($lineno + 1));
                    continue;
                }
                if (array_i_key_exists($user, $this->userDB)) {
                    $this->logging->write(MOD_WARNING, "TCP-Query: Error: User '$user' already exists in tcp_user.db on line " . ($lineno + 1));
                    continue;
                }
				if (!$rank) {
                    $this->logging->write(MOD_WARNING, "TCP-Query: Error: User '$user$ has no rank(set rank to '0') on line " . ($lineno + 1));
					$rank = "0";
                    continue;
                }
                $this->userDB[$user] = array("group"=>$group, "password" =>$pw, "rank"=>$rank);
            }
        }

    }

    public function isValidLogin(&$user, $password, &$group, &$rank) {
        $user = strtolower($user);
        //if (!array_key_exists($user, $this->userDB)) return false;

        foreach ($this->userDB as $username => $userdata) {
            if (strtolower($username) == strtolower($user)) {
                if ($userdata["password"] == sha1($password)) {
                    $user = $username;
                    $group = $this->userDB[$user]["group"];
					$rank  = $this->userDB[$user]["rank"];
                    return true;
                }
                else {
                    return false;
                }
            }
        }

        return false;
    }

    public function eventRconSay($msg) {
        if (!$this->enabled) return;

        $this->writeAll($msg, MT_RCONSAY);
    }

    public function eventLogAction($line) {
        if (!$this->enabled) return;

        if ($line["action"] == "say" || $line["action"] == "sayteam") {
            $parts = $line["parsed"];
            $this->writeAll($parts[2] . ": " . $parts[3] . "\n", MT_CHAT);
        }
        return;
    }

    public function eventNextMap($dvars) {
        if (!$this->enabled) return;

        $this->writeAll("Next map / map restart: " . $this->mod->getLongMapName($dvars["mapname"]) . " (" . $this->mod->getLongGameType($dvars["g_gametype"]). ")\n");
    }

    private function writeAll($msg, $type = MT_CONSOLE) {
        foreach (array_keys($this->connections) as $connection) {
            if (!$this->connections[$connection]->loggedin()) continue;
            $this->connections[$connection]->write($msg, $type);
        }
    }

    public function kick($id) {
        if (!$this->enabled) return;

        if (array_key_exists($id, $this->connections)) {
            $this->connections[$id]->kick();
            return true;
        }
        return false;
    }

    public function getConnections() {
        if (!$this->enabled) return false;

        $return = array();
        foreach (array_keys($this->connections) as $connection) {
            $return[$connection] = array(
                "id" => $connection,
                "ip" => $this->connections[$connection]->getIP(),
                "port" => $this->connections[$connection]->getPort(),
                "user" => $this->connections[$connection]->getUser(),

            );
        }
        return $return;
    }

    public function eventJoin($guid) {
        if (!$this->enabled) return;
        $name = $this->players[$guid]->getName();

        $this->writeAll("Player joined: '$name'\n", MT_INFO);
    }

    public function eventQuit($guid) {
        if (!$this->enabled) return;
        $name = $this->players[$guid]->getName();

        $this->writeAll("Player quit: '$name'\n", MT_INFO);
    }

?>