<?php

$mod->setDefaultCV("randommapcycle", "enabled", 0);
//$mod->setDefaultCV("randommapcycle", "maps", $mod->getMaps(","));
//$mod->setDefaultCV("randommapcycle", "gametypes", $mod->getCurrentGametype());
$mod->setDefaultCV("randommapcycle", "notlastmaps", 3);
$mod->setDefaultCV("randommapcycle", "notlastgt", 1);



$randommapcycle = new randommapcycle();

$mod->registerEvent("nextMap", "eventNextMap", $randommapcycle);
$mod->registerCommand("shufflemap", false, "commandShuffleMap", $randommapcycle);
$mod->registerCommand("shufflenextmap", false, "commandShuffleNextMap", $randommapcycle);



class randommapcycle {
    private $mod;
    private $logging;
    private $players;

    private $lastmaps = array();

    public function __construct() {
        $this->mod = $GLOBALS['mod'];
        $this->logging = $GLOBALS['logging'];
        $this->players = $GLOBALS['players'];
    }

    public function eventNextMap() {
    	$lastmaps = $this->mod->getLastMaps(2);

    	if ($lastmaps[1] == $lastmaps[0]) return;

		$this->lastmaps[] = $lastmaps[0];

    	if (!$this->mod->getCV("randommapcycle", "enabled")) {
    		return false;
    	}

        $this->setRandomMap();
    }

    private function setRandomMap(&$randommap = null, &$randomgt = null) {
		if ($this->mod->getCV("randommapcycle", "notlastmaps") < 1) {
        	$logging->write(MOD_WARNING, "Randommapcycle: ConfigVar [randommapcycle]notlastmaps must be greater than 0, randommapcycle will be disabled");
        	return false;
        }

        while (count($this->lastmaps) > $this->mod->getCV("randommapcycle", "notlastmaps")) {
			array_shift($this->lastmaps);
		}

		$maps = $this->mod->getMapsArray("randommapcycle_filter");

		foreach ($maps as $key => $value) {
			if (in_array($value["cname"], $this->lastmaps)) {
				unset($maps[$key]);
			}
		}

		if (empty($maps)) {
			$this->logging->write(MOD_WARNING, "Randommapcycle: Can't choose a random map because count(\$maps) = 0");
			return false;
		}

		$maps = array_values($maps);

		$randommap = $maps[rand(0, count($maps) - 1)];
		$gametypes = $randommap["usegametypes"];


		if ($this->mod->getCV("randommapcycle", "notlastgt")) {
			foreach ($gametypes as $key => $value) {
				if ($value == $this->mod->getCurrentGametype()) {
					unset($gametypes[$key]);
				}
			}

			$gametypes = array_merge($gametypes);
		}

		if (empty($gametypes)) {
			//$logging->write(MOD_WARNING, "Randommapcycle: Can't choose a gametype because count(\$gametypes) = 0, choosing current: ".$mod->getCurrentGametype());
			$gametypes[] = $this->mod->getCurrentGametype();
		}

		$randomgt = $gametypes[rand(0, count($gametypes) - 1)];

		$this->logging->write(MOD_NOTICE, "Randommapcycle: Setting nextmap to $randommap[cname] ($randomgt)");
		$this->mod->rconSetNextMap($randommap["cname"], $randomgt, false);
    }

    public function commandShuffleMap($guid) {
        $this->setRandomMap();
        $this->mod->rconMapRotate();
    }

    public function commandShuffleNextMap($guid) {
        $this->setRandomMap($map, $gametype);
        $this->mod->rconSay($this->mod->getLngString("nextMapShuffled", array("<MAP>", "<GAMETYPE>"), array($map["longname"], $this->mod->getLongGametype($gametype))));
    }


}


/*
randommapcycle_set();

function randommapcycle_set() {
	global $mod;
	global $logging;
	global $randommapcycle_maps;

	if (!$mod->getCV("randommapcycle", "enabled")) {
		return false;
	}

	if ($mod->getCV("randommapcycle", "notlastmaps") < 1) {
		$logging->write(MOD_WARNING, "Randommapcycle: ConfigVar [randommapcycle]notlastmaps must be greater than 0, randommapcycle will be disabled");
		return false;
	}

	$lastmaps = $mod->getLastMaps(2);
	//$maps = explode(",", $mod->getCV("randommapcycle", "maps"));
	//$gametypes = explode(",", $mod->getCV("randommapcycle", "gametypes"));

	if ($lastmaps[1] != $lastmaps[0]) {
		$randommapcycle_maps[] = $lastmaps[0];
		while (count($randommapcycle_maps) > $mod->getCV("randommapcycle", "notlastmaps")) {
			array_shift($randommapcycle_maps);
		}

		$maps = $mod->getMapsArray("randommapcycle_filter");

		foreach ($maps as $key => $value) {
			if (in_array($value["cname"], $randommapcycle_maps)) {
				unset($maps[$key]);
			}
		}

		if (empty($maps)) {
			$logging->write(MOD_WARNING, "Randommapcycle: Can't choose a random map because count(\$maps) = 0");
			return false;
		}

		$maps = array_values($maps);

		$randommap = $maps[rand(0, count($maps) - 1)];
		$gametypes = $randommap["usegametypes"];


		if ($mod->getCV("randommapcycle", "notlastgt")) {
			foreach ($gametypes as $key => $value) {
				if ($value == $mod->getCurrentGametype()) {
					unset($gametypes[$key]);
				}
			}

			$gametypes = array_merge($gametypes);
		}

		if (empty($gametypes)) {
			//$logging->write(MOD_WARNING, "Randommapcycle: Can't choose a gametype because count(\$gametypes) = 0, choosing current: ".$mod->getCurrentGametype());
			$gametypes[] = $mod->getCurrentGametype();
		}

		$randomgt = $gametypes[rand(0, count($gametypes) - 1)];

		$logging->write(MOD_NOTICE, "Randommapcycle: Setting nextmap to $randommap[cname] ($randomgt)");
		$mod->rconSetNextMap($randommap["cname"], $randomgt, false);
	}

	return true;

}

*/

function randommapcycle_filter($map) {
    return $map["randommapcycle"] == 1;
}

?>