<?php

/*
PLUGIN: Nameprotection
================
Kicks players with a forbidden name or an admins name


CONFIG:
-------
[nameprotection]
enabled = 1                         ;Enable plugin
badnamekick = 1                     ;Enable kick for badnames defined
                                    ;in badnames.lst
badnamekickmode = "tempban"         ;kick/ban/tempban
badnamekickreason = "Your name contains an illegal part: <PART>" ;kickreason
adminnamekick = 1                   ;enable kick when someone uses an admins name
adminnamekickmode = "tempban"       ;kick/ban/tempban
adminnamekickreason = "Your name is an admins name" ;kickreason

NAMESPACE: nameprotection

Functions:
    nameprotection_main
    nameprotection_read

Variables:
   $nameprotection_list

*/

$mod->setDefaultCV("nameprotection", "enabled", 0);
$mod->setDefaultCV("nameprotection", "badnamekick", 0);
$mod->setDefaultCV("nameprotection", "badnamekickmode", "tempban");
$mod->setDefaultCV("nameprotection", "badnamekickreason", "Your name contains an illegal part: <PART>");
$mod->setDefaultCV("nameprotection", "adminnamekick", 0);
$mod->setDefaultCV("nameprotection", "adminnamekickmode", "tempban");
$mod->setDefaultCV("nameprotection", "adminnamekickreason", "Your name is an admins name");
$mod->setDefaultCV("nameprotection", "maxnamechanges", 0);
$mod->setDefaultCV("nameprotection", "maxnamechangeskickmode", "tempban");
$mod->setDefaultCV("nameprotection", "maxnamechangeskickmode", "You have changed your name too often");
$mod->setDefaultCV("nameprotection", "uppercasedisallow", 0);
$mod->setDefaultCV("nameprotection", "uppercasekickreason", "Please do not use only upper case letters in your nickname");
$mod->setDefaultCV("nameprotection", "uppercasekickmode", "kick");


$mod->registerEvent("playerJoined", "nameprotection_main");
$mod->registerEvent("playerNameChange", "nameprotection_main");
$mod->registerEvent("parseConfig", "nameprotection_read");

//Check Players because playerJoined isn't called at startup
array_map("nameprotection_main", array_keys($players));

//Read the list
nameprotection_read();

function nameprotection_main($parameters) {

    global $mod;
    global $players;
    global $nameprotection_list;

    if (!$mod->getCV("nameprotection", "enabled")) return;

    if (is_array($parameters)) {
        $guid = $parameters[0];
    }
    else {
        $guid = $parameters;
    }

    if ($players[$guid]->isProtected("n,M")) return;

    $name = $players[$guid]->getName();

    if ($mod->getCV("nameprotection", "adminnamekick")) {
        $owner = admin::getNameOwner($name);
        if ($owner != $guid && $owner !== false) {
            switch ($mod->getCV("nameprotection", "adminnamekickmode")) {
                case "tempban":
                    $players[$guid]->tempBan($mod->getCV("nameprotection", "adminnamekickreason"));
                    break;
                case "kick":
                    $players[$guid]->kick($mod->getCV("nameprotection", "adminnamekickreason"));
                    break;
                case "ban":
                    $players[$guid]->ban($mod->getCV("nameprotection", "adminnamekickreason"));
                    break;
            }
            return;
        }
    }

    $kick = false;
    if ($mod->getCV("nameprotection", "badnamekick") && $nameprotection_list != false) {
        foreach ($nameprotection_list["normal"] as $value) {
            if (stripos($name, $value) !== false) {
                $part = $value;
                $kick = true;
                break;
            }
        }
        if (!$kick) {
            foreach ($nameprotection_list["regexp"] as $value){
    			if (preg_match("".str_replace("", "\\xB4", $value)."i", $name, $subpatterns)) {
    			    $part = $subpatterns[0];
    				$kick = true;
    				break;
    			}
            }
        }
        if ($kick) {
            switch ($mod->getCV("nameprotection", "badnamekickmode")) {
                case "tempban":
                    $players[$guid]->tempBan(str_replace("<PART>", $part, $mod->getCV("nameprotection", "badnamekickreason")));
                    break;
                case "kick":
                    $players[$guid]->kick(str_replace("<PART>", $part, $mod->getCV("nameprotection", "badnamekickreason")));
                    break;
                case "ban":
                    $players[$guid]->ban(str_replace("<PART>", $part, $mod->getCV("nameprotection", "badnamekickreason")));
                    break;
            }
            return;
        }
    }

    if ($mod->getCV("nameprotection", "maxnamechanges") > 0) {
        if (!isset($players[$guid]->nameprotection_nameChanges)) {
            $players[$guid]->nameprotection_nameChanges = 0;
        }
        else {
            $players[$guid]->nameprotection_nameChanges ++;
        }

        if ($players[$guid]->nameprotection_nameChanges > $mod->getCV("nameprotection", "maxnamechanges")) {
            switch ($mod->getCV("nameprotection", "maxnamechangeskickmode")) {
                case "tempban":
                    $players[$guid]->tempBan($mod->getCV("nameprotection", "maxnamechangeskickreason"));
                    break;
                case "kick":
                    $players[$guid]->kick($mod->getCV("nameprotection", "maxnamechangeskickreason"));
                    break;
                case "ban":
                    $players[$guid]->ban($mod->getCV("nameprotection", "maxnamechangeskickreason"));
                    break;
            }
            return;
        }
    }

    if ($mod->getCV("nameprotection", "uppercasedisallow")) {
        if (preg_match('|^[^a-z0-9]+$|', $name)) {
            switch ($mod->getCV("nameprotection", "uppercasekickmode")) {
                case "tempban":
                    $players[$guid]->tempBan($mod->getCV("nameprotection", "uppercasekickreason"));
                    break;
                case "kick":
                    $players[$guid]->kick($mod->getCV("nameprotection", "uppercasekickreason"));
                    break;
                case "ban":
                    $players[$guid]->ban($mod->getCV("nameprotection", "uppercasekickreason"));
                    break;
            }
            return;
        }
    }
}

function nameprotection_read() {
    global $mod;
    global $nameprotection_list;

    if (!$mod->getCV("nameprotection", "enabled") || !$mod->getCV("nameprotection", "badnamekick")) {
        return;
    }

    $file = file($mod->getConfigDir() . "/plugins/badnames.lst");

    if ($file === false) {
        $GLOBALS['logging']->write(MOD_WARNING, "Nameprotection: File $configdir/plugins/badnames.lst could not be opened, badnames part will be disabled");
        $nameprotection_list = false;
        return false;
    }

    $normal = array();
    $regexp = array();

    foreach ($file as $value) {
        $value = trim($value);
        if (stripos($value, "regexp:") === 0) {
            $regexp[] = substr($value, 7);
        }
        else {
            $normal[] = $value;
        }
    }

    $nameprotection_list = array("normal" => $normal, "regexp" => $regexp);

    return;
}

?>