<?php

/*
PLUGIN: Spreemessages
=====================
Shows spreemessages in the local chat (like UT3)

CONFIG:
-------
[spreemessages_config]
enabled = 1                       ;Enable plugin
firstblood = 1                    ;Enable firstblood
killsprees = 1                    ;Enable Killingspree, Rampage, Domination...
deathsprees = 1                   ;Enable Ass kicked, Victim of the day...
spreeends = 1                      ;Enable announce that someones spree was ended
spreeendsfrom = 10                ;Show spreend when the spree is from X kills
multikills = 1                    ;Enable Multikill and Monsterkill

;Text for the spreemessages
[spreemessages_messages]
firstblood = "^7<PLAYER_NAME> ^1drew first blood!"

5  = "^7<PLAYER_NAME> ^1is on a ^3killing spree! ^1(^2<KILLS> ^1kills in a row)"
10 = "^7<PLAYER_NAME> ^1is on a ^3rampage! ^1(^2<KILLS> ^1kills in a row)"
15 = "^7<PLAYER_NAME> ^1is ^3dominating! ^1(^2<KILLS> ^1kills in a row)"
20 = "^7<PLAYER_NAME> ^1is ^3unstoppable! ^1(^2<KILLS> ^1kills in a row)"
25 = "^7<PLAYER_NAME> ^1is ^3godlike!! ^1(^2<KILLS> ^1kills in a row)"
30 = "^7<PLAYER_NAME> ^1is ^3wicked sick!!! ^1(^2<KILLS> ^1kills in a row)"
35 = "^7<PLAYER_NAME> ^1is ^3real Potter!!! ^1(Woohoo, ^2<KILLS> ^1kills in a row!)"

-10 = "^7<PLAYER_NAME> ^1seems to have a bad day ... (^2<DEATHS>^1 deaths without a ^2kill^1)"
-15 = "^7<PLAYER_NAME> ^1is on the best way to get ^3victim^1 of the day... (^2<DEATHS> ^1deaths w/o ^2kill^1)"
-20 = "^7<PLAYER_NAME> ^1really gets his ^3ass kicked!^1 Oh well, ^2<DEATHS> ^1deaths without a ^2kill^1..."

multikill = "^7!! ^1Multikill ^7> ^2<PLAYER_NAME>^7 < ^1Multikill^7 !!"
monsterkill = "^7!!!! ^1MONSTERKILL ^7>>> ^2<PLAYER_NAME>^7 <<< ^1MONSTER KILL ^7!!!!"

end_kill     = "^2<PLAYER_NAME>^1's killing spree ended (^2<KILLS> ^1kills). He was killed 8by ^3<KILLER_NAME>^1!"
end_teamkill = "^2<PLAYER_NAME>^1's killing spree ended (^2<KILLS> ^1kills). He was killed by TEAMMATE ^3<KILLER_NAME>^1!"
end_selfkill = "^2<PLAYER_NAME>^1's killing spree ended (^2<KILLS> ^1kills). He killed ^3himself^1, what a pity!"


NAMESPACE: spreemessages

Classes:
    spreemessages

Vars:
    $spreemessages
*/
$spreemessages = new spreemessages();

$mod->registerEvent("playerKill", "triggerKill", $spreemessages);
$mod->registerEvent("playerTeamKill", "triggerTeamKill", $spreemessages);
$mod->registerEvent("playerSelfKill", "triggerSelfKill", $spreemessages);
$mod->registerEvent("nextMap", "triggerNextMap", $spreemessages);

$mod->setDefaultCV("spreemessages_config", "enabled", 0);
$mod->setDefaultCV("spreemessages_config", "firstblood", 0);
$mod->setDefaultCV("spreemessages_config", "killsprees", 0);
$mod->setDefaultCV("spreemessages_config", "deathsprees", 0);
$mod->setDefaultCV("spreemessages_config", "spreeends", 0);
$mod->setDefaultCV("spreemessages_config", "multikills", 0);

$mod->setDefaultCV("spreemessages_messages", "firstblood", "^7<PLAYER_NAME> ^1drew first blood!");
$mod->setDefaultCV("spreemessages_messages", "5", "^7<PLAYER_NAME> ^1is on a ^3killing spree! ^1(^2<KILLS> ^1kills in a row)");
$mod->setDefaultCV("spreemessages_messages", "10", "^7<PLAYER_NAME> ^1is on a ^3rampage! ^1(^2<KILLS> ^1kills in a row)");
$mod->setDefaultCV("spreemessages_messages", "15", "^7<PLAYER_NAME> ^1is ^3dominating! ^1(^2<KILLS> ^1kills in a row)");
$mod->setDefaultCV("spreemessages_messages", "20", "^7<PLAYER_NAME> ^1is ^3unstoppable! ^1(^2<KILLS> ^1kills in a row)");
$mod->setDefaultCV("spreemessages_messages", "25", "^7<PLAYER_NAME> ^1is ^3godlike!! ^1(^2<KILLS> ^1kills in a row)");
$mod->setDefaultCV("spreemessages_messages", "30", "^7<PLAYER_NAME> ^1is ^3wicked sick!!! ^1(^2<KILLS> ^1kills in a row)");
$mod->setDefaultCV("spreemessages_messages", "35", "^7<PLAYER_NAME> ^1is ^3real Potter!!! ^1(Woohoo, ^2<KILLS> ^1kills in a row!)");
$mod->setDefaultCV("spreemessages_messages", "-10", "^7<PLAYER_NAME> ^1seems to have a bad day ... (^2<DEATHS>^1 deaths without a ^2kill^1)");
$mod->setDefaultCV("spreemessages_messages", "-15", "^7<PLAYER_NAME> ^1is on the best way to get ^3victim^1 of the day... (^2<DEATHS> ^1deaths w/o ^2kill^1)");
$mod->setDefaultCV("spreemessages_messages", "-20", "^7<PLAYER_NAME> ^1really gets his ^3ass kicked!^1 Oh well, ^2<DEATHS> ^1deaths without a ^2kill^1...");
$mod->setDefaultCV("spreemessages_messages", "multikill", "^7!! ^1Multikill ^7> ^2<PLAYER_NAME>^7 < ^1Multikill^7 !!");
$mod->setDefaultCV("spreemessages_messages", "monsterkill", "^7!!!! ^1MONSTERKILL ^7>>> ^2<PLAYER_NAME>^7 <<< ^1MONSTER KILL ^7!!!!");
$mod->setDefaultCV("spreemessages_messages", "end_kill", "^2<PLAYER_NAME>^1's killing spree ended (^2<KILLS> ^1kills). He was killed 8by ^3<KILLER_NAME>^1!");
$mod->setDefaultCV("spreemessages_messages", "end_teamkill", "^2<PLAYER_NAME>^1's killing spree ended (^2<KILLS> ^1kills). He was killed by TEAMMATE ^3<KILLER_NAME>^1!");
$mod->setDefaultCV("spreemessages_messages", "end_selfkill", "^2<PLAYER_NAME>^1's killing spree ended (^2<KILLS> ^1kills). He killed ^3himself^1, what a pity!");

//Init Players
$mod->registerEvent("playerJoined", "playerInit", $spreemessages);
foreach (array_keys($players) as $guid) {
    $spreemessages->playerInit($guid);
}

class spreemessages {
    private $players;
    private $mod;
    private $firstblood = false;

    public function __construct() {
        $this->players = &$GLOBALS["players"];
        $this->mod = &$GLOBALS["mod"];
    }

    public function triggerKill($parameters) {
        list($killer, $victim, $weapon, $damage, $bodypart) = $parameters;

        if (!$this->mod->getCV("spreemessages_config", "enabled")) {
            return;
        }

        //Firstblood
        $this->firstblood($killer);

        //Killsprees
        $this->players[$killer]->spreemessages_killspree ++;
        $this->killSpree($killer, $this->players[$killer]->spreemessages_killspree);

        //Spreeend
        $this->spreeEnd($victim, $killer, $this->players[$victim]->spreemessages_killspree, "kill");
        $this->players[$victim]->spreemessages_killspree = 0;

        //Deathsspree
        $this->players[$killer]->spreemessages_deathspree = 0;
        $this->players[$victim]->spreemessages_deathspree ++;
        $this->deathSpree($victim, $this->players[$victim]->spreemessages_deathspree);

        //Multikills
        if (time () - $this->players[$killer]->spreemessages_lastkill < 3) {
            $this->players[$killer]->spreemessages_multikills ++;
            $this->multiKill($killer, $this->players[$killer]->spreemessages_multikills);
        }
        else {
            $this->players[$killer]->spreemessages_multikills = 1;
        }
        $this->players[$killer]->spreemessages_lastkill = time();


    }

    public function triggerTeamKill($parameters) {
        list($killer, $victim, $weapon, $damage, $bodypart) = $parameters;

        if (!$this->mod->getCV("spreemessages_config", "enabled")) {
            return;
        }

        //Spreeend
        $this->spreeEnd($victim, $killer, $this->players[$victim]->spreemessages_killspree, "teamkill");
        $this->players[$victim]->spreemessages_killspree = 0;

        //Deathsspree
        $this->players[$victim]->spreemessages_deathspree ++;
        $this->deathSpree($victim, $this->players[$victim]->spreemessages_deathspree);

    }

    public function triggerSelfKill($parameters) {
        list($killer, $weapon, $damage, $bodypart) = $parameters;

        if (!$this->mod->getCV("spreemessages_config", "enabled")) {
            return;
        }

        //Spreeend
        $this->spreeEnd($killer, $killer, $this->players[$killer]->spreemessages_killspree, "selfkill");
        $this->players[$killer]->spreemessages_killspree = 0;

        //Deathsspree
        $this->players[$killer]->spreemessages_deathspree ++;
        $this->deathSpree($killer, $this->players[$killer]->spreemessages_deathspree);

    }

    public function triggerNextMap() {
        $this->firstblood = false;
        foreach (array_keys($this->players) as $guid) {
            $this->players[$guid]->spreemessages_killspree = 0;
            $this->players[$guid]->spreemessages_deathspree = 0;
            $this->players[$guid]->spreemessages_multikills = 0;
            $this->players[$guid]->spreemessages_lastkill = 0;
        }
    }

    private function spreemessage($message, $player, $kills = 0, $deaths = 0, $killer = false) {
        $text = $this->mod->getCV("spreemessages_messages", $message);
        $search = array(
            "<PLAYER_NAME>",
            "<KILLS>",
            "<DEATHS>",
            "<KILLER_NAME>"
        );
        $replace = array (
            $this->players[$player]->getName(),
            $kills,
            $deaths,
            ($killer) ? $this->players[$killer]->getName() : "",
        );
        $this->mod->rconSay(str_replace($search, $replace, $text));
    }

    private function firstblood($killer) {
        if ($this->mod->getCV("spreemessages_config", "firstblood") && !$this->firstblood) {
            $this->spreemessage("firstblood", $killer);
        }
        $this->firstblood = true;
    }

    private function killSpree($killer, $kills) {
        if (!$this->mod->getCV("spreemessages_config", "killsprees")) return;

        if ($this->mod->existsCV("spreemessages_messages", $kills)) {
            $this->spreemessage("$kills", $killer, $kills);
        }
    }

    private function deathSpree($victim, $deaths) {
        if (!$this->mod->getCV("spreemessages_config", "deathsprees")) return;

        if ($this->mod->existsCV("spreemessages_messages", "-$deaths")) {
            $this->spreemessage("-$deaths", $victim, 0, $deaths);
        }
    }

    private function spreeEnd($victim, $killer, $kills, $type) {
        if (!$this->mod->getCV("spreemessages_config", "spreeends") || $kills < $this->mod->getCV("spreemessages_config", "spreeendsfrom")) return;

        $this->spreemessage("end_$type", $victim, $kills, 0, $killer);
    }

    private function multiKill($killer, $kills) {
        if (!$this->mod->getCV("spreemessages_config", "multikills")) return;

        if ($kills == 3) {
            $this->spreemessage("multikill", $killer, $kills);
        }
        elseif ($kills == 5) {
            $this->spreemessage("monsterkill", $killer, $kills);
        }
    }

    public function playerInit($guid) {
        $this->players[$guid]->spreemessages_killspree = 0;
        $this->players[$guid]->spreemessages_deathspree = 0;
        $this->players[$guid]->spreemessages_multikills = 0;
        $this->players[$guid]->spreemessages_lastkill = 0;
    }

}


?>