<?php

$killannounces = new killannounces();

$mod->registerEvent("playerKill", "eventKill", $killannounces);
$mod->registerEvent("playerTeamKill", "eventTeamKill", $killannounces);
$mod->registerEvent("playerSelfKill", "eventSelfKill", $killannounces);
$mod->registerEvent("parseConfig", "eventParseConfig", $killannounces);

$mod->setDefaultCV("killannounces", "enabled", 0);

class killannounces {
    private $mod;
    private $players;
    private $logging;

    private $announces = array();
    private $enabled;

    const KILL = "kill";
    const TEAMKILL = "teamkill";
    const SELFKILL = "selfkill";


    public function __construct () {
        $this->mod = &$GLOBALS['mod'];
        $this->players = &$GLOBALS['players'];
        $this->logging = &$GLOBALS['logging'];

        $this->eventParseConfig();
    }

    //array(killer_GUID, victim_GUID, array(weapon), damage, bodypart)

    public function eventKill($parameters) {
        $this->kill(self::KILL, $parameters[0], $parameters[1], $parameters[2][0], $parameters[2][1]);
    }

    public function eventTeamKill($parameters) {
        $this->kill(self::TEAMKILL , $parameters[0], $parameters[1], $parameters[2][0], $parameters[2][1]);
    }

    public function eventSelfKill($parameters) {
        $this->kill(self::SELFKILL , $parameters[0], false, $parameters[1][0], $parameters[1][1]);
    }

    private function kill($type, $killer, $victim, $weapon, $mod) {
        if (!$this->enabled || !$this->mod->getCV("killannounces", "enabled")) return;

        $messages = array();
        foreach ($this->announces as $ann) {
            $a = ($ann["type"]   == false || in_array($type, $ann["type"])) &&
                 ($ann["mod"]    == false || in_array($mod, $ann["mod"]))&&
                 ($ann["weapon"] == false || in_array($weapon, $ann["weapon"]));

            if ($a) {
                $messages[] = $ann["message"];
            }
        }

        if ($messages == array()) return;

        $search = array();
        $replace = array();

        $search[] = "<KILLER_NAME>";
        $search[] = "<VICTIM_NAME>";
        $search[] = "<WEAPON>";

        $replace[] = $this->players[$killer]->getName();
        $replace[] = $victim ? $this->players[$victim]->getName() : "himself";
        $replace[] = $this->mod->getLongWeaponName(array($weapon, $mod));


        foreach ($messages as $message) {
            $this->mod->rconSay(str_replace($search, $replace, $message));
        }
    }

    public function eventParseConfig() {

	    try {
            $cfg = Configparser::dParse($this->mod->getConfigDir()."/plugins/killannounces.cfg");
        }
        catch (Parser_Exception $e) {
            $this->logging->write(MOD_ERROR, $e->getMessage() . " in ".$e->getFilename()." on line " . $e->getConfigLine());
        }

        foreach ($cfg as $key => $value) {
            if (!$value["enabled"]) {
                unset($cfg[$key]);
                continue;
            }

            $cfg[$key]["mod"] = ($value["mod"] == "") ? false : explode(",", $value["mod"]);
            $cfg[$key]["weapon"] = ($value["weapon"] == "") ? false : explode(",", $value["weapon"]);
            $cfg[$key]["type"] = ($value["type"] == "") ? false : explode(",", $value["type"]);

        }

        $this->enabled = !empty($cfg);

        $this->announces = $cfg;
    }

}