<?php

$customcommands = new customcommands();
$customcommands->registerCommands();
$mod->registerEvent("parseConfig", "readConfig", $customcommands);


class customcommands {
    private $mod;
    private $logging;
    private $players;
    private $commands = array();

    public function __construct() {
        $this->mod = &$GLOBALS['mod'];
        $this->logging = &$GLOBALS['logging'];
        $this->players = &$GLOBALS['players'];

        $this->readConfig();
    }

    public function readConfig() {
        $this->commands = $this->mod->getCVSection("customcommands");
    }

    public function registerCommands() {
        foreach (array_keys($this->commands) as $command) {
            $this->mod->registerCommand(strtolower($command), false, "cmd_$command", $GLOBALS['customcommands']);
        }
    }

    public function __call($name, $parameters) {
        if (substr($name, 0, 4) != "cmd_" || !array_key_exists(substr($name, 4), $this->commands)) {
            $this->logging->write(MOD_ERROR, "Customcommands: Call to undefined function $name");
        }

        $this->executeCommand(substr($name, 4), $parameters[0], $parameters[1]);
    }

    private function executeCommand($command, $guid, $parameters) {
        $parameter = implode(" ", $parameters);

        $search = array();
        $replace = array();

        if (preg_match('#<ARG:FIND_PLAYER:(PBID|GUID|PID|NAME)>#', $this->commands[$command])) {
            $player = $this->mod->findPlayerGuid($parameter);
            if ($player === false) {
                $this->players[$guid]->say($this->mod->getLngString("playerNotFound", "<SEARCH>", $parameter));
                return;
            }

            $search[] = "<ARG:FIND_PLAYER:PID>";
            $search[] = "<ARG:FIND_PLAYER:GUID>";
            $search[] = "<ARG:FIND_PLAYER:PBID>";
            $search[] = "<ARG:FIND_PLAYER:NAME>";
            $replace[] = $this->players[$player]->getPID();
            $replace[] = $guid;
            $replace[] = $this->players[$player]->getPbid();
            $replace[] = $this->players[$player]->getName();
        }

        if (strpos($this->commands[$command], "<ARG:FIND_MAP>") !== false) {
            $map = $this->mod->findMap($parameter);
            if ($map == false) {
                $this->players[$guid]->say($this->mod->getLngString("mapNotFound", "<MAP>", $parameter));
                return;
            }

            $search[] = "<ARG:FIND_MAP>";
            $replace[] = $map["cname"];
            $search[] = "<ARG:FIND_MAP_LONGNAME>";
            $replace[] = $map["longname"];
        }

        $search[] = "<ARG>";
        $search[] = "<PLAYER:GUID>";
        $search[] = "<PLAYER:PID>";
        $search[] = "<PLAYER:PBID>";
        $search[] = "<PLAYER:NAME>";
        $search[] = "<PLAYER:ADMINGROUP_SHORT>";
        $search[] = "<PLAYER:ADMINGROUP_LONG>";


        $replace[] = $parameter;
        $replace[] = $guid;
        $replace[] = $this->players[$guid]->getPID();
        $replace[] = $this->players[$guid]->getPbid();
        $replace[] = $this->players[$guid]->getName();
        $replace[] = $this->players[$guid]->getGroup()->getShortName();
        $replace[] = $this->players[$guid]->getGroup()->getLongName();

        if (preg_match('#<LAST_KILLER:(PBID|GUID|PID|NAME)>#', $this->commands[$command])) {
            $sguid = $this->players[$guid]->getLastKiller();
            if (!$sguid) {
                $this->players[$guid]->say($this->mod->getLngString("noKiller"));
                return;
            }
            else {
                $search[] = "<LAST_KILLER:GUID>";
                $search[] = "<LAST_KILLER:PID>";
                $search[] = "<LAST_KILLER:PBID>";
                $search[] = "<LAST_KILLER:NAME>";
                $replace[] = $sguid;
                $replace[] = $this->players[$sguid]->getPID();
                $replace[] = $this->players[$sguid]->getPbid();
                $replace[] = $this->players[$sguid]->getName();
            }
        }

        if (preg_match('#<LAST_VICTIM:(PBID|GUID|PID|NAME)>#', $this->commands[$command])) {
            $sguid = $this->players[$guid]->getLastVictim();
            if (!$sguid) {
                $this->players[$guid]->say($this->mod->getLngString("noVictim"));
                return;
            }
            else {
                $search[] = "<LAST_VICTIM:GUID>";
                $search[] = "<LAST_VICTIM:PID>";
                $search[] = "<LAST_VICTIM:PBID>";
                $search[] = "<LAST_VICTIM:NAME>";
                $replace[] = $sguid;
                $replace[] = $this->players[$sguid]->getPID();
                $replace[] = $this->players[$sguid]->getPbid();
                $replace[] = $this->players[$sguid]->getName();
            }
        }

        foreach (explode(";", $this->commands[$command]) as $command) {


            $rcon = str_replace($search, $replace, $command);

            if (!empty($parameter)) {
                $rcon = preg_replace('#<ARG:OPT:(.*?)>#', $parameter, $rcon);
            }
            else {
                $rcon = preg_replace('#<ARG:OPT:(.*?)>#', '$1', $rcon);
            }


            $this->mod->rconRcon($rcon);
        }


        $this->players[$guid]->say($this->mod->getLngString("commandExecuted"));
    }
}