<?php

//Banner einlesen und die Z�hlvariablen auf 0 setzen
function banner_read() {
    global $banner_banner;
    $configdir = $GLOBALS['mod']->getConfigDir();
    $banner_banner = explode("\n", file_get_contents($configdir . "/plugins/banner.lst"));
    $banner_banner = array_map("trim", $banner_banner);
}

$banner_lasttime = 0;
$banner_current = 0;

//Event registrieren
$mod->registerEvent("everyTime", "banner_send");
$mod->registerEvent("parseConfig", "banner_read");

//Default CVs registrieren
$mod->setDefaultCV("banner", "enabled", 0);
$mod->setDefaultCV("banner", "time", 120);

banner_read();

//Funktion die bei jedem durchlauf aufgerufen wird
function banner_send() {
	global $banner_banner;
	global $banner_lasttime;
	global $banner_current;
	global $mod;
	global $logging;

	//Ist [banner]enabled = 1
	if (!$mod->getCV("banner", "enabled")) {
		return false;
	}

	//Pr�fen, wann der letzte Banner gesendet wurde und ggf. n�chsten senden
	if (time() - $banner_lasttime > $mod->getCV("banner", "time")) {

		//Z�hler ggf. zur�cksetzen, wenn EOF bei banner.lst
		if ($banner_current >= count($banner_banner)) {
			$banner_current = 0;
		}

		$send = $banner_banner[$banner_current];

		//Is <NEXTMAP> or <NEXTGT> used
		if (strpos($send, "<NEXTMAP>") !== false || strpos($send, "<NEXTGT>") !== false) {
		    list($nextmap, $nextgt) = $mod->rconGetNextMap();
		    $nextmap = $mod->getLongMapName($nextmap);
		    $nextgt = $mod->getLongGametype($nextgt);
		    $send = str_replace(array("<NEXTMAP>", "<NEXTGT>"), array($nextmap, $nextgt), $send);
		}
		$lastmap = $mod->getLastMaps(1);
		$lastmap = $lastmap[0];

		$search = array(
    		"<VERSION>",
    		"<TIME_DE>",
    		"<TIME_EN>",
    		"<MAP>",
		);

		$replace = array(
		  VERSION,
		  date("H:i"),
		  date("g:i a"),
		  $mod->getLongMapName($lastmap),
		);


		$send = str_replace($search, $replace, $send);

		//Banner senden
		$mod->rconSay($send);
		$logging->write(MOD_NOTICE, "Banner message was sent: ".$send);

		//Z�hler erh�hen und Zeit neu setzen
		$banner_lasttime = time();
		$banner_current ++;
	}

}

?>