<?php


class mod_mysql extends mod {
    private $mysql;

    public function __construct($host, $user, $password, $database, $prefix) {
        parent::__construct();

        try {
            $this->mysql = new mysql($host, $user, $password, $database, $prefix);
        }
        catch (Exception $e) {
            $this->logging->write(MOD_ERROR, $e->getMessage());
        }


        $this->logging->write(MOD_NOTICE, "MySQL is being used for main configuration");
    }

    public function readConfig() {
		$this->admins = array();
		$this->config = array();
		$this->groups = array();
		$this->reasons = array();

		//Config.cfg and plugins directory
		$sql = "SELECT LOWER(`section`) AS `section`, LOWER(`name`) AS `name`, `value` FROM `:pfx:config`";
		$smt = $this->mysql->prepare($sql)->execute();
		while ($var = $smt->fetch_assoc()) {
		    $this->config[$var["section"]][$var["name"]] = $var["value"];
		}

		//maps.cfg
		$sql = "SELECT LOWER(`shortname`) AS `shortname`, `longname` FROM `:pfx:maps`";
		$smt = $this->mysql->prepare($sql)->execute();
		while ($var = $smt->fetch_assoc()) {
		    $this->maps[$var["shortname"]] = $var["longname"];
		}

		//admins.cfg
		$sql = "SELECT `guid`, LOWER(`group`) AS `group`, `protected`, LOWER(`names`) AS `names` FROM `:pfx:admins`";
		$smt = $this->mysql->prepare($sql)->execute();
		while ($var = $smt->fetch_assoc()) {
		    $this->admins[$var["guid"]] = array(
		        "group" => $var["group"],
		        "protected" => $var["protected"],
		        "names" => explode(",", $var["names"])
		    );
		}

		//groups.cfg
		$sql = "SELECT `id`, LOWER(`group`) AS `group`, `name` FROM `:pfx:groups`";
		$smt = $this->mysql->prepare($sql)->execute();
		while ($var = $smt->fetch_assoc()) {
		    $sql = "SELECT LOWER(`command`) AS `command` FROM `:pfx:groups_commands` WHERE `group` = :1";
		    $commands = $this->mysql->prepare($sql)->execute($var["id"])->single_column("command");
		    $this->groups[$var["group"]] = array(
		        "name" => $var["name"],
		        "commands" => $commands,
		    );
		}

		//reasons.cfg
		$sql = "SELECT LOWER(`name`) AS `name`, `reason` FROM `:pfx:reasons`";
		$smt = $this->mysql->prepare($sql)->execute();
        while ($row = $smt->fetch_assoc()) {
            $this->reasons[$row["name"]] = $row["reason"];
        }

		$this->logging->write(MOD_NOTICE, "Config, Maps, Groups, Admins and Reasons have been loaded");

		//languages
        $this->readLanguageFile($this->getCV("main", "language"));


        //Waffen einlesen
        $this->parseWeaponNames();


        //set the timezone
        date_default_timezone_set($this->getCV("main", "timezone"));

		$this->triggerEvent("parseConfig");
		$this->logging->write(MOD_NOTICE, "All config files were parsed");
    }

    public function updateAdmin($guid, $update) {
	    if (!array_key_exists($guid, $this->admins)) return false;
	    $sql = "UPDATE :pfx:admins SET protected = :1, names = :2, `group` = :3 WHERE guid = :4";
	    $this->mysql->prepare($sql)->execute(
	       isset($update["protected"]) ? $update["protected"] : (int)$this->admins[$guid]["protected"],
	       isset($update["names"]) ? $update["names"] : implode(",", $this->admins[$guid]["names"]),
	       isset($update["group"]) ? $update["group"] : $this->admins[$guid]["group"],
	       $guid
	    );
        return parent::updateAdmin($guid, $update);
    }

    public function deleteAdmin($guid) {
	    if (!array_key_exists($guid, $this->admins)) return false;
        $this->mysql->prepare("DELETE FROM :pfx:admins WHERE guid = :1")->execute($guid);
        return parent::deleteAdmin($guid);
    }

    public function addAdmin($guid, $group, $names = "", $protected = false) {
        if (array_key_exists($guid, $this->admins)) {
            return false;
        }

        $sql = "INSERT INTO :pfx:admins
                (guid, `group`, names, protected)
                VALUES (:1, :2, :3, :4)";
        $this->mysql->prepare($sql)->execute($guid, $group, $names, (int)$protected);

        return parent::addAdmin($guid, $group, $names, $protected);
    }

    protected function writeAdminsCfg() {}
}


?>