<?php

class admin {
    private $mod;
    private $player;
    private $group = null;


    private static $admincfg = array();

    public function __construct(player $player) {
        $this->mod = $GLOBALS['mod'];

        $this->player = $player;

        $this->assignGroup();
    }

    //Updates the group if it got changed in admins.cfg
    private function assignGroup() {
        if (!array_key_exists($this->player->getGuid(), self::$admincfg)) {
            $new = "default";
        }
        else {
            $new = self::$admincfg[$this->player->getGuid()]["group"];
        }

        if ($this->group == null || $this->group != $new) {
            $this->group = group::factory($new);
        }
    }

    public function setGroup($group) {
        $this->assignGroup();

        if ($group == $this->getGroup()) {
            return;
        }

        if ($group == group::NAME_DEFAULT) {
            unset(self::$admincfg[$this->getGuid()]);
        }
        elseif ($this->getGroup() == group::NAME_DEFAULT) {
            self::$admincfg[$this->getGuid()] = array(
                "group" => $group,
                "names" => $this->player->getName()
            );
        }
        else {
            self::$admincfg[$this->getGuid()]["group"] = $group;
        }

        $this->group = group::factory($group);

        self::updateAdminCfg();
    }

    public function getGroup() {
        $this->assignGroup();
        return $this->group;
    }

    public function getGuid() {
        return $this->player->getGuid();
    }

    public function getNames() {
        if (!isset($this->names)) return array();

        return explode(",", $this->names);
    }

    public function getProtection() {
        $group = $this->group->getProtection();
        if (empty($this->protection)) return $group;

        $prot = $this->protection;

        $parts = explode(",", $prot);

        foreach ($parts as $command) {
            if ($command[0] == "+") {
                $group[] = substr($command, 1);
            }
            elseif ($command[0] == "-") {
                $cmd = substr($command, 1);
                foreach (array_keys($group, $cmd) as $key) {
                    unset($group[$key]);
                }
            }
            else {
                throw new Exception("Error in admins.cfg, unrecognized prefix in protectionlist for admin " . $this->player->getGuid());
            }
        }

        return $group;
    }

    public function getCommands() {
        $group = $this->group->getCommands();
        if (empty($this->commands)) return $group;

        $cmds = $this->commands;

        $parts = explode(",", $cmds);

        foreach ($parts as $command) {
            if ($command[0] == "+") {
                $group[] = substr($command, 1);
            }
            elseif ($command[0] == "-") {
                $cmd = substr($command, 1);
                foreach (array_keys($group, $cmd) as $key) {
                    unset($group[$key]);
                }
            }
            else {
                throw new Exception("Error in admins.cfg, unrecognized prefix in commandlist for admin " . $this->player->getGuid());
            }
        }

        return $group;
    }

    public function getRank() {
        if (isset($this->rank)) {
            return (int)$this->rank;
        }
        return $this->group->getRank();
    }

    public function setRank($newrank) {
        if ($this->getGroup() == group::NAME_DEFAULT) {
            return false;
        }
        self::$admincfg[$this->getGuid()]["rank"] = (int)$newrank;
        return true;
    }




    public function __get($key) {
        return self::$admincfg[$this->player->getGuid()][$key];
    }

    public function __set($key, $value) {
        if ($key == "group") {
            throw new Exception("Use admin::setGroup() to set a group of an admin");
        }
        if ($this->group == group::NAME_DEFAULT) {
            throw new Exception("Player has to be in a group that is not default before admin values can be changed");
        }
        self::$admincfg[$this->player->getGuid()][$key] = $value;
        self::updateAdminCfg();
    }

    public function __isset($key) {
        if ($this->group == group::NAME_DEFAULT) return false;
        return isset(self::$admincfg[$this->player->getGuid()][$key]);
    }

    public function getPlayer() {
        return $this->player;
    }


    public static function setConfig($cfg) {
        self::$admincfg = $cfg;
    }

    public static function updateAdminCfg() {
        $GLOBALS['mod']->writeAdminCfg(self::$admincfg);
    }

    public static function getNameOwner($name) {
        $name = strtolower($name);
        foreach (self::$admincfg as $guid => $admin) {
            $names = explode(",", $admin["names"]);
            if (in_array($name, $names)) return $guid;
        }
        return false;
    }

    public static function getList($groups = false) {
        if ($groups == false) return self::$admincfg;

        if (!is_array($groups)) $groups = array($groups);

        $return = array();

        foreach (self::$admincfg as $guid => $admin) {
            if (!in_array($admin["group"], $groups)) {
                continue;
            }
            $return[$guid] = $admin;
        }

        return $return;
    }

}






