<?php


/*
[tcp_query]
enabled = 1
ip = "0.0.0.0"
port = 1337
logintimeout = 30
defaulaction = "say" ;rcon, say, none
sayprefix = "^3TCP-Admin (<ADMIN>): ^7"
admingroups = "master,admin"
disallowedcommands = "vote,yes,no"
maxconnections = 3
*/

define("MT_CONSOLE", 0);
define("MT_RCONSAY", 1);
define("MT_CHAT",    2);
define("MT_PM",      3);
define("MT_INFO",    4);


$mod->setDefaultCV("tcp_query", "enabled",  0);
$mod->setDefaultCV("tcp_query", "ip",  "0.0.0.0");
$mod->setDefaultCV("tcp_query", "port",  1337);
$mod->setDefaultCV("tcp_query", "logintimeout",  30);
$mod->setDefaultCV("tcp_query", "defaulaction",  "say");
$mod->setDefaultCV("tcp_query", "sayprefix",  "^3TCP-Admin (<ADMIN>): ^7");
$mod->setDefaultCV("tcp_query", "admingroups",  "master,admin");
$mod->setDefaultCV("tcp_query", "disallowedcommands",  "");
$mod->setDefaultCV("tcp_query", "maxconnections",  5);

$tcp_query = new tcp_query();

$mod->registerEvent("everyTime", "everyTime", $tcp_query);
//$mod->registerEvent("rconSay", "eventRconSay", $tcp_query);
//$mod->registerEvent("logAction", "eventLogAction", $tcp_query);
//$mod->registerEvent("nextMap", "eventNextMap", $tcp_query);
//$mod->registerEvent("parseConfig", "eventReadConfig", $tcp_query);
//$mod->registerEvent("playerJoined", "eventJoin", $tcp_query);
//$mod->registerEvent("playerQuit", "eventQuit", $tcp_query);

class tcp_query {
    private $socket = false;
    private $connections = array();
    private $enabled = false;
    private $mod;
    private $logging;
    private $players;
    private $userDB = array();

    public function __construct() {
        $this->mod     =& $GLOBALS["mod"];
        $this->logging =& $GLOBALS["logging"];
        $this->players =& $GLOBALS["players"];


        $this->enabled = (bool)(int)$this->mod->getCV("tcp_query", "enabled");

        if (!$this->enabled) return;

        $this->initSocket();
//        $this->readUserDB();
    }

    public function eventReadConfig() {
        if ($this->enabled && !$this->mod->getCV("tcp_query", "enabled")) {
            $this->writeAll("You have been disconnected: TCP-Interface has been disabled by admin\n");

            foreach (array_keys($this->connections) as $conection) {
                unset ($this->connections[$conection]);
            }
        }
        elseif (!$this->enabled && $this->mod->getCV("tcp_query", "enabled")) {
            $this->enabled = true;
            $this->initSocket();
            $this->readUserDB();
        }
        elseif ($this->enabled) {
            $this->readUserDB();
        }
    }



private function initSocket() {
        $this->socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
        if (!$this->socket) {
            $this->socketError();
            return;
        }
        if (!socket_bind($this->socket, $this->mod->getCV("tcp_query", "ip"), $this->mod->getCV("tcp_query", "port"))) {
            $this->socketError($this->socket);
            return;
        }
        if (!socket_listen($this->socket)) {
            $this->socketError($this->socket);
            return;
        }
        if (!socket_set_nonblock($this->socket)) {
            $this->socketError($this->socket);
            return;
        }
    }
	
private function socketError($socket = NULL) {
        $this->enabled = false;
        $err = socket_last_error($socket);
        $this->logging->write(MOD_WARNING, "TCP-Query: Socket-Error: " . socket_strerror($err));
    }	
	
	
   public function everyTime() {
        if (!$this->enabled) return;

        $this->checkForConnections();

        foreach (array_keys($this->connections) as $conection) {
            //Vorsorge gegen Fehlermeldungen wenn die Verbindungen whrend der Schleifenausfhrung gelscht wurden
            if (!array_key_exists($conection, $this->connections)) continue;

            $this->connections[$conection]->everyTime();
            if ($this->connections[$conection]->closed) {
                unset ($this->connections[$conection]);
            }
        }
    }




    private function checkForConnections() {
        $connection = @socket_accept($this->socket);
        if (!$connection) return false;
        if (count($this->connections) >= $this->mod->getCV("tcp_query", "maxconnections")) {
            socket_write($connection, chr(MT_CONSOLE).chr(0)."Maximum connections reached, you'll be disconnected\n");
            socket_close($connection);
            return;
        }

        socket_set_nonblock($connection);
        $this->connections[] = new tcp_query_connection($connection);
    }

}




?>