<?php

/*
PLUGIN: Modstuff
=============
Plugin for stuff like updatechecker, serverlist and so on.

CONFIG
------
[modstuff]
checkforupdates = 1             ;Check for new versions
checkinterval = 6               ;Check for new version every X hours
announceintervall = 5           ;Announce new version every X minutes in local chat
serverlist = 1                  ;Report server to serverlist under manuadminmod.de/serverlist
serverlistip = "142.33.233.5"   ;IP of the server


NAMESPACE: modstuff

Functions:
    modstuff_serverlistReport
    modstuff_checkVersion
    modstuff_announceNewVersion

Vars:
    $modstuff_lastUpdateCheck
    $modstuff_lastNewVersionAnnounce
    $modstuff_newVersionAvailable

*/

$mod->registerEvent("everyTime", "modstuff_checkVersion");
$mod->registerEvent("everyTime", "modstuff_announceNewVersion");
$mod->registerEvent("nextMap", "modstuff_serverlistReport");
modstuff_serverlistReport();

$mod->setDefaultCV("modstuff", "checkforupdates", 1);
$mod->setDefaultCV("modstuff", "checkinterval", 6);
$mod->setDefaultCV("modstuff", "announceinterval", 5);
$mod->setDefaultCV("modstuff", "serverlist", 1);
$mod->setDefaultCV("modstuff", "serverlistip", $mod->getCV("main", "ip"));

$modstuff_lastUpdateCheck = 0;
$modstuff_lastNewVersionAnnounce = 0;
$modstuff_newVersionAvailable = false;


function modstuff_serverlistReport() {
    global $mod;
    global $logging;

	if (!$mod->getCV("modstuff", "serverlist")) {
	    return;
	}
	$ip = $mod->getCV("modstuff", "serverlistip");
	if (empty($ip)) $ip = $mod->getCV("main", "ip");
	$port = $mod->getCV("main", "port");
	$url = "http://stats.manuadminmod.de/report.php?ip=$ip&port=$port&game=" . $mod->getGame();
	$logging->write(MOD_NOTICE, "Heartbeat has been sent to serverlist at manuadminmod.de: " . file_get_contents($url));
}

function modstuff_checkVersion () {
    global $mod;
    global $logging;
    global $modstuff_lastUpdateCheck;
    global $modstuff_newVersionAvailable;

    if (!$mod->getCV("modstuff", "checkforupdates") || $modstuff_newVersionAvailable != false) {
        return;
    }

    if (time() - $modstuff_lastUpdateCheck > $mod->getCV("modstuff", "checkinterval") * 60 * 60) {
        $modstuff_lastUpdateCheck = time();
        $currentversionfile = file_get_contents("http://stats.manuadminmod.de/version.txt");
        if (!$currentversionfile) {
            $logging->write(MOD_WARNING, "Couldn't get http://stats.manuadminmod.de/version.txt to check for updates");
            return;
        }
        $version = preg_replace('|[^0-9.]|', "", VERSION);
        $currentversion = preg_replace('|[^0-9.]|', "", $currentversionfile);
        $version = explode(".", $version);
        $currentversion = explode(".", $currentversion);
        foreach ($version as $key => $value) {
            if (!isset($currentversion[$key])) $currentversion[$key] = 0;
            if ($currentversion[$key] > $value) {
                $modstuff_newVersionAvailable = $currentversionfile;
                return;
            }
            elseif ($currentversion[$key] == $value) continue;
            elseif ($currentversion[$key] < $value) {
                return;
            }
        }
    }

}

function modstuff_announceNewVersion() {
    global $mod;
    global $modstuff_newVersionAvailable;
    global $modstuff_lastNewVersionAnnounce;
    global $logging;

    if ($modstuff_newVersionAvailable == false || time() - $modstuff_lastNewVersionAnnounce < $mod->getCV("modstuff", "announceinterval") * 60) {
        return;
    }

    $logging->write(MOD_NOTICE, "New version of Manu-Admin-Mod available ($modstuff_newVersionAvailable), please update by visiting manuadminmod.de");
    $mod->rconSay($mod->getLngString("newVersionAvailable", array("<VERSION>"), array($modstuff_newVersionAvailable)));
    $modstuff_lastNewVersionAnnounce = time();



}

?>