<?php

/*
PLUGIN: Badwords
================
Kicks player when they use bad words defined in config/plugins/badwords.lst more
that X-Times

CONFIG:
-------
[badwords]
enabled = 1                       ;Enable plugin
warnstokick = 3                   ;Uses of badwords until kick
mode = "kick"                     ;kick/ban/tempban
kickreason = "Use of bad words"   ;Reason of a kick

NAMESPACE: badwords

Functions:
     badwords_main
     badwords_read
     badwords_playerInit

Vars:
    $badwords_list
*/

$mod->setDefaultCV("badwords", "enabled",     0);
$mod->setDefaultCV("badwords", "warnstokick", 3);
$mod->setDefaultCV("badwords", "mode",        "tempban");
$mod->setDefaultCV("badwords", "kickreason",  "Use of bad words");

$mod->registerEvent("playerSay", "badwords_main");
$mod->registerEvent("playerJoined", "badwords_playerInit");
$mod->registerEvent("parseConfig", "badwords_read");
badwords_read();

//Init Players because playerJoined isn't called at startup
array_map("badwords_playerInit", array_keys($players));

function badwords_main($args) {
    list($guid, $message, $executed) = $args;

    global $players;
    global $mod;
    global $badwords_list;

    if (!$mod->getCV("badwords", "enabled")) return;

    if ($executed) return;

    if (!$badwords_list) return;

    if ($players[$guid]->isProtected("M,b")) {
        return;
    }

    $message = $mod->removecolor($message);

    $bad = false;
    foreach ($badwords_list["normal"] as $value) {
		if (stripos($message, $value[0]) !== false) {
			$bad = true;
			$badword = $value[0];
			$multi = $value[1];
			break;
		}
	}
	if (!$bad) {
		foreach ($badwords_list["regexp"] as $value) {
			if (preg_match("".str_replace("", "\\xB4", $value[0])."i", $message, $subpatterns)) {
				$bad = true;
			    $badword = $subpatterns[0];
			    $multi = $value[1];
				break;
			}
		}
	}

	if ($bad) {
	    $players[$guid]->badwords_used += $multi;

	    $GLOBALS['logging']->write(MOD_NOTICE, "Badwords: Player '".$players[$guid]->getName()."' used the bad word '$badword', PID: ".$players[$guid]->getPID().", GUID: $guid");

	    if ($players[$guid]->badwords_used >= $mod->getCV("badwords", "warnstokick")) {
	        switch ($mod->getCV("badwords", "mode")) {
	            case "tempban":
	                $players[$guid]->tempBan($mod->getCV("badwords", "kickreason"));
	                break;
	            case "kick":
	                $players[$guid]->kick($mod->getCV("badwords", "kickreason"));
	                break;
	            case "ban":
	                $players[$guid]->ban($mod->getCV("badwords", "kickreason"));
	                break;
	        }
	    }
	    else {
	        $players[$guid]->say($mod->getLngString("usedBadWord", array("<WORD>", "<WARNS>", "<MAXWARNS>"), array($badword, $players[$guid]->badwords_used, $mod->getCV("badwords", "warnstokick"))));
	    }
	}

}

function badwords_read() {
    if (!$GLOBALS['mod']->getCV("badwords", "enabled")) {
       return;
    }

    $configdir = $GLOBALS['mod']->getConfigDir();
    global $badwords_list;
    $list = file($configdir . "/plugins/badwords.lst");
    if ($list === false) {
        $GLOBALS['logging']->write(MOD_WARNING, "Badwords: File $configdir/plugins/badwords.lst could not be opened, badwords will be disabled");
        $badwords_list = false;
        return;
    }
    $normal = array();
    $regexp = array();
    foreach ($list as $value) {
        $value = trim($value);
        if (preg_match('|{([\d.]+)}$|', $value, $subpatterns)) {
            $multi = $subpatterns[1];
            $value = str_replace($subpatterns[0], "", $value);
        }
        else {
            $multi = 1;
        }
        if (stripos($value, "regexp:") === 0) {
            $regexp[] = array(substr($value, 7), $multi);
        }
        else {
            $normal[] = array($value, $multi);
        }
    }
    $badwords_list = array("normal" => $normal, "regexp" => $regexp);
}

function badwords_playerInit($guid) {
    $GLOBALS['players'][$guid]->badwords_used = 0;
}


?>