<?php

/*
PLUGIN: Antiteamkiller
=============
Automatically kicks players that make to many teamkills
!forgive can be used to forgive a teamkill
!tki shows your current TKI

CONFIG
------
[antiteamkiller]
enabled = 1
min = -3
start = 0
warn = 3
kick = 4
teamkill = 1
kill = 0.1
mode = "tempban"
kickreason = "Made too many teamkills"
forgive = 1
forgivetime = 30
forgivepoints = 1

COMMANDS
--------
!forgive
!tki

NAMESPACE: antiteamkiller

Classes:
    antiteamkiller

Vars:
    $antiteamkiller

*/

$antiteamkiller = new antiteamkiller();

$mod->registerEvent("playerJoined", "playerInit", $antiteamkiller);
$mod->registerEvent("playerTeamKill", "triggerTeamKill", $antiteamkiller);
$mod->registerEvent("playerKill", "triggerKill", $antiteamkiller);

$mod->setDefaultCV("antiteamkiller", "enabled", 0);
$mod->setDefaultCV("antiteamkiller", "min", -3);
$mod->setDefaultCV("antiteamkiller", "start", 0);
$mod->setDefaultCV("antiteamkiller", "warn", 3);
$mod->setDefaultCV("antiteamkiller", "kick", 4);
$mod->setDefaultCV("antiteamkiller", "teamkill", 1);
$mod->setDefaultCV("antiteamkiller", "kill", 0.1);
$mod->setDefaultCV("antiteamkiller", "mode", "tempban");
$mod->setDefaultCV("antiteamkiller", "kickreason", "Made too many teamkills");
$mod->setDefaultCV("antiteamkiller", "forgive", 0);
$mod->setDefaultCV("antiteamkiller", "forgivetime", 30);
$mod->setDefaultCV("antiteamkiller", "forgivepoints", 1);

//Init Players
foreach (array_keys($players) as $guid) {
    $antiteamkiller->playerInit($guid);
}

$mod->registerCommand("tki", false, "commandTKI", $antiteamkiller);
$mod->registerCommand("forgive", false, "commandForgive", $antiteamkiller);

class antiteamkiller {
    private $mod;
    private $players;
    private $logging;

    public function __construct() {
        $this->mod = &$GLOBALS['mod'];
        $this->players = &$GLOBALS['players'];
        $this->logging = &$GLOBALS['logging'];
    }

    public function playerInit($guid) {
        $this->players[$guid]->antiteamkiller_tki = $this->mod->getCV("antiteamkiller", "start");
        $this->players[$guid]->antiteamkiller_lastteamkilled = 0;
        $this->players[$guid]->antiteamkiller_lastTKforgiven = false;
        $this->players[$guid]->antiteamkiller_lastTeamKiller = "";
    }

    public function triggerTeamKill($parameters) {
        list($killer, $victim, $weapon) = $parameters;

        if (!$this->mod->getCV("antiteamkiller", "enabled")) {
            return;
        }

        $add = $this->mod->getCV("antiteamkiller", "teamkill");
        //Airstrike
		if ($weapon[0] == "artillery_mp" || $weapon[0] == "destructible_car") {
			$add /= 2;
		}
		//Claymore + Heli + A-Bombe
		elseif ($weapon[0] == "claymore_mp" || $weapon[0] == "cobra_20mm_mp" || $weapon[0] == "hind_20mm_mp" || $weapon[0] = "nuke_mp") {
			$add = 0;
		}
        $this->players[$killer]->antiteamkiller_tki += $add;

        $this->players[$victim]->antiteamkiller_lastteamkilled = time();
        $this->players[$victim]->antiteamkiller_lastTKforgiven = false;
        $this->players[$victim]->antiteamkiller_lastTeamKiller = $killer;
        $this->players[$victim]->antiteamkiller_lastTKWeapon = $weapon[0];

        $this->logging->write(MOD_NOTICE, "Antiteamkiller: Player '".$this->players[$killer]->getName()."' teamkilled '".$this->players[$victim]->getName()."', PID_A: ".$this->players[$killer]->getPID().", GUID_A: ".$this->players[$killer]->getGuid().", PID_V: ".$this->players[$victim]->getPID().", GUID_V: ".$this->players[$victim]->getGuid());

        $kicked = $this->warnAndKick($killer);

        if (!$kicked) {
            $this->sendForgive($victim, $killer);
        }
    }

    public function triggerKill($parameters) {
        list($killer, $victim) = $parameters;

        if (!$this->mod->getCV("antiteamkiller", "enabled")) {
            return;
        }

        if ($this->players[$killer]->antiteamkiller_tki - $this->mod->getCV("antiteamkiller", "kill") <= $this->mod->getCV("antiteamkiller", "min")) {
            $this->players[$killer]->antiteamkiller_tki = $this->mod->getCV("antiteamkiller", "min");
        }
        else {
            $this->players[$killer]->antiteamkiller_tki -= $this->mod->getCV("antiteamkiller", "kill");
        }
    }

    private function warnAndKick($killer) {
        if ($this->players[$killer]->isProtected("M,t")) {
            return false;
        }

        $tki = $this->players[$killer]->antiteamkiller_tki;

        if ($tki >= $this->mod->getCV("antiteamkiller", "kick")) {
        	switch ($this->mod->getCV("antiteamkiller", "mode")) {
                case "tempban":
                    $this->players[$killer]->tempBan($this->mod->getCV("antiteamkiller", "kickreason"));
                    break;
                case "kick":
                    $this->players[$killer]->kick($this->mod->getCV("antiteamkiller", "kickreason"));
                    break;
                case "ban":
                    $this->players[$killer]->ban($this->mod->getCV("antiteamkiller", "kickreason"));
                    break;
            }
            return true;
        }
        if ($tki >= $this->mod->getCV("antiteamkiller", "warn")) {
            $this->players[$killer]->say($this->mod->getLngString("warnHighTKI"));
            $this->logging->write(MOD_NOTICE, "Antiteamkiller: Player '"."' has been warned for his high TKI ($tki), PID: ".$this->players[$killer]->getPID().", GUID: ".$this->players[$killer]->getGuid());
        }
        return false;
    }

    public function commandTKI($guid, $parameters) {
        $tki = $this->players[$guid]->antiteamkiller_tki;
        $this->players[$guid]->say($this->mod->getLngString("getTKI", array("<TKI>"), array($tki)));
    }

    private function sendForgive($victim, $killer) {
        if (!$this->mod->getCV("antiteamkiller", "forgive")) {
            return;
        }
        $name = $this->players[$killer]->getName();
        $time = $this->mod->getCV("antiteamkiller", "forgivetime");
        $this->players[$victim]->say($this->mod->getLngString("forgiveMessage", array("<TIME>", "<NAME>"), array($time, $name)));

    }

    public function commandForgive($guid, $parameters) {
        if (!$this->mod->getCV("antiteamkiller", "forgive")
         || !array_key_exists($this->players[$guid]->antiteamkiller_lastTeamKiller, $this->players)
         || $this->players[$guid]->antiteamkiller_lastTKforgiven
         || time() - $this->players[$guid]->antiteamkiller_lastteamkilled > $this->mod->getCV("antiteamkiller", "forgivetime")) {
            return;
        }

        $this->players[$guid]->antiteamkiller_lastTKforgiven = true;
        $weapon = $this->players[$guid]->antiteamkiller_lastTKWeapon;

        $remove = $this->mod->getCV("antiteamkiller", "forgivepoints");
        //Airstrike
		if ($weapon == "artillery_mp" || $weapon == "destructible_car") {
			$remove /= 2;
		}
		//Claymore + Heli
		elseif ($weapon == "claymore_mp" || $weapon == "cobra_20mm_mp" || $weapon == "hind_20mm_mp") {
			$remove = 0;
		}
        $this->players[$this->players[$guid]->antiteamkiller_lastTeamKiller]->antiteamkiller_tki -= $remove;

        $name_killer = $this->players[$this->players[$guid]->antiteamkiller_lastTeamKiller]->getName();
        $name_victim = $this->players[$guid]->getName();

        $this->mod->rconSay($this->mod->getLngString("playerHasForgiven", array("<KILLER>", "<VICTIM>"), array($name_killer, $name_victim)));

        $this->logging->write(MOD_NOTICE, "Antiteamkiller: Player '$name_victim' forgave is teamkill by '$name_killer', PID_V: ".$this->players[$guid]->getPID().", GUID_V: ".$guid.", PID_A: ".$this->players[$this->players[$guid]->antiteamkiller_lastTeamKiller]->getPID().", PID_A: ".$this->players[$this->players[$guid]->antiteamkiller_lastTeamKiller]->getGuid());
    }
}


?>