<?php
/*
===============
PLUGIN: chatlog
===============
Logging the Chat of the Server.

[chatlog] 
enabled = 1	; Enable/Disable the Plugin
dateformat = "d.m.y H:i:s" ; Decide which Date/Time Format you wanna use.
saveas = "text" ; Decide save in Mysql or as Text File
logname = "chat.log" ; decide which log name you wanna use
host = "" ; Mysql Hostname e.g. localhost
user = "" ; Mysql User
password = "" ; Mysql password
database = "" ; Mysql database
prefix = "mam_" ; mysql prefix

@author manu
@modify voices
@license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
@version 1.0
*/

//Set Default CV
$mod->setDefaultCV("chatlog", "enabled", "0");
$mod->setDefaultCV("chatlog", "dateformat", "d.m.y H:i:s");
$mod->setDefaultCV("chatlog", "saveas", "text");
$mod->setDefaultCV("chatlog", "logname", "chat.log");
$mod->setDefaultCV("chatlog", "host", "localhost");
$mod->setDefaultCV("chatlog", "user", "adminmod");
$mod->setDefaultCV("chatlog", "password", "verysecure");
$mod->setDefaultCV("chatlog", "database", "mam");
$mod->setDefaultCV("chatlog", "prefix", "mam_");

try {
    switch (strtolower($mod->getCV("chatlog", "saveas"))) {
        case "mysql":
            $mod->registerEvent("playerSay", "chatlog_mysql");
           break;
        default:
            $mod->registerEvent("playerSay", "chatlog_text");
            break;
   }
}
catch (Exception $e) {
    $logging->write(MOD_ERROR, "Chatlog: " . $e->getMessage());
}


//Function Chatlog as *log File
function chatlog_text($param) {
	list($guid, $text) = $param;
	global $players;
	global $mod;

	if(!$mod->getCV("chatlog", "enabled")) {
		return;
	}
	
	$chatlog_fp = fopen($logdir . $mod->getCV("chatlog", "logname"), "a");
	$timestamp = date($mod->getCV("chatlog", "dateformat"));
	$name = $players[$guid]->getName();
	$text = $mod->removecolor($text);

	fwrite($chatlog_fp, "$timestamp $name: $text\r\n");
}

//Function Chatlog in Mysql Database
function chatlog_mysql($param) {
	list($guid, $text) = $param;
	global $players;
	global $mod;

	if(!$mod->getCV("chatlog", "enabled")) {
		return;
	}
	
	$timestamp = date($mod->getCV("chatlog", "dateformat"));
	$name = $players[$guid]->getName();
	$text = $mod->removecolor($text);

	$dblog = mysql_connect($mod->getCV("chatlog", "host"),$mod->getCV("chatlog", "user"),$mod->getCV("chatlog", "password"))or die("Fehler");
	mysql_select_db($mod->getCV("chatlog", "database"));
	echo mysql_error();
	$sql = "INSERT INTO " . $mod->getCV("chatlog", "prefix") . "chatlog (time, name, text) VALUES ('$timestamp','$name','$text')";
	mysql_query($sql);
	echo mysql_error();
	mysql_close($dblog);	
}
?>
