<?php
/*
 * PB Violation Check Plugin
 *
 * Events:
 *      PlayerJoined
 *          A player who is joining the server will be banned if he is in the Punkbuster sv_cheat.log.
 * 
 * Config:
 *      [violationcheck]
 *		enabled = 1
 *		file = "../pb/sv_cheat.log"
 *		mode = "ban"
 *		reason = "Violation Found"
 * 
 * @author Voices
 * @license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
 * @version 1.1
 */
$mod->registerEvent("playerJoined", "Violation_Check");

$mod->setDefaultCV("violationcheck", "enabled", 0);
$mod->setDefaultCV("violationcheck", "file", "../pb/sv_cheat.log");
$mod->setDefaultCV("violationcheck", "mode", "ban");
$mod->setDefaultCV("violationcheck", "reason", "Violation Found");

function Violation_Check($guid) {
    global $players;
    global $mod;
	
	if(!$mod->getCV("violationcheck", "enabled")) {
        return;
    }
	
	if (!file_exists($mod->getCV("violationcheck", "file"))) {
		return;
	}

	$cheatlog = file_get_contents($mod->getCV("violationcheck", "file"), null);
	
	if(strpos($cheatlog, $guid)!==false) 
	{
		switch ($mod->getCV("violationcheck", "mode")) {
			case "tempban":
				$players[$guid]->tempBan($mod->getCV("violationcheck", "reason"));
				break;
			case "kick":
				$players[$guid]->kick($mod->getCV("violationcheck", "reason"));
				break;
			case "ban":
				$players[$guid]->ban($mod->getCV("violationcheck", "reason"));
				break;
		}
	}
}

?>