<?php

$commands_basic = new commands_basic();

//                    COMMAND       SYNTAX                      FUNCTION      OBJECT
$mod->registerCommand("kick",       '~^kick \S.*$~i' ,          "kick",       $commands_basic);
$mod->registerCommand("ban",        '~^ban \S.*$~i' ,           "ban",        $commands_basic);
$mod->registerCommand("tempban",    '~^tempban \S.*$~i' ,       "tempBan",    $commands_basic);
$mod->registerCommand("map",        '~^map [\w. -]+$~i',        "map",        $commands_basic);
$mod->registerCommand("restart",    '~^restart( (1|0))?$~i',    "restart",    $commands_basic);
$mod->registerCommand("readconfig",  false,                     "readConfig", $commands_basic);
$mod->registerCommand("quitmod",     false,                     "quit",       $commands_basic);
$mod->registerCommand("killserver",  false,                     "killServer", $commands_basic);
$mod->registerCommand("maprotate",   false,                     "mapRotate",  $commands_basic);
$mod->registerCommand("help",       '~^help \S+$~i',            "help",       $commands_basic);
$mod->registerCommand("cointoss",    false,                     "cointoss",   $commands_basic);
$mod->registerCommand("gametype",   '~^gametype \w+$~i',        "gametype",   $commands_basic);
$mod->registerCommand("admintest",   false,                     "admintest",  $commands_basic);
$mod->registerCommand("time",        false,                     "time",       $commands_basic);
$mod->registerCommand("nextmap",     false,                     "nextmap",    $commands_basic);
$mod->registerCommand("kickall",     false,                     "kickall",    $commands_basic);
$mod->registerCommand("uptime",      false,                     "uptime",     $commands_basic);
$mod->registerCommand("setpw",      '~^setpw .+$~i',            "setpw",      $commands_basic);
$mod->registerCommand("removepw",    false,                     "removepw",   $commands_basic);
$mod->registerCommand("info",        false,                     "info",       $commands_basic);
$mod->registerCommand("hardcore",   '~^hardcore (1|0)$~i',      "hardcore",   $commands_basic);
$mod->registerCommand("oldschool",  '~^oldschool (1|0)$~i',     "oldschool",  $commands_basic);
$mod->registerCommand("killcam",    '~^killcam (1|0)$~i',       "killcam",    $commands_basic);
$mod->registerCommand("gravity",    '~^gravity( \d+)?$~i',      "gravity",    $commands_basic);
$mod->registerCommand("knockback",  '~^knockback( \d+)?$~i',    "knockback",  $commands_basic);
$mod->registerCommand("speed",      '~^speed( \d+)?$~i',        "speed",      $commands_basic);
$mod->registerCommand("me",          false,                     "me",         $commands_basic);
$mod->registerCommand("devmap",     '~^devmap [\w ]+$~i',       "devmap",     $commands_basic);
$mod->registerCommand("rcon",       '~^rcon .+$~i',             "rcon",       $commands_basic);
$mod->registerCommand("setff",      '~^setff (0|1|2|3)$~i',     "setff",      $commands_basic);
$mod->registerCommand("ff",          false,                     "ff",         $commands_basic);
$mod->registerCommand("say",        '~^say .+$~i',              "say",        $commands_basic);
$mod->registerCommand("pl",          false,                     "pl",         $commands_basic);
$mod->registerCommand("maps",        false,                     "maps",       $commands_basic);
$mod->registerCommand("cmdlist",     false,                     "cmdlist",    $commands_basic);
$mod->registerCommand("exec",       '~^exec \S+$~i',            "exec",       $commands_basic);
$mod->registerCommand("setnextmap", '~^setnextmap [\w. -]+$~i', "setnextmap", $commands_basic);
$mod->registerCommand("checkadmin", '~^checkadmin \S.*$~i',     "checkadmin", $commands_basic);
$mod->registerCommand("protect",    '~^protect \S.*$~i',        "protect",    $commands_basic);
$mod->registerCommand("setgroup",   '~^setgroup \w+ \S.*$~i',   "setgroup",   $commands_basic);
$mod->registerCommand("online",      false,                     "online",     $commands_basic);
$mod->registerCommand("status",      false,                     "status",     $commands_basic);
$mod->registerCommand("whisper",     '~^whisper \S+ \S.*$~i',   "whisper",    $commands_basic);
$mod->registerCommand("voting",      '~^voting (1|0)$~',        "voting",     $commands_basic);
$mod->registerCommand("getip",       '~^getip \S.*$~i',         "getip",      $commands_basic);

class commands_basic {
	private $players = array();
	private $mod = false;
	private $logging = false;

	public function __construct() {
		$this->players = &$GLOBALS['players'];
		$this->mod = &$GLOBALS['mod'];
		$this->logging = &$GLOBALS['logging'];
	}

	public function kick($guid, $parameters) {
	    $parastring = implode(" ",$parameters);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $parameters) = explode("\\", $parastring, 2);
	        $player = trim($player);
	        $parameters = array(trim($parameters));
	    }
	    else {
		    $player = array_shift($parameters);
	    }
		$tokick = $this->mod->findPlayerGuid($player);

		if (!$tokick) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
		    if ($this->players[$tokick]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantKickProtected"));
		        return false;
		    }
			if (!empty($parameters)) {
				$reason = implode(" ", $parameters);
				$this->mod->findReason($reason);
			}
            else {
            $this->players[$guid]->say("Bitte gebe einen Kickgrund an");
                return false;
            }
			if ($this->players[$tokick]->kick($reason, $guid)) {
			    if (!$this->mod->getCV("kickban", "announce")) {
				    $this->players[$guid]->say($this->mod->getLngString("playerKicked", array("<PLAYER>"), array($this->players[$tokick]->getName())));
			    }
			}
			else {
				$this->players[$guid]->say($this->mod->getLngString("anyError"));
			}
		}
	}

	public function ban($guid, $parameters) {
	    $parastring = implode(" ",$parameters);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $parameters) = explode("\\", $parastring);
	        $player = trim($player);
	        $parameters = array(trim($parameters));
	    }
	    else {
		    $player = array_shift($parameters);
	    }

		$tokick = $this->mod->findPlayerGuid($player);

		if (!$tokick) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
		    if ($this->players[$tokick]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantKickProtected"));
		        return false;
		    }
			if (!empty($parameters)) {
				$reason = implode(" ", $parameters);
				$this->mod->findReason($reason);
			}
            else {
            $this->players[$guid]->say("Bitte gebe einen Kickgrund an");
                return false;
            }
			if ($this->players[$tokick]->ban($reason, $guid)) {
			    if (!$this->mod->getCV("kickban", "announce")) {
				    $this->players[$guid]->say($this->mod->getLngString("playerBanned", array("<PLAYER>"), array($this->players[$tokick]->getName())));
			    }
			}
			else {
				$this->players[$guid]->say($this->mod->getLngString("anyError"));
			}
		}
	}

	public function tempBan($guid, $parameters) {
	    $parastring = implode(" ",$parameters);
	    if (strpos($parastring, "\\") !== false) {
	        list($player, $parameters) = explode("\\", $parastring);
	        $player = trim($player);
	        $parameters = array(trim($parameters));
	    }
	    else {
		    $player = array_shift($parameters);
	    }

		$tokick = $this->mod->findPlayerGuid($player);

		if (!$tokick) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
		}
		else {
		    if ($this->players[$tokick]->isProtected()) {
		        $this->players[$guid]->say($this->mod->getLngString("cantKickProtected"));
		        return false;
		    }
			if (!empty($parameters)) {
			    if (is_numeric($parameters[0]) && $parameters[0] > 0) {
			        $time = array_shift($parameters);
			        if ($time > $this->mod->getCV("kickban", "maxtempbantime")) {
			            $time = $this->mod->getCV("kickban", "maxtempbantime");
			        }
			    }
			    else {
			        $time = false;
			    }
			    if (!empty($parameters)) {
				    $reason = implode(" ", $parameters);
				    $this->mod->findReason($reason);
			    }
			    else {
			        $reason = false;
			    }
			}
			else {
				$reason = false;
				$time = false;
			}
			if ($this->players[$tokick]->tempBan($reason, $time, $guid)) {
			    if (!$this->mod->getCV("kickban", "announce")) {
				    $this->players[$guid]->say($this->mod->getLngString("playerTempBanned", array("<PLAYER>"), array($this->players[$tokick]->getName())));
			    }
			}
			else {
				$this->players[$guid]->say($this->mod->getLngString("anyError"));
			}
		}
	}

	public function map($guid, $parameters) {
		//no case sensitivity
		$parameters = array_map("strtolower", $parameters);

		if (count ($parameters) > 1 && in_array($parameters[count($parameters)-1], array("sd","war","dm","sab","koth","dom","ctf","htf", "twar", "tdm", "hq", "gtnw","oneflag","dd","arena"))) {
			$gametype = array_pop($parameters);
		}
		else {
			$gametype = $this->mod->getCurrentGametype();
		}

		$map = $this->mod->findMap(implode(" ", $parameters));

		if (!$map) {
			$this->players[$guid]->say($this->mod->getLngString("mapNotFound", array("<MAP>"), array(implode(" ", $parameters))));
			return false;
		}

		$this->mod->rconSay($this->mod->getLngString("changeMap", array("<MAP>", "<GAMETYPE>"), array($this->mod->getLongMapName($map), $this->mod->getLongGametype($gametype))));
		if (!$this->mod->rconChangeMap($map, $gametype)) {
			$this->mod->rconSay($this->mod->getLngString("mapNotFound", array("<MAP>"), array(implode(" ", $parameters))));
		}
	}

	public function restart($guid, $parameters) {
		if (!empty($parameters[0])) {
		    $this->mod->rconSay($this->mod->getLngString("mapRestart"));
			$this->mod->rconMapRestart(true);
		}
		else {
		    $this->mod->rconSay($this->mod->getLngString("mapFastRestart"));
			$this->mod->rconMapRestart(false);
		}
	}

	public function readConfig($guid, $parameters) {
	    if (!empty($parameters)) {
	        $config = "loadable/" . implode(" ", $parameters) . ".cfg";
	        if (!$this->mod->readConfigFile($config)) {
	            $this->players[$guid]->say($this->mod->getLngString("configFileLoadError", "<FILE>", $config));
	            return false;
	        }
            $this->players[$guid]->say($this->mod->getLngString("configFileLoad", "<FILE>", $config));
            return true;
	    }
		$this->mod->readConfig();
		$this->mod->rconSay($this->mod->getLngString("configParsed"));
	}

	public function quit($guid, $parameters) {
	    $this->mod->killMod();
	}

	public function killServer($guid, $parameters) {
	    $this->mod->rconKillServer();
	}

	public function mapRotate($guid, $parameters) {
	    $this->mod->rconSay($this->mod->getLngString("loadingNextMap"));
	    $this->mod->rconMapRotate();
	}

	public function help($guid, $parameters) {
	    $this->mod->printHelp($parameters[0], $guid);
	}

	public function cointoss($guid, $parameters) {
	    $rand = rand(0,1);
	    $coin = array($this->mod->getLngString("heads"), $this->mod->getLngString("tails"));
	    $this->mod->rconSay($this->mod->getLngString("cointoss", array("<RESULT>"), array($coin[$rand])));
	}

	public function gametype($guid, $parameters) {
	    $this->mod->rconSay($this->mod->getLngString("changeGametype", array("<GAMETYPE>"), array($this->mod->getLongGametype($parameters[0]))));
	    $this->mod->rconSetGametype($parameters[0]);
	    $this->mod->rconMapRestart(true);
	}

	public function admintest($guid, $parameters) {
	    $nick = $this->players[$guid]->getName();
	    $group = $this->mod->getLongGroupName($this->players[$guid]->getGroup());
	    $this->mod->rconSay($this->mod->getLngString("admintest", array("<PLAYER_NAME>", "<PLAYER_GROUP>"), array($nick, $group)));
	}

	public function time($guid, $parameters) {
	    $this->mod->rconSay($this->mod->getLngString("time", array("<TIME>"), array(date("H:i"))));
	}

	public function nextmap($guid, $parameters) {
	    $next = $this->mod->rconGetNextMap();
        $map = $this->mod->getLongMapName($next["map"]);
        $gt  = $this->mod->getLongGametype($next["gametype"]);
        $this->mod->rconSay($this->mod->getLngString("nextmap", array("<GAMETYPE>", "<MAP>"), array($gt, $map)));
	}

	public function kickall($guid, $parameters) {
	    $this->mod->rconSay($this->mod->getLngString("kickAll"));
	    $this->mod->rconKickAll();
	}

	public function uptime($guid, $parameters) {
	    if ($GLOBALS['parser']->getTimeStampType() == "absolute") return false;
	    $timestamp = $GLOBALS['parser']->getLastParsedTimeStamp();
	    $uptime = makeuptime(($timestamp - $timestamp%60)/60);
	    $this->mod->rconSay($this->mod->getLngString("uptime", array("<UPTIME>"), array($uptime)));
	}

	public function setpw($guid, $parameters) {
	    $this->mod->rconSay($this->mod->getLngString("passwordSet"));
	    $this->mod->rconSetDvar("g_password", implode(" ", $parameters));
	}

	public function removepw($guid, $parameters) {
	    $this->mod->rconSay($this->mod->getLngString("passwordRemoved"));
	    $this->mod->rconSetDvar("g_password", "");
	}

	public function info($guid, $parameters) {
        $this->mod->rconSay($this->mod->getLngString("versionInfo", array("<VERSION>"), array(VERSION)));
	}

	public function hardcore($guid, $parameters) {
	    $mode = array($this->mod->getLngString("disabled"), $this->mod->getLngString("enabled"));
	    $this->mod->rconSay($this->mod->getLngString("hardcoreChange", array("<MODE>"), array($mode[$parameters[0]])));
	    $this->mod->rconSetDvar("scr_hardcore", $parameters[0]);
	}

	public function voting($guid, $parameters) {
	    $mode = array($this->mod->getLngString("disabled"), $this->mod->getLngString("enabled"));
	    $this->mod->rconSay($this->mod->getLngString("votingChange", array("<MODE>"), array($mode[$parameters[0]])));
	    $this->mod->rconSetDvar("ui_allowvote", $parameters[0]);
	}

	public function oldschool($guid, $parameters) {
	    $mode = array($this->mod->getLngString("disabled"), $this->mod->getLngString("enabled"));
	    $this->mod->rconSay($this->mod->getLngString("oldschoolChange", array("<MODE>"), array($mode[$parameters[0]])));
	    $this->mod->rconSetDvar("scr_oldschool", $parameters[0]);
	}

	public function killcam($guid, $parameters) {
	    $mode = array($this->mod->getLngString("disabled"), $this->mod->getLngString("enabled"));
	    $this->mod->rconSay($this->mod->getLngString("killcamChange", array("<MODE>"), array($mode[$parameters[0]])));
	    $this->mod->rconSetDvar("scr_game_allowkillcam", $parameters[0]);
	}

	public function gravity($guid, $parameters) {
	    if (!empty($parameters[0])) {
	        $value = $parameters[0];
	    }
	    else {
	        $value = 800;
	    }
	    $this->mod->rconSay($this->mod->getLngString("gravityChange", array("<VALUE>"), array($value)));
	    $this->mod->rconSetDvar("g_gravity", $value);
	}

	public function knockback($guid, $parameters) {
	    if (!empty($parameters[0])) {
	        $value = $parameters[0];
	    }
	    else {
	        $value = 1000;
	    }
	    $this->mod->rconSay($this->mod->getLngString("knockbackChange", array("<VALUE>"), array($value)));
	    $this->mod->rconSetDvar("g_knockback", $value);
	}

	public function speed($guid, $parameters) {
	    if (!empty($parameters[0])) {
	        $value = $parameters[0];
	    }
	    else {
	        $value = 190;
	    }
	    $this->mod->rconSay($this->mod->getLngString("speedChange", array("<VALUE>"), array($value)));
	    $this->mod->rconSetDvar("g_speed", $value);
	}

	public function me($guid, $parameters) {
	    $this->players[$guid]->say($this->mod->getLngString("me", array("<PID>", "<GUID>"), array($this->players[$guid]->getPID(), $guid)));
	}

	public function devmap($guid, $parameters) {
		//no case sensitivity
		$parameters = array_map("strtolower", $parameters);

		$map = $this->mod->findMap(implode(" ", $parameters));

		if (!$map) {
			$this->players[$guid]->say($this->mod->getLngString("mapNotFound", array("<MAP>"), array(implode(" ", $parameters))));
			return false;
		}

		$this->mod->rconSay($this->mod->getLngString("changeMapDevMap", array("<MAP>"), array($this->mod->getLongMapName($map))));
		if (!$this->mod->rconDevMap($map)) {
			$this->mod->rconSay($this->mod->getLngString("mapNotFound", array("<MAP>"), array(implode(" ", $parameters))));
		}
	}

	public function rcon($guid, $parameters) {
	    $command = implode(" ", $parameters);
	    $return = $this->mod->rconRcon($command);
	    /*$this->mod->rconSay($this->mod->getLngString("rconExecuted"));*/
	    $say = preg_replace('#(\r\n|\r|\n)#', "\n", $return);
	    $say = implode("\n", array_slice(explode("\n", $say), 0, 6));
	    $this->players[$guid]->say($say);
	}

	public function ff($guid, $parameters) {
        $ff = $this->mod->rconGetDvar("scr_team_fftype");
        $mode = array(
            $this->mod->getLngString("disabled"),
            $this->mod->getLngString("enabled"),
            $this->mod->getLngString("reflected"),
            $this->mod->getLngString("shared"),
        );
        $this->mod->rconSay($this->mod->getLngString("friendlyFire", array("<MODE>"), array($mode[$ff])));
	}

	public function setff($guid, $parameters) {
        $mode = array(
            $this->mod->getLngString("disabled"),
            $this->mod->getLngString("enabled"),
            $this->mod->getLngString("reflected"),
            $this->mod->getLngString("shared"),
        );
        $this->mod->rconSay($this->mod->getLngString("setFriendlyFire", array("<MODE>"), array($mode[$parameters[0]])));
        $this->mod->rconSetDvar("scr_team_fftype",$parameters[0]);
	}

	public function say($guid, $parameters) {
        $this->mod->rconSay("^1".implode(" ", $parameters));
	}

	public function pl($guid, $parameters) {
	    $players = $this->mod->getPlayerList();
	    $string = "";
	    foreach ($players as $key => $value) {
	        $string .= "^1$key^7=>^3$value^7; ";
	    }
	    $string = substr($string, 0, -1);
	    $this->players[$guid]->say($string);
	}

	public function maps($guid, $parameters) {
	    $this->mod->rconSay($this->mod->getMaps("; "));
	}

	public function cmdlist($guid, $parameters) {
        $commands = $this->players[$guid]->getAllowedCommands();
        $say = $this->mod->getCV("main", "prefix") . implode("; ".$this->mod->getCV("main", "prefix"), $commands);
        $this->players[$guid]->say($say);
	}

	public function exec($guid, $parameters) {
	    if ($this->mod->rconExec($parameters[0])) {
            $this->players[$guid]->say($this->mod->getLngString("execSuccess", array("<FILE>"), array($parameters[0])));
	    }
	    else {
            $this->players[$guid]->say($this->mod->getLngString("execError", array("<FILE>"), array($parameters[0])));
	    }
	}

	public function setnextmap($guid, $parameters) {
        $parameters = array_map("strtolower", $parameters);

        //war,dm,sab,koth,sd,dom,gtnw,oneflag,ctf,dd,arena

		if (count ($parameters) > 1 && in_array($parameters[count($parameters)-1], array("sd","war","dm","sab","koth","dom","ctf","htf", "twar", "tdm", "hq", "gtnw","oneflag","dd","arena"))) {
			$gametype = array_pop($parameters);
		}
		else {
			$gametype = $this->mod->getCurrentGametype();
		}

		$map = $this->mod->findMap(implode(" ", $parameters));

		if (!$map) {
			$this->players[$guid]->say($this->mod->getLngString("mapNotFound", array("<MAP>"), array(implode(" ", $parameters))));
			return false;
		}

	    $this->mod->rconSetNextMap($map, $gametype, true);

	    $this->mod->rconSay($this->mod->getLngString("setNextMap", array("<MAP>", "<GAMETYPE>"), array($this->mod->getLongMapName($map), $this->mod->getLongGametype($gametype))));
	}

	public function checkadmin($guid, $parameters) {
	    $parameters = implode(" ", $parameters);

	    $player = $this->mod->findPlayerGuid($parameters);
	    if (!$player) {
	        $this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($parameters)));
	        return false;
	    }
	    $group = $this->mod->getLongGroupName($this->players[$player]->getGroup());
	    $name = $this->players[$player]->getName();

	    $this->mod->rconSay($this->mod->getLngString("checkAdmin", array("<PLAYER_GROUP>", "<PLAYER_NAME>"), array($group, $name)));
	}

	public function protect($guid, $parameters) {
	    $parameters = implode(" ", $parameters);

	    $player = $this->mod->findPlayerGuid($parameters);
	    if (!$player) {
	        $this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($parameters)));
	        return false;
	    }

	    if ($this->players[$player]->setProtection(!$this->players[$player]->isProtected())) {
	        $lng = array("unprotected", "protected");
	        $this->mod->rconSay($this->mod->getLngString("setProtection", array("<PLAYER_NAME>", "<MODE>"), array($this->players[$player]->getName(), $this->mod->getLngString($lng[(int)$this->players[$player]->isProtected()]))));
	    }
	    else {
	        $this->players[$guid]->say($this->mod->getLngString("errorMustBeAdmin"));
	    }
	}

	public function setgroup($guid, $parameters) {
	    $parameters = array_map("strtolower", $parameters);
	    $group = array_shift($parameters);
	    $player = implode(" ", $parameters);

	    if (!array_key_exists($group, $this->mod->getGroups())) {
	        $list = implode(", ", array_keys($this->mod->getGroups()));
	        $this->players[$guid]->say($this->mod->getLngString("availableGroups", array("<GROUPS>"), array($list)));
	        return;
	    }

	    $tochange = $this->mod->findPlayerGuid($player);

		if (!$tochange) {
			$this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($player)));
			return;
		}

		$this->players[$tochange]->setGroup($group);

		$this->mod->rconSay($this->mod->getLngString("groupChanged", array("<GROUP>", "<PLAYER_NAME>"), array($this->mod->getLongGroupName($group), $this->players[$tochange]->getName())));

	}

	public function online($guid, $parameters) {
	    $admins = $this->mod->getAdmins();
	    $online = array();
	    foreach ($admins as $adminguid => $admin) {
	        if (array_key_exists($adminguid, $this->players)) {
	            $online[] = array(
	               "nick" => $this->players[$adminguid]->getName(),
	               "group" => $this->players[$adminguid]->getGroup()
	            );
	        }
	    }
	    $str = $this->mod->getLngString("onlineadmins") . " ";
	    if (count($online) > 0) {
    	    foreach ($online as $admin) {
    	        $str .= "^2" . $admin["nick"] . " ^1(" . $this->mod->getLongGroupName($admin["group"]) . ")^7, ";
    	    }
    	    $str = substr($str, 0, -4);
	    }
	    else {
	        $str .= $this->mod->getLngString("onlineAdminsNone");
	    }
	    $this->players[$guid]->say($str);
	}

	public function status($guid, $parameters) {
	    $parsed = $GLOBALS['parser']->getParsedLogLines();
	    $bytes = size($GLOBALS['parser']->getParsedBytes());
	    $time = makeuptime2(time() - STARTUPTIME);
	    $ram = size(memory_get_usage());

	    $msg = $this->mod->getLngString("status", array("<PARSEDLINES>", "<PARSEDBYTES>", "<UPTIME>", "<MEMUSAGE>"), array($parsed, $bytes, $time, $ram));
	    $this->mod->rconSay($msg);
	}

	public function whisper($guid, $parameters) {
	    $search = array_shift($parameters);
	    $msg = implode(" ", $parameters);

	    $player = $this->mod->findPlayerGuid($search);
	    if (!$player) {
	        $this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($parameters)));
	        return false;
	    }

	    $this->players[$player]->say($msg);
	}

	public function getip($guid, $parameters) {
	    $parameters = implode(" ", $parameters);

	    $player = $this->mod->findPlayerGuid($parameters);
	    if (!$player) {
	        $this->players[$guid]->say($this->mod->getLngString("playerNotFound", array("<SEARCH>"), array($parameters)));
	        return false;
	    }

	    $status = $this->mod->rconPlayerList();
	    foreach ($status as $line) {
	        if ($line["pid"] == $this->players[$player]->getPid() || $line["guid"] == $player) {
	            $ip = $line["ip"];
	            break;
	        }
	    }

	    if (!isset($ip)) {
	        $this->players[$guid]->say($this->mod->getLngString("anyError"));
	        return;
	    }

	    $this->players[$guid]->say($this->mod->getLngString("getIp", array("<NAME>", "<IP>"), array($this->players[$player]->getName(), $ip)));


	    $timestamp = date("[d.m.y H:i:s]");

	    $h = fopen(LOGDIR . "/ips.log", "a");
	    fwrite($h, $timestamp . " " . $this->players[$player]->getName() . ": " . $ip . " ($player)\n");
	    fclose($h);
	}

}

?>