<?php

/*
  
===============
PLUGIN: chatlog
===============
Logging the Chat of the Server.

		[chatlog] 
		enabled = 1	; Enable/Disable the Plugin
		dateformat = "d.m.y H:i:s" ; Decide which Date/Time Format you wanna use.


@author manu
@modify voices
@license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
@version 1.0
*/


$mod->registerEvent("playerSay", "chatlog_write");

$mod->setDefaultCV("chatlog", "enabled", "1");
$mod->setDefaultCV("chatlog", "dateformat", "d.m.y H:i:s");

$chatlog_fp = fopen($logdir . "/chat.log", "a");

function chatlog_write($param) {
    list($guid, $text) = $param;

    global $players;
    global $chatlog_fp;
    global $mod;

	if(!$mod->getCV("chatlog", "enabled")) {
        return;
    }
	
    $timestamp = date($mod->getCV("chatlog", "dateformat"));
    $name = $players[$guid]->getName();
    $text = $mod->removecolor($text);

    fwrite($chatlog_fp, "$timestamp $name: $text\r\n");
}


?>
