<?php
/*
 * PB Violation Check Plugin
 *
 * Events:
 *      PlayerJoined
 *          A player who is joining the server will be banned if he is in the Punkbuster sv_cheats.log.
 * 
 * Config:
 *      [violationcheck]
 *		enabled = 1
 *		file = "../pb/sv_cheat.log"
 *		reason = "Violation Found"
 * 
 * @author Voices
 * @license Creative Commons BY-NC-SA 3.0 (http://www.creativecommons.org/licenses/by-nc-sa/3.0/)
 * @version 1.0
 */
$mod->registerEvent("playerJoined", "Violation_Check");

$mod->setDefaultCV("violationcheck", "enabled", "0");
$mod->setDefaultCV("violationcheck", "file", "../pb/sv_cheat.log");
$mod->setDefaultCV("violationcheck", "reason", "Violation Found");

function Violation_Check($guid) {
    global $players;
    global $mod;
	
	if(!$mod->getCV("violationcheck", "enabled")) {
        return;
    }
	
	if (!file_exists($mod->getCV("violationcheck", "file"))) {
		return;
	}

	$cheatlog = file_get_contents($mod->getCV("violationcheck", "file"), null);
	
	if(strpos($cheatlog, $guid)!==false) 
	{
		$players[$guid]->ban($mod->getCV("violationcheck", "reason"), $guid);
	}
}

?>