<?php include '_partials/header.php'; ?>

<form method="POST" action="index.php" class="form-search">
	<input name="q" placeholder="Name or GUID" class="search-query" type="text">
	<button class="btn" type="submit">Search</button>
</form>

<table class="table table-striped table-hover">
	<thead>
		<tr>
			<td>Name</td>
			<td>Kills</td>
			<td>Deaths</td>
			<td>K/D</td>
			<td>Headshots</td>
			<td>HS Ratio</td>
		</tr>
	</thead>
	<tbody class="userlist">
	<?php foreach( $users as $u ) {
			$nicks = explode(';', $u->nicks);
			$nicks = array_map('htmlentities', $nicks);;
			if($u->kills == 0) {
				$kd = 0;
			} elseif($u->deaths != 0) {
				$kd = round($u->kills / $u->deaths, 2);
			} else {
				$kd = "Infinty";
			}
			$hsratio = ( $u->kills != 0) ? round($u->headshots / $u->kills * 100, 2) : 0;
			echo "<tr data-user_id=\"{$u->id}\"><td><a href=\"user.php?id={$u->id}\">{$nicks[0]}</a></td><td>{$u->kills}</td><td>{$u->deaths}</td><td>{$kd}</td><td>{$u->headshots}</td><td>{$hsratio} %</td></tr>";
	} ?>

	<script id="user_list_template" type="text/x-handlebars-template">
		{{#each this}}
		<tr data-user_id={{id}}>
			<td><a href=user.php?id={{id}}>{{firstName this}}</a></td>
			<td>{{kills}}</td>
			<td>{{deaths}}</td>
			<td>{{kd this}}</td>
			<td>{{headshots}}</td>
			<td>{{hsr this}} %</td>
		</tr>
		{{/each}}
	</script>
	</tbody>
</table>


<div id="myModal" class="modal hide fade">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" data-target="myModal">&times;</button>
			<h3 id="myModalLabel"><i class="icon-user"></i> Nicknames</h3>
		</div>
		<div class="modal-body">
			<p>
				<ul id="userinfo">
					<script id="user_info_template" type="text/x-handlebars-template">
					{{#each this}}
						<li>{{nick}}</li>
					{{/each}}
					</script>
				</ul>
			</p>
		</div>
		<div class="modal-footer">
			<button class="btn" data-dismiss="modal" data-target="myModal" >Close</button>
		</div>
	</div>

<?php include '_partials/footer.php'; ?>