<?php

/*

[serverinfo]
enabled = 1
servers = "192.168.2.11:28960;192.168.2.11:28961";
message = "{IP} {SERVERNAME} ^7 => Players: ^2{CURRENT_PLAYERS}/{MAX_PLAYERS}";
offline = "{IP} ^7is ^1OFFLINE"
interval = 300

*/


$mod->setDefaultCV("serverinfo", "enabled", 0);
$mod->setDefaultCV("serverinfo", "servers", "");
$mod->setDefaultCV("serverinfo", "message", "^1{IP} ^7{SERVERNAME} ^7 => Players: ^2{CURRENT_PLAYERS}/{MAX_PLAYERS} ^7 Map: ^2{MAPNAME} ({GAMETYPE})");
$mod->setDefaultCV("serverinfo", "offline", "{IP} ^7is ^1OFFLINE");
$mod->setDefaultCV("serverinfo", "interval", 300);

$serverinfo = new serverinfo();
$serverinfo->readServers();

$mod->registerEvent("everyTime", "trigger", $serverinfo);
$mod->registerEvent("parseConfig", "readServers", $serverinfo);


class serverinfo {
    private $mod = false;
    private $lastsend = 0;
    private $servers = array();
    private $current = 0;

    public function __construct() {
        $this->mod = &$GLOBALS["mod"];
        $this->lastsend = time();
    }

    private function getInfo($ip, $port) {
        try {
            $con = new q3query($ip, $port);
        }
        catch (Exception $e) {
            return;
        }

        $info = $con->getGameInfo();
        if (!$info) {
            $con->quit();
            return false;
        }
        $info["ping"] = $con->getLastPing();
        $info["hc"] = (isset($info["hc"])) ? $info["hc"] : 0;
        $info["kc"] = (isset($info["kc"])) ? $info["kc"] : 0;
        $info["ff"] = (isset($info["ff"])) ? $info["ff"] : 0;
        $info["od"] = (isset($info["od"])) ? $info["od"] : 0;
        $info["pb"] = (isset($info["pb"])) ? $info["pb"] : 0;
        $info["pure"] = (isset($info["pure"])) ? $info["pure"] : 0;
        $info["mod"] = (isset($info["mod"])) ? $info["mod"] : 0;
        $info["pswrd"] = (isset($info["pswrd"])) ? $info["pswrd"] : 0;
        $info["clients"] = (isset($info["clients"])) ? $info["clients"] : 0;
        $info["protocol"] = (isset($info["protocol"])) ? $info["protocol"] : "unknown";

        $con->quit();

        return $info;
    }

    public function readServers() {
        if (!$this->mod->getCV("serverinfo", "enabled")) return;
        $this->servers = array();
        $ips = explode(";", $this->mod->getCV("serverinfo", "servers"));
        foreach ($ips as $address) {
            if (preg_match('|^(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}):(\d{1,5})$|', $address, $subpatterns)) {
                $this->servers[] = array("ip" => $subpatterns[1], "port" => $subpatterns[2]);
            }
        }
        $this->current = 0;
    }

    public function trigger() {
        if (!$this->mod->getCV("serverinfo", "enabled")) return;
        if (count($this->servers) == 0) return;

        if (time() - $this->lastsend < $this->mod->getCV("serverinfo", "interval")) return;

        $info = $this->getInfo($this->servers[$this->current]["ip"], $this->servers[$this->current]["port"]);

        if (!$info) {
            $search[]  = "{IP}";
            $replace[] = $this->servers[$this->current]["ip"] . ":" . $this->servers[$this->current]["port"];
            $msg = str_replace($search, $replace, $this->mod->getCV("serverinfo", "offline"));
            $this->mod->rconSay($msg);
        }
        else {
            $search[] = "{SERVERNAME}";
            $search[] = "{MAX_PLAYERS}";
            $search[] = "{CURRENT_PLAYERS}";
            $search[] = "{IP}";
            $search[] = "{MAPNAME}";
            $search[] = "{GAMETYPE}";
            $search[] = "{PING}";
            $replace[] = $info["hostname"];
            $replace[] = $info["sv_maxclients"];
            $replace[] = $info["clients"];
            $replace[] = $this->servers[$this->current]["ip"] . ":" . $this->servers[$this->current]["port"];
            $replace[] = $this->mod->getLongMapName($info["mapname"]);
            $replace[] = $this->mod->getLongGametype($info["gametype"]);
            $replace[] = $info["ping"];

            $msg = str_replace($search, $replace, $this->mod->getCV("serverinfo", "message"));
            $this->mod->rconSay($msg);
        }

        $this->lastsend = time();
        $this->current ++;
        if (!array_key_exists($this->current, $this->servers)) {
            $this->current = 0;
        }

    }

}


?>