var Users = {
	init: function( config ) {
		this.config = config;

		this.setupTemplates();
		this.bindEvents();

		$.ajaxSetup({
			url: 'index.php',
			type: 'POST'
		});

	$('button').remove(); // not needed if js is enabled
	},

	bindEvents: function() {
		this.config.searchBox.on( 'keyup', this.searchUsers );
	},

	setupTemplates: function() {
		this.config.userListTemplate = Handlebars.compile( this.config.userListTemplate );

		Handlebars.registerHelper( 'kd', function( user ) {
			return (user.deaths != 0) ? Math.round(user.kills / user.deaths * 100) / 100 : (user.kills != 0) ? "Infinity" : 0; 
		});
		Handlebars.registerHelper( 'hsr', function( user ) {
			return (user.kills != 0) ? Math.round(user.headshots / user.kills * 10000) / 100 : 0;
		});
		Handlebars.registerHelper( 'firstName', function( user ) {
			return user.nicks.split(';')[0];
		});
	},

	searchUsers: function( e ) {
		var self = Users;
		var delay = (function(){
			var timer = 0;
			return function(callback, ms){
				clearTimeout (timer);
				timer = setTimeout(callback, ms);
			};
		})();
		delay(function(){
			$.ajax({
				data: self.config.form.serialize(),
				dataType: 'json',
				success: function(results) {
					self.config.userList.empty();

					if ( results[0] ) {
						console.log(results);
						self.config.userList.append( self.config.userListTemplate( results ) );
					} else {
						self.config.userList.append('<tr><td colspan="6">Nothing found</td></tr>');
					}
				}
			});


		}, self.config.delay );
	}
};

Users.init({
	searchBox: $('input[name="q"]'),
	form: $('form.form-search'),
	userListTemplate: $('#user_list_template').html(),
	userList: $('tbody'),
	delay: 1000 //Delay for ajax request after keyup to wait till user stops typing
});